/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.mvstore.type.DataType;

public class SpatialDataType
implements DataType {
    private final int dimensions;

    public SpatialDataType(int n) {
        DataUtils.checkArgument(n >= 1 && n < 256, "Dimensions must be between 1 and 255, is {0}", n);
        this.dimensions = n;
    }

    @Override
    public int compare(Object object, Object object2) {
        long l;
        long l2 = ((SpatialKey)object).getId();
        return l2 < (l = ((SpatialKey)object2).getId()) ? -1 : (l2 > l ? 1 : 0);
    }

    public boolean equals(Object object, Object object2) {
        long l;
        long l2 = ((SpatialKey)object).getId();
        return l2 == (l = ((SpatialKey)object2).getId());
    }

    @Override
    public int getMemory(Object object) {
        return 40 + this.dimensions * 4;
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        int n;
        SpatialKey spatialKey = (SpatialKey)object;
        int n2 = 0;
        for (n = 0; n < this.dimensions; ++n) {
            if (spatialKey.min(n) != spatialKey.max(n)) continue;
            n2 |= 1 << n;
        }
        writeBuffer.putVarInt(n2);
        for (n = 0; n < this.dimensions; ++n) {
            writeBuffer.putFloat(spatialKey.min(n));
            if ((n2 & 1 << n) != 0) continue;
            writeBuffer.putFloat(spatialKey.max(n));
        }
        writeBuffer.putVarLong(spatialKey.getId());
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        int n = DataUtils.readVarInt(byteBuffer);
        float[] fArray = new float[this.dimensions * 2];
        for (int i = 0; i < this.dimensions; ++i) {
            float f = byteBuffer.getFloat();
            float f2 = (n & 1 << i) != 0 ? f : byteBuffer.getFloat();
            fArray[i + i] = f;
            fArray[i + i + 1] = f2;
        }
        long l = DataUtils.readVarLong(byteBuffer);
        return new SpatialKey(l, fArray);
    }

    public boolean isOverlap(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(spatialKey.max(i) < spatialKey2.min(i)) && !(spatialKey.min(i) > spatialKey2.max(i))) continue;
            return false;
        }
        return true;
    }

    public void increaseBounds(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int i = 0; i < this.dimensions; ++i) {
            spatialKey.setMin(i, Math.min(spatialKey.min(i), spatialKey2.min(i)));
            spatialKey.setMax(i, Math.max(spatialKey.max(i), spatialKey2.max(i)));
        }
    }

    public float getAreaIncrease(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        float f = spatialKey.min(0);
        float f2 = spatialKey.max(0);
        float f3 = f2 - f;
        f = Math.min(f, spatialKey2.min(0));
        f2 = Math.max(f2, spatialKey2.max(0));
        float f4 = f2 - f;
        for (int i = 1; i < this.dimensions; ++i) {
            f = spatialKey.min(i);
            f2 = spatialKey.max(i);
            f3 *= f2 - f;
            f = Math.min(f, spatialKey2.min(i));
            f2 = Math.max(f2, spatialKey2.max(i));
            f4 *= f2 - f;
        }
        return f4 - f3;
    }

    float getCombinedArea(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        float f = 1.0f;
        for (int i = 0; i < this.dimensions; ++i) {
            float f2 = Math.min(spatialKey.min(i), spatialKey2.min(i));
            float f3 = Math.max(spatialKey.max(i), spatialKey2.max(i));
            f *= f3 - f2;
        }
        return f;
    }

    public boolean contains(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(spatialKey.min(i) > spatialKey2.min(i)) && !(spatialKey.max(i) < spatialKey2.max(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(spatialKey.min(i) <= spatialKey2.min(i)) && !(spatialKey.max(i) >= spatialKey2.max(i))) continue;
            return false;
        }
        return true;
    }

    Object createBoundingBox(Object object) {
        float[] fArray = new float[this.dimensions * 2];
        SpatialKey spatialKey = (SpatialKey)object;
        for (int i = 0; i < this.dimensions; ++i) {
            fArray[i + i] = spatialKey.min(i);
            fArray[i + i + 1] = spatialKey.max(i);
        }
        return new SpatialKey(0L, fArray);
    }

    public int[] getExtremes(ArrayList<Object> arrayList) {
        float f;
        int n;
        SpatialKey spatialKey = (SpatialKey)this.createBoundingBox(arrayList.get(0));
        SpatialKey spatialKey2 = (SpatialKey)this.createBoundingBox(spatialKey);
        for (n = 0; n < this.dimensions; ++n) {
            float f2 = spatialKey2.min(n);
            spatialKey2.setMin(n, spatialKey2.max(n));
            spatialKey2.setMax(n, f2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Object object = arrayList.get(n);
            this.increaseBounds(spatialKey, object);
            this.increaseMaxInnerBounds(spatialKey2, object);
        }
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            float f3;
            float f4;
            f = spatialKey2.max(i) - spatialKey2.min(i);
            if (f < 0.0f || !((double)(f4 = f / (f3 = spatialKey.max(i) - spatialKey.min(i))) > d)) continue;
            d = f4;
            n2 = i;
        }
        if (d <= 0.0) {
            return null;
        }
        float f5 = spatialKey2.min(n2);
        f = spatialKey2.max(n2);
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < arrayList.size() && (n3 < 0 || n4 < 0); ++i) {
            SpatialKey spatialKey3 = (SpatialKey)arrayList.get(i);
            if (n3 < 0 && spatialKey3.max(n2) == f5) {
                n3 = i;
                continue;
            }
            if (n4 >= 0 || spatialKey3.min(n2) != f) continue;
            n4 = i;
        }
        return new int[]{n3, n4};
    }

    private void increaseMaxInnerBounds(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int i = 0; i < this.dimensions; ++i) {
            spatialKey.setMin(i, Math.min(spatialKey.min(i), spatialKey2.max(i)));
            spatialKey.setMax(i, Math.max(spatialKey.max(i), spatialKey2.min(i)));
        }
    }
}

