/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.modelling.arima.AbstractModelController;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.ModelComparator;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;

public class SeasonalUnderDifferencingTest2
extends AbstractModelController {
    private static final double DEF_SBOUND = 0.91;

    @Override
    public ProcessingResult process(ModellingContext context) {
        ModellingContext scontext;
        PreprocessingModel smodel;
        if (context.description.getFrequency() == 1) {
            return ProcessingResult.Unprocessed;
        }
        SarimaSpecification spec = context.description.getSpecification();
        if (spec.getBD() == 1 || spec.getBQ() == 1 || context.originalSeasonalityTest == 0) {
            return ProcessingResult.Unchanged;
        }
        if (spec.getBP() == 1) {
            boolean hasmh;
            TsVariableList x = context.description.buildRegressionVariables();
            boolean hastd = !x.selectCompatible(ICalendarVariable.class).isEmpty();
            boolean bl = hasmh = !x.selectCompatible(IMovingHolidayVariable.class).isEmpty();
            if (!hastd && !hasmh) {
                return ProcessingResult.Unchanged;
            }
        }
        if ((smodel = (scontext = this.buildNewModel(context)).tmpModel()) == null) {
            return ProcessingResult.Failed;
        }
        if (new ModelComparator().compare(smodel, context.tmpModel()) < 0) {
            this.transferInformation(scontext, context);
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    private ModellingContext buildNewModel(ModellingContext context) {
        ModellingContext ncontext = new ModellingContext();
        ModelDescription ndesc = context.description.clone();
        SarimaSpecification spec = ndesc.getSpecification();
        spec.setBP(0);
        spec.setBD(1);
        spec.setBQ(1);
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        ncontext.description = ndesc;
        if (!this.estimate(ncontext, false)) {
            return null;
        }
        return ncontext;
    }
}

