/*
 * Decompiled with CFR 0.152.
 */
package org.ecdc.epitweetr.fs;

import demy.storage.FSNode;
import demy.storage.Storage;
import demy.storage.WriteMode;
import demy.storage.WriteMode$append$;
import demy.storage.WriteMode$failIfExists$;
import demy.util.log$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.ecdc.epitweetr.Settings;
import org.ecdc.epitweetr.fs.Aggregation;
import org.ecdc.epitweetr.fs.Collection;
import org.ecdc.epitweetr.fs.EpiSerialisation$;
import org.ecdc.epitweetr.fs.GeolocatedTweet;
import org.ecdc.epitweetr.fs.IndexHolder;
import org.ecdc.epitweetr.fs.IndexHolder$;
import org.ecdc.epitweetr.fs.LuceneActor$;
import org.ecdc.epitweetr.fs.QuerySort$;
import org.ecdc.epitweetr.fs.TopicTweetsV1;
import org.ecdc.epitweetr.fs.TweetIndex;
import org.ecdc.epitweetr.fs.TweetIndex$;
import org.ecdc.epitweetr.fs.TweetV1;
import org.ecdc.epitweetr.fs.TweetsV1;
import org.ecdc.epitweetr.geo.Geonames;
import org.ecdc.epitweetr.geo.Geonames$;
import org.ecdc.twitter.Language;
import org.ecdc.twitter.schemas$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import spray.json.JsonParser$;
import spray.json.ParserInput;
import spray.json.ParserInput$;

public final class LuceneActor$ {
    public static LuceneActor$ MODULE$;
    private IndexHolder holder;
    private final Map<String, Option<String>> defaultTextLangCols;
    private volatile boolean bitmap$0;

    static {
        new LuceneActor$();
    }

    private IndexHolder holder$lzycompute() {
        LuceneActor$ luceneActor$ = this;
        synchronized (luceneActor$) {
            if (!this.bitmap$0) {
                this.holder = this.getHolder(true);
                this.bitmap$0 = true;
            }
        }
        return this.holder;
    }

    public IndexHolder holder() {
        return !this.bitmap$0 ? this.holder$lzycompute() : this.holder;
    }

    public IndexHolder getHolder(boolean writeEnabled) {
        boolean x$1 = writeEnabled;
        Option<SparkSession> x$2 = IndexHolder$.MODULE$.apply$default$1();
        HashMap<String, String> x$3 = IndexHolder$.MODULE$.apply$default$2();
        HashMap<String, TweetIndex> x$4 = IndexHolder$.MODULE$.apply$default$3();
        HashMap<String, Dataset<Row>> x$5 = IndexHolder$.MODULE$.apply$default$5();
        boolean x$6 = IndexHolder$.MODULE$.apply$default$6();
        boolean x$7 = IndexHolder$.MODULE$.apply$default$7();
        boolean x$8 = IndexHolder$.MODULE$.apply$default$8();
        Option<Dataset<Object>> x$9 = IndexHolder$.MODULE$.apply$default$9();
        HashSet<String> x$10 = IndexHolder$.MODULE$.apply$default$10();
        return new IndexHolder(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10);
    }

    public void commitRequest(IndexHolder holder, ExecutionContext ec) {
        boolean dismissCommit = false;
        HashMap<String, String> hashMap = holder.dirs();
        synchronized (hashMap) {
            if (holder.commiting()) {
                dismissCommit = true;
            } else {
                holder.commiting_$eq(true);
            }
        }
        if (!dismissCommit) {
            Thread thread = new Thread(holder, ec){
                private final IndexHolder holder$9;
                private final ExecutionContext ec$1;

                public void run() {
                    Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        boolean geoStopped = false;
                        boolean aggrStopped = false;
                        boolean messageShown = false;
                        while (!geoStopped || !aggrStopped) {
                            HashMap<String, String> hashMap = $this.holder$9.dirs();
                            synchronized (hashMap) {
                                if (!$this.holder$9.geolocating()) {
                                    $this.holder$9.geolocating_$eq(true);
                                    geoStopped = true;
                                }
                                if (geoStopped && !$this.holder$9.aggregating()) {
                                    $this.holder$9.aggregating_$eq(true);
                                    aggrStopped = true;
                                }
                            }
                            if (geoStopped && aggrStopped) continue;
                            if (!messageShown) {
                                log$.MODULE$.msg(new StringBuilder(85).append("Delaying commit request to finish before. Waiting geolocation: ").append(!geoStopped).append(". Waiting aggregation ").append(!aggrStopped).toString());
                                messageShown = true;
                            }
                            Thread.sleep(1000L);
                        }
                        LuceneActor$.MODULE$.commit($this.holder$9);
                        $this.holder$9.geolocating_$eq(false);
                        $this.holder$9.aggregating_$eq(false);
                        $this.holder$9.commiting_$eq(false);
                    }, this.ec$1).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        anon.1.$anonfun$run$2(x0$1);
                        return BoxedUnit.UNIT;
                    }, this.ec$1);
                }

                public static final /* synthetic */ void $anonfun$run$2(Try x0$1) {
                    Try try_ = x0$1;
                    if (try_ instanceof Success) {
                        log$.MODULE$.msg("Commit request finished successfully");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable f = failure.exception();
                        log$.MODULE$.msg(new StringBuilder(31).append("Commit request failed with ").append(f.getMessage()).append(" \n ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.getStackTrace())).mkString("\n")).append(" ").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }
                {
                    this.holder$9 = holder$9;
                    this.ec$1 = ec$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.ecdc.epitweetr.fs.LuceneActor$$anon$1 ), $anonfun$run$2$adapted(scala.util.Try )}, serializedLambda);
                }
            };
            thread.start();
        } else {
            log$.MODULE$.msg("Commit request dismissed since already requesteed");
        }
        Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> "In progress", ec);
    }

    public void commit(IndexHolder holder) {
        this.commit(true, holder);
    }

    public void commit(boolean closeDirectory, IndexHolder holder) {
        block4: {
            long now = System.nanoTime();
            HashMap<String, String> hashMap = holder.dirs();
            synchronized (hashMap) {
                holder.dirs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    LuceneActor$.$anonfun$commit$1(holder, closeDirectory, x0$1);
                    return BoxedUnit.UNIT;
                });
                if (closeDirectory) {
                    holder.indexes().clear();
                    holder.dirs().clear();
                }
            }
            if (!closeDirectory) break block4;
            log$.MODULE$.msg(new StringBuilder(20).append("commit done on ").append((System.nanoTime() - now) / 1000000000L).append(" secs").toString());
        }
    }

    public boolean commit$default$1() {
        return true;
    }

    public void closeSparkSession(IndexHolder holder) {
        Option<SparkSession> option = holder.spark();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession spark = (SparkSession)some.value();
            spark.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public TweetIndex getIndex(String collection, Instant forInstant, Settings conf, IndexHolder holder) {
        return this.getIndex(collection, this.getIndexKey(collection, forInstant), conf, holder);
    }

    public TweetIndex getIndex(String collection, String key, Settings conf, IndexHolder holder) {
        String path = new StringBuilder(1).append(collection).append(".").append(key).toString();
        HashMap<String, String> hashMap = holder.dirs();
        synchronized (hashMap) {
            if (!holder.dirs().contains((Object)path)) {
                conf.load();
                holder.dirs().update((Object)path, (Object)((Object)Paths.get(conf.epiHome(), "fs", collection, key)).toString());
            }
            if (holder.indexes().get((Object)path).isEmpty() || !((TweetIndex)holder.indexes().apply((Object)path)).isOpen()) {
                holder.indexes().update((Object)path, (Object)TweetIndex$.MODULE$.apply((String)holder.dirs().apply((Object)path), holder.writeEnabled()));
            }
        }
        return (TweetIndex)holder.indexes().apply((Object)path);
    }

    public String getIndexKey(String collection, Instant forInstant) {
        String string = collection;
        String string2 = "tweets".equals(string) ? "week" : ("country_counts".equals(string) ? "week" : ("topwords".equals(string) ? "week" : ("geolocated".equals(string) ? "week" : "week")));
        String timing = string2;
        String string3 = timing;
        if (!"week".equals(string3)) {
            throw new Exception(new StringBuilder(31).append("Unknon grouping for collection ").append(collection).toString());
        }
        String string4 = (String)new Some((Object)LocalDateTime.ofInstant(forInstant, ZoneOffset.UTC)).map((Function1 & Serializable & scala.Serializable)utc -> String.valueOf(BoxesRunTime.boxToInteger((int)(utc.get(IsoFields.WEEK_BASED_YEAR) * 100 + utc.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR))))).map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(s)).take(4)).append(".").append(s.substring(4)).toString()).get();
        return string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> getReadKeys(String collection, Option<Instant> from, Option<Instant> to, Settings conf, IndexHolder holder) {
        Tuple2 tuple2 = new Tuple2(from, to);
        Path sPath = Paths.get(conf.fsRoot(), collection);
        if (tuple2 == null) return !Files.exists(sPath, new LinkOption[0]) ? (Seq)Nil$.MODULE$ : (Seq)((SeqLike)((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(sPath).iterator()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)p -> ((Object)p.getFileName()).toString(), Seq$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$6(from, collection, to, p)))).sortWith((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$7(x$8, x$9)));
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return !Files.exists(sPath, new LinkOption[0]) ? (Seq)Nil$.MODULE$ : (Seq)((SeqLike)((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(sPath).iterator()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)p -> ((Object)p.getFileName()).toString(), Seq$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$6(from, collection, to, p)))).sortWith((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$7(x$8, x$9)));
        Some some = (Some)option;
        Instant f = (Instant)some.value();
        if (!(option2 instanceof Some)) return !Files.exists(sPath, new LinkOption[0]) ? (Seq)Nil$.MODULE$ : (Seq)((SeqLike)((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(sPath).iterator()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)p -> ((Object)p.getFileName()).toString(), Seq$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$6(from, collection, to, p)))).sortWith((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$7(x$8, x$9)));
        Some some2 = (Some)option2;
        Instant t = (Instant)some2.value();
        return (Seq)((SeqLike)((TraversableLike)((SeqLike)((TraversableLike)scala.package$.MODULE$.Range().apply(0, (int)ChronoUnit.DAYS.between(f, t.plus(1L, ChronoUnit.DAYS))).map((Function1 & Serializable & scala.Serializable)i -> f.plus((long)BoxesRunTime.unboxToInt((Object)i), ChronoUnit.DAYS), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.getIndexKey(collection, (Instant)i), IndexedSeq$.MODULE$.canBuildFrom())).distinct()).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$3(conf, collection, key)))).sortWith((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$getReadKeys$4(x$6, x$7)));
    }

    public Seq<TweetIndex> getReadIndexes(String collection, Option<Instant> from, Option<Instant> to, Settings conf, IndexHolder holder) {
        return (Seq)this.getReadKeys(collection, from, to, conf, holder).map((Function1 & Serializable & scala.Serializable)key -> MODULE$.getIndex(collection, (String)key, conf, holder), Seq$.MODULE$.canBuildFrom());
    }

    public void add2Geolocate(TopicTweetsV1 tweets, Option<Map<String, String>> forcedGeo, Option<Map<String, String>> forcedGeoCodes, Option<Set<String>> topics, Settings conf, IndexHolder holder, ExecutionContext ec) {
        BooleanRef goGeo = BooleanRef.create((boolean)false);
        Product st = conf.getSparkStorage();
        HashMap<String, String> hashMap = holder.dirs();
        synchronized (hashMap) {
            Object object;
            FSNode toGeo = ((Storage)st).getNode(conf.togeolocatePath(), ((Storage)st).getNode$default$2());
            if (tweets.tweets().items().size() > 0) {
                Object object2 = toGeo.exists() ? toGeo.setContent("\n", (WriteMode)WriteMode$append$.MODULE$) : BoxedUnit.UNIT;
                object = toGeo.setContent(EpiSerialisation$.MODULE$.topicTweetsFormat().write((Object)tweets).toString(), (WriteMode)WriteMode$append$.MODULE$);
            } else {
                object = BoxedUnit.UNIT;
            }
            FSNode geolocating = ((Storage)st).getNode(conf.geolocatingPath(), ((Storage)st).getNode$default$2());
            if (toGeo.exists() && !geolocating.exists()) {
                toGeo.move(geolocating, WriteMode$failIfExists$.MODULE$);
            }
            if (!holder.geolocating() && !holder.commiting()) {
                holder.geolocating_$eq(true);
                goGeo.elem = true;
            }
        }
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!goGeo$1.elem) break block0;
                SparkSession spark = conf.getSparkSession();
                MODULE$.geolocateTweets(forcedGeo, forcedGeoCodes, topics, spark, conf, (Storage)st, holder);
                MODULE$.add2Aggregate(conf, holder, ec);
                FSNode geolocating = ((Storage)st).getNode(conf.geolocatingPath(), ((Storage)st).getNode$default$2());
                geolocating.delete(geolocating.delete$default$1());
                holder.geolocating_$eq(false);
            }
        }, ec).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LuceneActor$.$anonfun$add2Geolocate$2(holder, x0$1);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public boolean tooBigToGeolocate(Settings conf) {
        Product st = conf.getSparkStorage();
        long biggest = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)new .colon.colon((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Storage)st).getNode(conf.toaggregatePath(), ((Storage)st).getNode$default$2()).getFileSize()).toOption(), (List)new .colon.colon((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Storage)st).getNode(conf.aggregatingPath(), ((Storage)st).getNode$default$2()).getFileSize()).toOption(), (List)new .colon.colon((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Storage)st).getNode(conf.geolocatingPath(), ((Storage)st).getNode$default$2()).getFileSize()).toOption(), (List)new .colon.colon((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((Storage)st).getNode(conf.togeolocatePath(), ((Storage)st).getNode$default$2()).getFileSize()).toOption(), (List)Nil$.MODULE$))))).flatMap((Function1 & Serializable & scala.Serializable)e -> Option$.MODULE$.option2Iterable(e), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(a, b) -> a > b ? a : b).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        return biggest > 1048576000L;
    }

    public void add2Aggregate(Settings conf, IndexHolder holder, ExecutionContext ec) {
        BooleanRef goAggr = BooleanRef.create((boolean)false);
        Product st = conf.getSparkStorage();
        FSNode toAggr = ((Storage)st).getNode(conf.toaggregatePath(), ((Storage)st).getNode$default$2());
        FSNode aggregating = ((Storage)st).getNode(conf.aggregatingPath(), ((Storage)st).getNode$default$2());
        FSNode geolocating = ((Storage)st).getNode(conf.geolocatingPath(), ((Storage)st).getNode$default$2());
        HashMap<String, String> hashMap = holder.dirs();
        synchronized (hashMap) {
            if (geolocating.exists()) {
                Object object = toAggr.exists() ? toAggr.setContent("\n", (WriteMode)WriteMode$append$.MODULE$) : BoxedUnit.UNIT;
                BooleanRef firstLine = BooleanRef.create((boolean)true);
                geolocating.getContentAsLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
                    LuceneActor$.$anonfun$add2Aggregate$1(toAggr, firstLine, line);
                    return BoxedUnit.UNIT;
                });
            }
            if (toAggr.exists() && !aggregating.exists()) {
                toAggr.move(aggregating, WriteMode$failIfExists$.MODULE$);
            }
            if (!holder.aggregating()) {
                holder.aggregating_$eq(true);
                goAggr.elem = true;
            }
        }
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!goAggr$1.elem) break block0;
                SparkSession spark = conf.getSparkSession();
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(Paths.get(conf.collectionPath(), new String[0])).iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)p -> {
                    String content = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.lines(p, StandardCharsets.UTF_8).iterator()).asScala()).mkString("\n");
                    return new Some(EpiSerialisation$.MODULE$.collectionFormat().read(JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(content)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        LuceneActor$.$anonfun$add2Aggregate$4(spark, conf, x0$1);
                        return BoxedUnit.UNIT;
                    });
                });
                FSNode aggregating = ((Storage)st).getNode(conf.aggregatingPath(), ((Storage)st).getNode$default$2());
                aggregating.delete(aggregating.delete$default$1());
                holder.aggregating_$eq(false);
            }
        }, ec).onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> {
            LuceneActor$.$anonfun$add2Aggregate$5(holder, x0$2);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Map<String, Option<String>> defaultTextLangCols() {
        return this.defaultTextLangCols;
    }

    public void geolocateTweets(Option<Map<String, String>> forcedGeo, Option<Map<String, String>> forcedGeoCodes, Option<Set<String>> topics, SparkSession spark, Settings conf, Storage storage, IndexHolder holder) {
        Some some;
        SparkContext sparkContext = spark.sparkContext();
        long l = System.nanoTime();
        Option<Dataset<Object>> option = holder.toGeolocate();
        if (option instanceof Some) {
            some = holder.toGeolocate();
        } else if (None$.MODULE$.equals(option)) {
            int par = 50;
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)par), (Integral)Numeric.IntIsIntegral$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).repartition(par, (Ordering)Ordering.Int$.MODULE$);
            boolean x$1 = qual$1.unpersist$default$1();
            RDD qual$2 = qual$1.unpersist(x$1);
            Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)iter -> iter.flatMap((Function1 & Serializable & scala.Serializable)i -> LuceneActor$.$anonfun$geolocateTweets$2(conf, par, BoxesRunTime.unboxToInt((Object)i)));
            boolean x$3 = qual$2.mapPartitions$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_ecdc_epitweetr_fs_LuceneActor$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.ecdc.epitweetr.fs.TweetV1").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_ecdc_epitweetr_fs_LuceneActor$$typecreator5$1() {
                }
            }
            public final class Org_ecdc_epitweetr_fs_LuceneActor$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.ecdc.epitweetr.fs.TweetV1").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_ecdc_epitweetr_fs_LuceneActor$$typecreator9$1() {
                }
            }
            Geonames.Geolocate qual$3 = Geonames$.MODULE$.Geolocate(spark.implicits().rddToDatasetHolder(qual$2.mapPartitions((Function1)x$2, x$3, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ecdc_epitweetr_fs_LuceneActor$$typecreator5$1()))).toDF().as(spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_ecdc_epitweetr_fs_LuceneActor$$typecreator9$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "tweet"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("topic"), functions$.MODULE$.col("tweet.*")})));
            Map<String, Option<String>> x$4 = this.defaultTextLangCols();
            int x$5 = BoxesRunTime.unboxToInt((Object)conf.geolocationThreshold().get());
            int x$6 = 0;
            int x$7 = conf.geoNBefore();
            int x$8 = conf.geoNAfter();
            String x$9 = conf.splitter();
            Vector x$102 = (Vector)conf.languages().get();
            Geonames x$112 = conf.geonames();
            boolean x$12 = true;
            String x$13 = conf.langIndexPath();
            boolean x$14 = true;
            Option<Map<String, String>> x$15 = forcedGeo;
            Option<Map<String, String>> x$16 = forcedGeoCodes;
            Option<Set<String>> x$17 = topics;
            Seq<String> x$18 = qual$3.geolocate$default$12();
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_ecdc_epitweetr_fs_LuceneActor$$typecreator13$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.ecdc.epitweetr.fs.GeolocatedTweet").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.Instant").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_ecdc_epitweetr_fs_LuceneActor$$typecreator13$1() {
                }
            }
            some = new Some((Object)qual$3.geolocate(x$4, x$6, x$5, x$7, x$8, x$9, (Seq<Language>)x$102, x$112, x$12, x$13, x$14, x$18, x$15, x$16, x$17, storage).select((Seq)((TraversableLike)new .colon.colon((Object)functions$.MODULE$.col("topic"), (List)new .colon.colon((Object)functions$.MODULE$.col("lang"), (List)new .colon.colon((Object)functions$.MODULE$.col("tweet_id").as("id"), (List)new .colon.colon((Object)functions$.MODULE$.col("created_at"), (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)((TraversableLike)this.defaultTextLangCols().keys().toSeq().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append((String)c).append("_loc").toString(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.when(functions$.MODULE$.col(new StringBuilder(7).append((String)c).append(".geo_id").toString()).isNotNull(), (Object)functions$.MODULE$.struct((Seq)((TraversableLike)new .colon.colon((Object)"geo_id", (List)new .colon.colon((Object)"geo_name", (List)new .colon.colon((Object)"geo_code", (List)new .colon.colon((Object)"geo_type", (List)new .colon.colon((Object)"geo_country_code", (List)new .colon.colon((Object)"geo_longitude", (List)new .colon.colon((Object)"geo_latitude", (List)Nil$.MODULE$)))))))).map((Function1 & Serializable & scala.Serializable)cc -> functions$.MODULE$.col(new StringBuilder(1).append((String)c).append(".").append((String)cc).toString()), Seq$.MODULE$.canBuildFrom()))).as(c), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).withColumn("is_geo_located", functions$.MODULE$.when((Column)((TraversableOnce)this.defaultTextLangCols().keys().toSeq().map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(new StringBuilder(4).append((String)c).append("_loc").toString()).isNull(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> x$10.$amp$amp(x$11)), (Object)BoxesRunTime.boxToBoolean((boolean)false)).otherwise((Object)BoxesRunTime.boxToBoolean((boolean)true))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("topic"), functions$.MODULE$.col("id"), functions$.MODULE$.col("is_geo_located"), functions$.MODULE$.col("lang"), functions$.MODULE$.col("linked_place_full_name_loc"), functions$.MODULE$.col("linked_text_loc"), functions$.MODULE$.col("place_full_name_loc"), functions$.MODULE$.col("text_loc"), functions$.MODULE$.col("user_description_loc"), functions$.MODULE$.col("user_location_loc")})).as("geo"), functions$.MODULE$.col("created_at")})).as(spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_ecdc_epitweetr_fs_LuceneActor$$typecreator13$1()))).mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                HashMap indexes = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                return iter.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)LuceneActor$.$anonfun$geolocateTweets$13(indexes, conf, x0$2)));
            }, spark.implicits().newIntEncoder()));
        } else {
            throw new MatchError(option);
        }
        holder.toGeolocate_$eq((Option<Dataset<Object>>)some);
        long midTime = System.nanoTime();
        int numGeo = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((Dataset)holder.toGeolocate().get()).unpersist().collect())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        long endTime = System.nanoTime();
        this.commit(false, holder);
        log$.MODULE$.msg(new StringBuilder(29).append((double)(endTime - midTime) / 1.0E9).append(" secs for geolocating ").append(numGeo).append(" tweets").toString());
    }

    public void aggregateTweets(Collection collection, SparkSession spark, Settings conf) {
        long startTime = System.nanoTime();
        SparkContext sc = spark.sparkContext();
        IndexHolder holder = this.holder();
        String epiHome = conf.epiHome();
        Aggregation aggr = collection.aggregation();
        Seq columns = (Seq)aggr.columns().map((Function1 & Serializable & scala.Serializable)v -> (String)aggr.params().map((Function1 & Serializable & scala.Serializable)qPars -> (String)qPars.foldLeft(v, (Function2 & Serializable & scala.Serializable)(curr, iter) -> curr.replace(new StringBuilder(1).append("@").append(iter._1()).toString(), (CharSequence)iter._2()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> v), Seq$.MODULE$.canBuildFrom());
        Seq groupBy = (Seq)((TraversableLike)aggr.groupBy().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)v -> (String)aggr.params().map((Function1 & Serializable & scala.Serializable)qPars -> (String)qPars.foldLeft(v, (Function2 & Serializable & scala.Serializable)(curr, iter) -> curr.replace(new StringBuilder(1).append("@").append(iter._1()).toString(), (CharSequence)iter._2()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> v), Seq$.MODULE$.canBuildFrom());
        Seq filterBy = (Seq)((TraversableLike)aggr.filterBy().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)v -> (String)aggr.params().map((Function1 & Serializable & scala.Serializable)qPars -> (String)qPars.foldLeft(v, (Function2 & Serializable & scala.Serializable)(curr, iter) -> curr.replace(new StringBuilder(1).append("@").append(iter._1()).toString(), (CharSequence)iter._2()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> v), Seq$.MODULE$.canBuildFrom());
        Seq sortBy = (Seq)((TraversableLike)aggr.sortBy().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)v -> (String)aggr.params().map((Function1 & Serializable & scala.Serializable)qPars -> (String)qPars.foldLeft(v, (Function2 & Serializable & scala.Serializable)(curr, iter) -> curr.replace(new StringBuilder(1).append("@").append(iter._1()).toString(), (CharSequence)iter._2()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> v), Seq$.MODULE$.canBuildFrom());
        Seq sourceExp = (Seq)((TraversableLike)aggr.sourceExpressions().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)v -> (String)aggr.params().map((Function1 & Serializable & scala.Serializable)qPars -> (String)qPars.foldLeft(v, (Function2 & Serializable & scala.Serializable)(curr, iter) -> curr.replace(new StringBuilder(1).append("@").append(iter._1()).toString(), (CharSequence)iter._2()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> v), Seq$.MODULE$.canBuildFrom());
        Seq<String> pks = collection.pks();
        String collName = collection.name();
        String dateCol = collection.dateCol();
        int par = BoxesRunTime.unboxToInt((Object)conf.sparkCores().get());
        if (!holder.toAggregate().contains((Object)collection.name())) {
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)par), (Integral)Numeric.IntIsIntegral$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int());
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> iter.flatMap((Function1 & Serializable & scala.Serializable)i -> LuceneActor$.$anonfun$aggregateTweets$26(conf, par, collection, BoxesRunTime.unboxToInt((Object)i)));
            boolean x$2 = qual$1.mapPartitions$default$2();
            holder.toAggregate().update((Object)collection.name(), new Some((Object)qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class))).map((Function1 & Serializable & scala.Serializable)rdd -> rdd.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                IndexHolder h = MODULE$.holder();
                Settings c = new Settings(epiHome);
                conf.load();
                ObjectRef lastKey = ObjectRef.create((Object)"");
                ObjectRef index = ObjectRef.create(null);
                return iter.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$aggregateTweets$34(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$12 -> {
                    Some some;
                    Tuple3 tuple3 = x$12;
                    if (tuple3 != null) {
                        Object object;
                        String topic = (String)tuple3._1();
                        long id = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        String key = (String)tuple3._3();
                        String string = (String)lastKey$1.elem;
                        String string2 = key;
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            index$3.elem = MODULE$.getIndex("tweets", key, c, h);
                            object = ((TweetIndex)index$3.elem).refreshReader();
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        Option<String> option = ((TweetIndex)index$3.elem).searchTweet(id, topic);
                        if (option instanceof Some) {
                            Some some2 = (Some)option;
                            String s = (String)some2.value();
                            some = new Some((Object)s);
                        } else {
                            log$.MODULE$.msg(new StringBuilder(35).append("Cannot find tweet to aggregate ").append(key).append(", ").append(id).append(", ").append(topic).toString());
                            some = None$.MODULE$;
                        }
                    } else {
                        throw new MatchError((Object)tuple3);
                    }
                    Some some3 = some;
                    return some3;
                }).flatMap((Function1 & Serializable & scala.Serializable)ot -> Option$.MODULE$.option2Iterable(ot));
            }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class))).map((Function1 & Serializable & scala.Serializable)rdd -> spark.read().schema(schemas$.MODULE$.geoLocatedTweetSchema()).json(spark.createDataset(rdd, spark.implicits().newStringEncoder()))).map((Function1 & Serializable & scala.Serializable)df -> df.where(functions$.MODULE$.col("lang").isin((Seq)((TraversableLike)conf.languages().get()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.code(), Vector$.MODULE$.canBuildFrom())))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Dataset dataset = x0$3;
                Dataset dataset2 = sourceExp.size() > 0 ? dataset.select((Seq)sourceExp.map((Function1 & Serializable & scala.Serializable)s -> functions$.MODULE$.expr(s), Seq$.MODULE$.canBuildFrom())) : dataset;
                return dataset2;
            }).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Dataset dataset = x0$4;
                Dataset dataset2 = filterBy.size() > 0 ? dataset.where((Column)((TraversableOnce)filterBy.map((Function1 & Serializable & scala.Serializable)w -> functions$.MODULE$.expr(w), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$14, x$15) -> x$14.$amp$amp(x$15))) : dataset;
                return dataset2;
            }).get());
        }
        Dataset ds = (Dataset)new Some(holder.toAggregate().apply((Object)collection.name())).map((Function1 & Serializable & scala.Serializable)df -> df.unpersist()).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Dataset dataset = x0$5;
            Dataset dataset2 = groupBy.size() == 0 ? dataset.select((Seq)columns.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.expr(c), Seq$.MODULE$.canBuildFrom())) : dataset.groupBy((Seq)groupBy.map((Function1 & Serializable & scala.Serializable)gb -> functions$.MODULE$.expr(gb), Seq$.MODULE$.canBuildFrom())).agg(functions$.MODULE$.expr((String)columns.head()), (Seq)((TraversableLike)columns.drop(1)).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.expr(c), Seq$.MODULE$.canBuildFrom()));
            return dataset2;
        }).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Dataset dataset = x0$6;
            Dataset dataset2 = sortBy.size() == 0 ? dataset : dataset.orderBy((Seq)sortBy.map((Function1 & Serializable & scala.Serializable)ob -> functions$.MODULE$.expr(ob), Seq$.MODULE$.canBuildFrom()));
            return dataset2;
        }).map((Function1 & Serializable & scala.Serializable)df -> df.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            IndexHolder holder = MODULE$.holder();
            Settings conf = new Settings(epiHome);
            conf.load();
            ObjectRef lastKey = ObjectRef.create((Object)"");
            ObjectRef index = ObjectRef.create(null);
            long s = System.nanoTime();
            return iter.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)LuceneActor$.$anonfun$aggregateTweets$54(dateCol, lastKey, index, collName, conf, holder, pks, collection, row)));
        }, spark.implicits().newIntEncoder())).get();
        int numAggr = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])ds.collect())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.commit(false, holder);
        log$.MODULE$.msg(new StringBuilder(33).append((double)(System.nanoTime() - startTime) / 1.0E9).append(" secs for aggregating ").append(numAggr).append(" tweets in ").append(collection.name()).toString());
    }

    public void recalculateHash(IndexHolder holder, Settings conf, ExecutionContext ec) {
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(Paths.get(conf.collectionPath(), new String[0])).iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)p -> new Some((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.lines(p, StandardCharsets.UTF_8).iterator()).asScala()).mkString("\n")).map((Function1 & Serializable & scala.Serializable)content -> (Collection)EpiSerialisation$.MODULE$.collectionFormat().read(JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(content)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LuceneActor$.$anonfun$recalculateHash$3(conf, holder, x0$1);
            return BoxedUnit.UNIT;
        }));
        this.commitRequest(holder, ec);
    }

    public static final /* synthetic */ void $anonfun$commit$1(IndexHolder holder$10, boolean closeDirectory$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String key = (String)tuple2._1();
            TweetIndex i = (TweetIndex)holder$10.indexes().apply((Object)key);
            if (i.writeEnabled() && ((IndexWriter)i.writer().get()).isOpen()) {
                ((IndexWriter)i.writer().get()).commit();
                if (closeDirectory$1) {
                    ((IndexWriter)i.writer().get()).close();
                }
            }
            if (closeDirectory$1) {
                i.reader().close();
                i.index().close();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getReadKeys$3(Settings conf$1, String collection$2, String key) {
        return Paths.get(conf$1.epiHome(), "fs", collection$2, key).toFile().exists();
    }

    public static final /* synthetic */ boolean $anonfun$getReadKeys$4(String x$6, String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).$greater((Object)x$7);
    }

    public static final /* synthetic */ boolean $anonfun$getReadKeys$6(Option from$3, String collection$2, Option to$3, String p) {
        return !(!from$3.isEmpty() && !new StringOps(Predef$.MODULE$.augmentString(p)).$greater$eq((Object)MODULE$.getIndexKey(collection$2, (Instant)from$3.get())) || !to$3.isEmpty() && !new StringOps(Predef$.MODULE$.augmentString(p)).$less$eq((Object)MODULE$.getIndexKey(collection$2, (Instant)to$3.get())));
    }

    public static final /* synthetic */ boolean $anonfun$getReadKeys$7(String x$8, String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).$greater((Object)x$9);
    }

    public static final /* synthetic */ void $anonfun$add2Geolocate$2(IndexHolder holder$12, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            log$.MODULE$.msg(new StringBuilder(56).append("Error during geolocalisation: Retrying on next request ").append(t.getMessage()).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace())).mkString("\n")).toString());
            holder$12.geolocating_$eq(false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$add2Aggregate$1(FSNode toAggr$1, BooleanRef firstLine$1, String line) {
        toAggr$1.setContent(new StringBuilder(0).append((Object)(!firstLine$1.elem ? "\n" : "")).append(line).toString(), (WriteMode)WriteMode$append$.MODULE$);
        firstLine$1.elem = false;
    }

    public static final /* synthetic */ void $anonfun$add2Aggregate$4(SparkSession spark$1, Settings conf$5, Collection x0$1) {
        Collection collection = x0$1;
        MODULE$.aggregateTweets(collection, spark$1, conf$5);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$add2Aggregate$5(IndexHolder holder$13, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            HashMap<String, Dataset<Row>> hashMap = holder$13.toAggregate();
            synchronized (hashMap) {
                log$.MODULE$.msg(new StringBuilder(53).append("Error during aggregating: Retrying on next request ").append(t.getMessage()).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace())).mkString("\n")).append(" ").toString());
                holder$13.aggregating_$eq(false);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$geolocateTweets$5(int par$1, int i$1, TweetV1 t) {
        return t.tweet_id() % (long)par$1 == (long)i$1;
    }

    public static final /* synthetic */ Iterator $anonfun$geolocateTweets$2(Settings conf$6, int par$1, int i) {
        Product st = conf$6.getSparkStorage();
        FSNode geoNode = ((Storage)st).getNode(conf$6.geolocatingPath(), ((Storage)st).getNode$default$2());
        Iterator tweets = geoNode.exists() ? geoNode.getContentAsLines().map((Function1 & Serializable & scala.Serializable)json -> (TopicTweetsV1)EpiSerialisation$.MODULE$.topicTweetsFormat().read(JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(json)))) : scala.package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        Iterator r = tweets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TopicTweetsV1 topicTweetsV1 = x0$1;
            if (topicTweetsV1 == null) {
                throw new MatchError((Object)topicTweetsV1);
            }
            String topic = topicTweetsV1.topic();
            TweetsV1 ts = topicTweetsV1.tweets();
            Seq seq = (Seq)((TraversableLike)ts.items().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$geolocateTweets$5(par$1, i, t)))).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)topic, t), Seq$.MODULE$.canBuildFrom());
            return seq;
        });
        return r;
    }

    public static final /* synthetic */ int $anonfun$geolocateTweets$13(HashMap indexes$4, Settings conf$6, Tuple2 x0$2) {
        String iKey;
        GeolocatedTweet geo;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object object;
            geo = (GeolocatedTweet)tuple2._1();
            Instant createdAt = (Instant)tuple2._2();
            iKey = MODULE$.getIndexKey("tweets", createdAt);
            IndexHolder holder = MODULE$.holder();
            if (!indexes$4.contains((Object)iKey)) {
                indexes$4.update((Object)iKey, (Object)MODULE$.getIndex("tweets", iKey, conf$6, holder));
                object = ((TweetIndex)indexes$4.apply((Object)iKey)).refreshReader();
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        ((TweetIndex)indexes$4.apply((Object)iKey)).indexGeolocated(geo);
        int n = 1;
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$aggregateTweets$29(int par$2, int i$2, TweetV1 t) {
        return t.tweet_id() % (long)par$2 == (long)i$2;
    }

    public static final /* synthetic */ Iterator $anonfun$aggregateTweets$26(Settings conf$7, int par$2, Collection collection$4, int i) {
        Product st = conf$7.getSparkStorage();
        FSNode aggrNode = ((Storage)st).getNode(conf$7.aggregatingPath(), ((Storage)st).getNode$default$2());
        Iterator tweets = aggrNode.exists() ? aggrNode.getContentAsLines().map((Function1 & Serializable & scala.Serializable)json -> (TopicTweetsV1)EpiSerialisation$.MODULE$.topicTweetsFormat().read(JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(json)))) : scala.package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        return tweets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TopicTweetsV1 topicTweetsV1 = x0$1;
            if (topicTweetsV1 == null) {
                throw new MatchError((Object)topicTweetsV1);
            }
            String topic = topicTweetsV1.topic();
            TweetsV1 tts = topicTweetsV1.tweets();
            Seq seq = (Seq)((TraversableLike)tts.items().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)LuceneActor$.$anonfun$aggregateTweets$29(par$2, i, t)))).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)topic, t), Seq$.MODULE$.canBuildFrom());
            return seq;
        }).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            TweetV1 t = (TweetV1)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)topic, (Object)BoxesRunTime.boxToLong((long)t.tweet_id()), (Object)MODULE$.getIndexKey(collection$4.name(), t.created_at()));
            return tuple3;
        });
    }

    public static final /* synthetic */ boolean $anonfun$aggregateTweets$34(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        boolean bl = tuple3 != null;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$aggregateTweets$54(String dateCol$1, ObjectRef lastKey$2, ObjectRef index$4, String collName$1, Settings conf$8, IndexHolder holder$14, Seq pks$1, Collection collection$4, Row row) {
        Instant key = Instant.parse(new StringBuilder(14).append(row.getAs(dateCol$1)).append("T00:00:00.000Z").toString());
        String string = (String)lastKey$2.elem;
        Instant instant = key;
        if (string == null ? instant != null : !string.equals(instant)) {
            index$4.elem = MODULE$.getIndex(collName$1, key, conf$8, holder$14);
        }
        TweetIndex qual$2 = (TweetIndex)index$4.elem;
        Row x$3 = row;
        Seq x$4 = pks$1;
        Map<String, String> x$5 = collection$4.aggr();
        Set<String> x$6 = qual$2.indexSparkRow$default$3();
        qual$2.indexSparkRow(x$3, (Seq<String>)x$4, x$6, x$5);
        return 1;
    }

    public static final /* synthetic */ void $anonfun$recalculateHash$5(TweetIndex i$3, String pkName$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Document doc = (Document)tuple2._1();
        i$3.updateHash(doc, pkName$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$recalculateHash$4(String pkName$1, TweetIndex i) {
        i.searchTweets((Query)new MatchAllDocsQuery(), (Option<Object>)None$.MODULE$, false, QuerySort$.MODULE$.index(), i.searchTweets$default$5()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            LuceneActor$.$anonfun$recalculateHash$5(i, pkName$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$recalculateHash$3(Settings conf$9, IndexHolder holder$15, Collection x0$1) {
        Collection collection = x0$1;
        String arg$macro$1 = collection.name();
        log$.MODULE$.msg(new StringOps("Recalculating hashes for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        String pkName = collection.pks().mkString("_");
        Seq<TweetIndex> ind = MODULE$.getReadIndexes(collection.name(), (Option<Instant>)None$.MODULE$, (Option<Instant>)None$.MODULE$, conf$9, holder$15);
        ind.foreach((Function1 & Serializable & scala.Serializable)i -> {
            LuceneActor$.$anonfun$recalculateHash$4(pkName, i);
            return BoxedUnit.UNIT;
        });
        String arg$macro$2 = collection.name();
        log$.MODULE$.msg(new StringOps("Recalculating hashes for %s done!!").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private LuceneActor$() {
        MODULE$ = this;
        this.defaultTextLangCols = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"text"), (Object)new Some((Object)"lang")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"linked_text"), (Object)new Some((Object)"linked_lang")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user_description"), (Object)new Some((Object)"lang")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user_location"), (Object)new Some((Object)"lang")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"place_full_name"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"linked_place_full_name"), (Object)None$.MODULE$)}));
    }
}

