### Sub-options 3 or 4 (genotypic differentiation)
\index{Differentiation!genotypic}
are concerned with the distribution of diploid genotypes in the various populations. The null hypothesis tested is “genotypes are drawn from the same distribution in all populations”. For each locus, the test is performed on a contingency table like this one:

                      Genotypes:
                      -------------------------
                      1    1   2   1   2   3
             Pop:     1    2   2   3   3   3   All
             ----
             Pop1     142  27  0   13  1   0   183
             Pop2     149  20  0   11  0   4   184
             Pop3     131  12  0   9   0   1   153
             Pop4     119  22  1   10  0   0   152
             Pop5     120  17  1   10  1   0   149
             Pop6     134  18  2   15  0   0   169
             Pop7     116  15  1   10  1   1   144
             Pop8     214  41  3   14  2   1   275
             Pop9     84   17  0   7   2   0   110
             Pop10    107  18  0   15  3   0   143
             Pop11    134  32  1   21  4   0   192
             Pop12    105  26  1   11  1   4   148
             Pop13    97   19  2   23  4   0   145
             Pop14    95   28  3   19  3   1   149

             All:     1747 312 15  188 22  12  2296

An unbiased estimate of the P-value of a log-likelihood ratio ($G$) based exact test is performed. For this test, the statistics defining the rejection zone is the $G$ value computed on the genic table derived from the genotypic one [see @GoudetRMR96 for the choice of this statistic],\index{Differentiation!genic-genotypic test} so that the rejection zone is defined as the sum of the probabilities of all tables (with the same marginal genotypic values as the observed one) having a $G$ value computed on the derived genic table higher than or equal to the observed $G$ value.

For sub-option 4, the test is the same but is performed for all pairs of samples for all loci.

### Output
For the four sub-options, results are stored in a file named as follows:[^17]

| sub-option  | test              |output file name | 
|------------ |------------------ |-----------------|
|1            |Probability test   |*yourdata*`.PR`  |
|1            |$G$                |*yourdata*`.GE`  |
|2            |Probability test   |*yourdata*`.PR2` |
|2            |$G$                |*yourdata*`.GE2` |
|3            |$G$                |*yourdata*`.G`   |
|4            |$G$                |*yourdata*`.2G2` |


All contingency tables are saved in the output file. Two intractable situations are indicated: empty tables or tables with one row or one column only (“No table”), and tables for which all rows or all columns marginal sums are 1 (“No information”). Estimates of P-values are given, as well as (for sub-options 1 and 3) a combination of all test results (Fisher’s method), which assumes a statistical independence across loci. For sub-options 2 and 4, this combination of all tests across loci (Fisher’s method) is performed for each sample pair. The result `Highly sign.`[ificant] is reported when at least one of the individual tests being combined yielded a zero $P$-value estimate.
