/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;

public class Graph {
    private Map<Edge, Link> links = new LinkedHashMap<Edge, Link>();
    private Map<Node, Map<Node, LinksList>> connected;
    private Map<Node, LinksList> adj = new LinkedHashMap<Node, LinksList>();
    private Map<Node, Integer> degree;

    public Graph() {
        this.connected = new HashMap<Node, Map<Node, LinksList>>();
        this.degree = new HashMap<Node, Integer>();
    }

    public void addVertex(Node v) {
        if (this.adj.containsKey(v)) {
            throw new IllegalArgumentException();
        }
        this.adj.put(v, new LinksList());
        this.connected.put(v, new LinkedHashMap());
        this.degree.put(v, 0);
    }

    public void addEdge(Node v, Node u, Edge e) {
        if (this.links.containsKey(e)) {
            throw new IllegalArgumentException();
        }
        Link link = new Link(v, u, e);
        this.links.put(e, link);
        this.adj.get(v).add(link);
        this.adj.get(u).add(link);
        this.addToConnected(v, u, link);
        this.addToConnected(u, v, link);
        this.degree.put(v, this.degree.get(v) + 1);
        this.degree.put(u, this.degree.get(u) + 1);
    }

    public Set<Edge> edgesOf(Node v) {
        LinkedHashSet<Edge> res = new LinkedHashSet<Edge>();
        for (Link l : this.adj.get(v)) {
            res.add(l.e);
        }
        return res;
    }

    private void addToConnected(Node v, Node u, Link l) {
        Map<Node, LinksList> m = this.connected.get(v);
        if (!m.containsKey(u)) {
            m.put(u, new LinksList());
        }
        m.get(u).add(l);
    }

    public Node opposite(Node v, Edge e) {
        return this.getOppositeVertex(v, this.links.get(e));
    }

    public boolean containsEdge(Edge e) {
        return this.links.containsKey(e);
    }

    private Node getOppositeVertex(Node v, Link l) {
        if (l.v.equals(v)) {
            return l.u;
        }
        if (l.u.equals(v)) {
            return l.v;
        }
        throw new IllegalArgumentException();
    }

    public void removeVertex(Node v) {
        List<Node> neighbors = this.neighborListOf(v);
        for (Edge e : this.edgesOf(v)) {
            this.removeEdge(e);
        }
        for (Node u : neighbors) {
            this.connected.get(u).remove(v);
        }
        this.adj.remove(v);
        this.connected.remove(v);
    }

    public List<Edge> getAllEdges(Node v, Node u) {
        ArrayList<Edge> res = new ArrayList<Edge>();
        for (Link l : this.connected.get(v).get(u)) {
            res.add(l.e);
        }
        return res;
    }

    public Edge getEdge(Node v, Node u) {
        Map<Node, LinksList> vadj = this.connected.get(v);
        if (vadj == null) {
            throw new IllegalArgumentException();
        }
        LinksList edges = this.connected.get(v).get(u);
        if (edges == null) {
            return null;
        }
        Iterator<Link> it = edges.iterator();
        return it.hasNext() ? it.next().e : null;
    }

    public List<Node> neighborListOf(Node v) {
        LinkedHashSet<Node> res = new LinkedHashSet<Node>();
        for (Link l : this.adj.get(v)) {
            res.add(this.getOppositeVertex(v, l));
        }
        return new ArrayList<Node>(res);
    }

    public void removeEdge(Edge e) {
        Link l = this.links.get(e);
        this.links.remove(e);
        l.removed = true;
        this.degree.put(l.v, this.degree.get(l.v) - 1);
        this.degree.put(l.u, this.degree.get(l.u) - 1);
    }

    public Set<Node> vertexSet() {
        return Collections.unmodifiableSet(this.adj.keySet());
    }

    public Set<Elem> elemSet() {
        HashSet<Elem> res = new HashSet<Elem>();
        res.addAll(this.vertexSet());
        res.addAll(this.edgeSet());
        return res;
    }

    public Set<Edge> edgeSet() {
        return Collections.unmodifiableSet(this.links.keySet());
    }

    public Node getEdgeSource(Edge e) {
        Link l = this.links.get(e);
        return l.v;
    }

    public Node getEdgeTarget(Edge e) {
        Link l = this.links.get(e);
        return l.u;
    }

    public Graph subgraph(Set<Node> nodes) {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node v : nodes) {
            for (Node u : this.neighborListOf(v)) {
                if (!nodes.contains(u)) continue;
                edges.addAll(this.getAllEdges(v, u));
            }
        }
        return this.subgraph(nodes, edges);
    }

    public Graph subgraph(Set<Node> nodes, Set<Edge> edges) {
        Graph res = new Graph();
        nodes.stream().forEach(res::addVertex);
        for (Edge e : edges) {
            if (!this.containsEdge(e)) continue;
            res.addEdge(this.getEdgeSource(e), this.getEdgeTarget(e), e);
        }
        return res;
    }

    public List<Set<Node>> connectedSets() {
        ArrayList<Set<Node>> res = new ArrayList<Set<Node>>();
        HashSet vis = new HashSet();
        this.vertexSet().stream().filter(v -> !vis.contains(v)).forEach(v -> {
            LinkedHashSet<Node> curr = new LinkedHashSet<Node>();
            this.dfs((Node)v, (Set<Node>)curr);
            res.add(curr);
            vis.addAll(curr);
        });
        return res;
    }

    private void dfs(Node v, Set<Node> vis) {
        vis.add(v);
        for (Link l : this.adj.get(v)) {
            Node u = this.getOppositeVertex(v, l);
            if (vis.contains(u)) continue;
            this.dfs(u, vis);
        }
    }

    public int degreeOf(Node v) {
        return this.degree.get(v);
    }

    public boolean containsVertex(Node v) {
        return this.adj.containsKey(v);
    }

    public void addGraph(Graph graph) {
        for (Node v : graph.vertexSet()) {
            this.addVertex(v);
        }
        for (Edge e : graph.edgeSet()) {
            Node v = graph.getEdgeSource(e);
            Node u = graph.getEdgeTarget(e);
            this.addEdge(v, u, e);
        }
    }

    private static class LinksList
    implements Iterable<Link> {
        private List<Link> l = new LinkedList<Link>();

        public void add(Link link) {
            this.l.add(link);
        }

        @Override
        public Iterator<Link> iterator() {
            return new RemovingIterator(this.l.iterator());
        }
    }

    private static class Link {
        public Edge e;
        public Node v;
        public Node u;
        public boolean removed;

        public Link(Node v, Node u, Edge e) {
            this.v = v;
            this.u = u;
            this.e = e;
        }
    }

    private static class RemovingIterator
    implements Iterator<Link> {
        private Iterator<Link> it;
        private Link next;

        public RemovingIterator(Iterator<Link> it) {
            this.it = it;
            this.step();
        }

        private void step() {
            this.next = null;
            while (this.it.hasNext()) {
                Link l = this.it.next();
                if (l.removed) {
                    this.it.remove();
                    continue;
                }
                this.next = l;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Link next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Link res = this.next;
            this.step();
            return res;
        }
    }
}

