## ---- echo = FALSE, message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieving the taxonomic hierarchy of "Arabidopsis thaliana"
#  # from NCBI Taxonomy
#  myTAI::taxonomy( organism = "Arabidopsis thaliana",
#            db       = "ncbi",
#            output   = "classification" )

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieving the taxonomic hierarchy of "Arabidopsis thaliana"
#  # from the Integrated Taxonomic Information System
#  myTAI::taxonomy( organism = "Arabidopsis thaliana",
#            db       = "itis",
#            output   = "classification" )

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieving the taxonomy id of the query organism from NCBI Taxonomy
#  myTAI::taxonomy( organism = "Arabidopsis thaliana",
#            db       = "ncbi",
#            output   = "taxid" )

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieving the taxonomy id of the query organism from Integrated Taxonomic Information Service
#  myTAI::taxonomy( organism = "Arabidopsis",
#            db       = "itis",
#            output   = "taxid" )

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieve children taxa of the query organism stored in the correspondning database
#  myTAI::taxonomy( organism = "Arabidopsis",
#            db       = "ncbi",
#            output   = "children" )

## ---- eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # retrieve children taxa of the query organism stored in the correspondning database
#  myTAI::taxonomy( organism = "Arabidopsis",
#            db       = "itis",
#            output   = "children" )

