/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.help;

import com.qarks.util.ui.help.HelpNode;
import com.qarks.util.ui.help.HelpParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JavaHelpPanel
extends JPanel {
    private JTree navigationTree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode rootNode;
    private JEditorPane editor = new JEditorPane();

    public JavaHelpPanel() {
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(new Hyperactive());
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        this.rootNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.navigationTree = new JTree(this.treeModel);
        this.navigationTree.setRootVisible(false);
        this.navigationTree.setShowsRootHandles(true);
        this.navigationTree.setCellRenderer(new HelpTreeCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane(this.navigationTree);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, jScrollPane);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jSplitPane, "Center");
        jSplitPane.setDividerLocation(200);
        this.navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JavaHelpPanel.this.updateSelectedHelp(treeSelectionEvent.getPath());
            }
        });
    }

    private void updateSelectedHelp(TreePath treePath) {
        if (treePath != null) {
            HelpTreeNode helpTreeNode = (HelpTreeNode)treePath.getLastPathComponent();
            String string = helpTreeNode.getPageUrl().toString().toLowerCase();
            if (!helpTreeNode.isDirectory() || string.endsWith("index.htm") || string.endsWith("index.html")) {
                try {
                    URL uRL = helpTreeNode.getPageUrl();
                    this.editor.setPage(uRL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private HelpTreeNode getNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        HelpTreeNode helpTreeNode = null;
        for (int i = 0; helpTreeNode == null && i < defaultMutableTreeNode.getChildCount(); ++i) {
            HelpTreeNode helpTreeNode2 = (HelpTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!helpTreeNode2.getName().equals(string)) continue;
            helpTreeNode = helpTreeNode2;
        }
        return helpTreeNode;
    }

    public void showPage(String string) {
        try {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            arrayList.add(this.rootNode);
            DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
            HelpTreeNode helpTreeNode = null;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                helpTreeNode = this.getNode(defaultMutableTreeNode, (String)object);
                arrayList.add(helpTreeNode);
                defaultMutableTreeNode = helpTreeNode;
            }
            object = new TreePath(arrayList.toArray());
            arrayList.remove(arrayList.size() - 1);
            TreePath treePath = new TreePath(arrayList.toArray());
            this.navigationTree.expandPath(treePath);
            this.navigationTree.setSelectionPath((TreePath)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadHelp(HelpParser helpParser) {
        this.loadHelp(helpParser, this.rootNode);
        this.navigationTree.expandPath(new TreePath(this.rootNode));
    }

    private void loadHelp(HelpParser helpParser, DefaultMutableTreeNode defaultMutableTreeNode) {
        HelpNode[] helpNodeArray;
        HelpNode helpNode = null;
        if (defaultMutableTreeNode.getUserObject() instanceof HelpNode) {
            helpNode = (HelpNode)defaultMutableTreeNode.getUserObject();
        }
        for (HelpNode helpNode2 : helpNodeArray = helpParser.getChildren(helpNode)) {
            HelpTreeNode helpTreeNode;
            String string = helpNode2.getPageUrl().toString().toLowerCase();
            if (!helpNode2.isFolder() && (string.endsWith("index.htm") || string.endsWith("index.html"))) {
                helpTreeNode = (HelpTreeNode)defaultMutableTreeNode;
                helpNode = (HelpNode)helpTreeNode.getUserObject();
                helpNode.setPageUrl(helpNode2.getPageUrl());
                continue;
            }
            helpTreeNode = new HelpTreeNode(helpNode2);
            defaultMutableTreeNode.add(helpTreeNode);
            this.treeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getChildCount() - 1});
            if (!helpNode2.isFolder()) continue;
            this.loadHelp(helpParser, helpTreeNode);
        }
    }

    private class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }

    private class HelpTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private HelpTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof HelpTreeNode) {
                HelpTreeNode helpTreeNode = (HelpTreeNode)object;
                this.setText(helpTreeNode.getName());
            }
            return component;
        }
    }

    private class HelpTreeNode
    extends DefaultMutableTreeNode {
        public HelpTreeNode(HelpNode helpNode) {
            super(helpNode);
        }

        public URL getPageUrl() {
            HelpNode helpNode = (HelpNode)this.getUserObject();
            return helpNode.getPageUrl();
        }

        public String getName() {
            HelpNode helpNode = (HelpNode)this.getUserObject();
            return helpNode.getName();
        }

        public boolean isDirectory() {
            HelpNode helpNode = (HelpNode)this.getUserObject();
            return helpNode.isFolder();
        }
    }
}

