/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.NativeLibraryLoader;
import net.sf.jniinchi.INCHI_KEY_STATUS;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_STATUS;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputData;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiOutputKey;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.LoadNativeLibraryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JniInchiWrapper {
    private static final String ID = "jniinchi";
    private static final String VERSION = "1.03_1";
    private static final int MAX_LOCK_TIMEOUT = 15;
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase().startsWith("windows");
    static final String flagChar = IS_WINDOWS ? "/" : "-";
    private static boolean libraryLoaded = false;
    private static JniInchiWrapper inchiWrapper;
    private static final Lock lock;

    public static synchronized void loadLibrary() throws LoadNativeLibraryException {
        if (!libraryLoaded) {
            try {
                NativeLibraryLoader.loadLibrary(ID, VERSION);
                JniInchiWrapper.checkNativeCodeVersion();
                libraryLoaded = true;
            }
            catch (NativeCodeException ex) {
                System.err.println();
                System.err.println("Error loading JNI InChI native code.");
                System.err.println("You may need to compile the native code for your platform.");
                System.err.println("See http://jni-inchi.sourceforge.net for instructions.");
                System.err.println();
                throw new LoadNativeLibraryException(ex);
            }
        }
    }

    private static void checkNativeCodeVersion() throws NativeCodeException {
        String nativeVersion;
        try {
            nativeVersion = JniInchiWrapper.LibInchiGetVersion();
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeCodeException("Unable get native code version", e);
        }
        if (!VERSION.equals(nativeVersion)) {
            throw new NativeCodeException("JNI InChI native code version mismatch: expected 1.03_1, found " + nativeVersion);
        }
    }

    private static synchronized JniInchiWrapper getWrapper() throws LoadNativeLibraryException {
        if (inchiWrapper == null) {
            JniInchiWrapper.loadLibrary();
            JniInchiWrapper.init();
            inchiWrapper = new JniInchiWrapper();
        }
        return inchiWrapper;
    }

    private JniInchiWrapper() throws LoadNativeLibraryException {
    }

    protected static String checkOptions(List<INCHI_OPTION> ops) throws JniInchiException {
        if (ops == null) {
            throw new IllegalArgumentException("Null options");
        }
        StringBuffer sbOptions = new StringBuffer();
        for (int i = 0; i < ops.size(); ++i) {
            INCHI_OPTION op = ops.get(i);
            if (!(op instanceof INCHI_OPTION)) {
                throw new JniInchiException("Unrecognised InChI option");
            }
            sbOptions.append(flagChar + op.name() + " ");
        }
        return sbOptions.toString();
    }

    protected static String checkOptions(String ops) throws JniInchiException {
        if (ops == null) {
            throw new IllegalArgumentException("Null options");
        }
        StringBuilder sbOptions = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(ops);
        while (tok.hasMoreTokens()) {
            INCHI_OPTION option;
            String op = tok.nextToken();
            if (op.startsWith("-") || op.startsWith("/")) {
                op = op.substring(1);
            }
            if ((option = INCHI_OPTION.valueOfIgnoreCase(op)) != null) {
                sbOptions.append(flagChar + option.name());
                if (!tok.hasMoreTokens()) continue;
                sbOptions.append(" ");
                continue;
            }
            throw new JniInchiException("Unrecognised InChI option");
        }
        return sbOptions.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutput getInchi(JniInchiInput input) throws JniInchiException {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            JniInchiOutput jniInchiOutput = wrapper.GetINCHI(input);
            return jniInchiOutput;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutput getStdInchi(JniInchiInput input) throws JniInchiException {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            JniInchiOutput jniInchiOutput = wrapper.GetStdINCHI(input);
            return jniInchiOutput;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutput getInchiFromInchi(JniInchiInputInchi input) throws JniInchiException {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            JniInchiOutput jniInchiOutput = wrapper.GetINCHIfromINCHI(input.getInchi(), input.getOptions());
            return jniInchiOutput;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutputStructure getStructureFromInchi(JniInchiInputInchi input) throws JniInchiException {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            JniInchiOutputStructure jniInchiOutputStructure = wrapper.GetStructFromINCHI(input.getInchi(), input.getOptions());
            return jniInchiOutputStructure;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiOutputKey getInchiKey(String inchi) throws JniInchiException {
        if (inchi == null) {
            throw new IllegalArgumentException("Null InChI");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            JniInchiOutputKey jniInchiOutputKey = wrapper.GetINCHIKeyFromINCHI(inchi);
            return jniInchiOutputKey;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INCHI_KEY_STATUS checkInchiKey(String key) throws JniInchiException {
        if (key == null) {
            throw new IllegalArgumentException("Null InChI key");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            int ret = wrapper.CheckINCHIKey(key);
            INCHI_KEY_STATUS retStatus = INCHI_KEY_STATUS.getValue(ret);
            if (retStatus == null) {
                throw new JniInchiException("Unknown return status: " + ret);
            }
            INCHI_KEY_STATUS iNCHI_KEY_STATUS = retStatus;
            return iNCHI_KEY_STATUS;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INCHI_STATUS checkInchi(String inchi, boolean strict) throws JniInchiException {
        if (inchi == null) {
            throw new IllegalArgumentException("Null InChI");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            int ret = wrapper.CheckINCHI(inchi, strict);
            INCHI_STATUS retStatus = INCHI_STATUS.getValue(ret);
            if (retStatus == null) {
                throw new JniInchiException("Unknown return status: " + ret);
            }
            INCHI_STATUS iNCHI_STATUS = retStatus;
            return iNCHI_STATUS;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniInchiInputData getInputFromAuxInfo(String auxInfo) throws JniInchiException {
        if (auxInfo == null) {
            throw new IllegalArgumentException("Null AuxInfo");
        }
        JniInchiWrapper wrapper = JniInchiWrapper.getWrapper();
        wrapper.getLock();
        try {
            JniInchiInputData jniInchiInputData = wrapper.GetINCHIInputFromAuxInfo(auxInfo, false, false);
            return jniInchiInputData;
        }
        finally {
            lock.unlock();
        }
    }

    private static synchronized void getLock() throws JniInchiException {
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) {
                throw new TimeoutException("Unable to get lock");
            }
        }
        catch (TimeoutException ex) {
            throw new JniInchiException(ex);
        }
        catch (InterruptedException ex) {
            throw new JniInchiException(ex);
        }
    }

    protected static native String LibInchiGetVersion();

    private static native void init();

    private native JniInchiOutput GetINCHI(JniInchiInput var1);

    private native JniInchiOutput GetStdINCHI(JniInchiInput var1);

    private native JniInchiOutput GetINCHIfromINCHI(String var1, String var2);

    private native JniInchiOutputStructure GetStructFromINCHI(String var1, String var2);

    private native JniInchiOutputKey GetINCHIKeyFromINCHI(String var1);

    private native JniInchiOutputKey GetStdINCHIKeyFromStdINCHI(String var1);

    private native int CheckINCHIKey(String var1);

    private native int CheckINCHI(String var1, boolean var2);

    private native JniInchiInputData GetINCHIInputFromAuxInfo(String var1, boolean var2, boolean var3);

    static {
        lock = new ReentrantLock(true);
    }
}

