/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.openscience.cdk.formula.IFormulaGenerator;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

class FullEnumerationFormulaGenerator
implements IFormulaGenerator {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(FullEnumerationFormulaGenerator.class);
    private final IChemObjectBuilder builder;
    private final double minMass;
    private final double maxMass;
    private final IIsotope[] isotopes;
    private final int[] minCounts;
    private final int[] maxCounts;
    private final int[] currentCounts;
    private int lastIncreasedPosition = 0;
    private volatile boolean searchRunning = true;

    public FullEnumerationFormulaGenerator(IChemObjectBuilder builder, double minMass, double maxMass, MolecularFormulaRange mfRange) {
        logger.info("Initiate MolecularFormulaGenerator, mass range ", minMass, "-", maxMass);
        if (minMass < 0.0 || maxMass < 0.0) {
            throw new IllegalArgumentException("The minimum and maximum mass values must be >=0");
        }
        if (minMass > maxMass) {
            throw new IllegalArgumentException("Minimum mass must be <= maximum mass");
        }
        if (mfRange == null || mfRange.getIsotopeCount() == 0) {
            throw new IllegalArgumentException("The MolecularFormulaRange parameter must be non-null and must contain at least one isotope");
        }
        this.builder = builder;
        this.minMass = minMass;
        this.maxMass = maxMass;
        TreeSet<IIsotope> isotopesSet = new TreeSet<IIsotope>(new IIsotopeSorterByMass());
        for (IIsotope isotope : mfRange.isotopes()) {
            if (isotope.getExactMass() == null) {
                throw new IllegalArgumentException("The exact mass value of isotope " + isotope + " is not set");
            }
            isotopesSet.add(isotope);
        }
        this.isotopes = isotopesSet.toArray(new IIsotope[isotopesSet.size()]);
        this.minCounts = new int[this.isotopes.length];
        this.maxCounts = new int[this.isotopes.length];
        for (int i = 0; i < this.isotopes.length; ++i) {
            this.minCounts[i] = mfRange.getIsotopeCountMin(this.isotopes[i]);
            this.maxCounts[i] = mfRange.getIsotopeCountMax(this.isotopes[i]);
            int maxCountAccordingToMass = (int)Math.floor(maxMass / this.isotopes[i].getExactMass());
            if (this.maxCounts[i] <= maxCountAccordingToMass) continue;
            this.maxCounts[i] = maxCountAccordingToMass;
        }
        this.currentCounts = Arrays.copyOf(this.minCounts, this.minCounts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized IMolecularFormula getNextFormula() {
        while (this.searchRunning) {
            double currentMass = this.calculateCurrentMass();
            if (currentMass > this.maxMass) {
                int[] nArray = this.currentCounts;
                // MONITORENTER : this.currentCounts
                this.currentCounts[this.lastIncreasedPosition] = this.maxCounts[this.lastIncreasedPosition];
                this.increaseCounter(this.lastIncreasedPosition);
                // MONITOREXIT : nArray
                continue;
            }
            if (currentMass >= this.minMass && currentMass <= this.maxMass) {
                IMolecularFormula cdkFormula = this.generateFormulaObject();
                this.increaseCounter(0);
                return cdkFormula;
            }
            this.increaseCounter(0);
        }
        return null;
    }

    @Override
    public synchronized IMolecularFormulaSet getAllFormulas() {
        IMolecularFormula nextFormula;
        IMolecularFormulaSet result = this.builder.newInstance(IMolecularFormulaSet.class, new Object[0]);
        while ((nextFormula = this.getNextFormula()) != null) {
            result.addMolecularFormula(nextFormula);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCounter(int position) {
        if (position >= this.currentCounts.length) {
            throw new IllegalArgumentException("Cannot increase the currentCounts counter at position " + position);
        }
        this.lastIncreasedPosition = position;
        int[] nArray = this.currentCounts;
        synchronized (this.currentCounts) {
            if (this.currentCounts[position] < this.maxCounts[position]) {
                int n = position;
                this.currentCounts[n] = this.currentCounts[n] + 1;
            } else if (position < this.isotopes.length - 1) {
                this.currentCounts[position] = this.minCounts[position];
                this.increaseCounter(position + 1);
            } else {
                this.searchRunning = false;
                System.arraycopy(this.maxCounts, 0, this.currentCounts, 0, this.maxCounts.length);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private double calculateCurrentMass() {
        double mass = 0.0;
        for (int i = 0; i < this.isotopes.length; ++i) {
            mass += (double)this.currentCounts[i] * this.isotopes[i].getExactMass();
        }
        return mass;
    }

    private IMolecularFormula generateFormulaObject() {
        IMolecularFormula formulaObject = this.builder.newInstance(IMolecularFormula.class, new Object[0]);
        for (int i = 0; i < this.isotopes.length; ++i) {
            if (this.currentCounts[i] == 0) continue;
            formulaObject.addIsotope(this.isotopes[i], this.currentCounts[i]);
        }
        return formulaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getFinishedPercentage() {
        double result = 0.0;
        double remainingPerc = 1.0;
        int[] nArray = this.currentCounts;
        synchronized (this.currentCounts) {
            for (int i = this.currentCounts.length - 1; i >= 0; --i) {
                double max = this.maxCounts[i];
                if (i > 0) {
                    max += 1.0;
                }
                result += remainingPerc * ((double)this.currentCounts[i] / max);
                remainingPerc /= max;
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return result;
        }
    }

    @Override
    public void cancel() {
        logger.info("Canceling MolecularFormulaGenerator");
        this.searchRunning = false;
    }

    private class IIsotopeSorterByMass
    implements Comparator<IIsotope> {
        private IIsotopeSorterByMass() {
        }

        @Override
        public int compare(IIsotope i1, IIsotope i2) {
            return Double.compare(i1.getExactMass(), i2.getExactMass());
        }
    }
}

