/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip.rules;

import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.rules.ISequenceSubRule;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

class AtomicNumberRule
implements ISequenceSubRule<ILigand> {
    AtomicNumberRule() {
    }

    @Override
    public int compare(ILigand ligand1, ILigand ligand2) {
        return this.getAtomicNumber(ligand1).compareTo(this.getAtomicNumber(ligand2));
    }

    private Integer getAtomicNumber(ILigand ligand) {
        Integer atomNumber = ligand.getLigandAtom().getAtomicNumber();
        if (atomNumber != null) {
            return atomNumber;
        }
        return PeriodicTable.getAtomicNumber(ligand.getLigandAtom().getSymbol());
    }
}

