/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

public class RDFStatement<V, U> {
    V subject;
    String predicate;
    U object;
    String source;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public RDFStatement(V subject, String predicate, U object) {
        this(subject, predicate, object, null);
    }

    public RDFStatement(V subject, String predicate, U object, String source) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.source = source;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFStatement other = (RDFStatement)obj;
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        if (this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    public U getObject() {
        return this.object;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public V getSubject() {
        return this.subject;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public void setObject(U object) {
        this.object = object;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public void setSubject(V subject) {
        this.subject = subject;
    }

    public String toString() {
        return "RDFStatement [subject=" + this.subject + ", predicate=" + this.predicate + ", object=" + this.object + "]";
    }

    public boolean hasSource() {
        return this.source != null;
    }
}

