ui = navbarPage(title = 'Bayesian Basic',
                collapsible = T, 
                position = 'fixed-top',
                theme  = add_theme(getShinyOption('theme')),
                header = add_css(),
                footer = add_logo(),
                
                
tabPanel('Overview',
         sidebarLayout(
           sidebarPanel(
            sliderInput('expmle',
                        'Exponential MLE',
                        min = 60,
                        max = 90,
                        value = 80,
                        step = 5),
            sliderInput('gamshape',
                        'Prior Shape',
                        min = 30,
                        max = 50,
                        value = 45,
                        step = 1),
            sliderInput('gamscale',
                        'Prior SCale',
                        min = 1.0,
                        max = 1.5,
                        value = 1.5,
                        step = 0.1),
            sliderInput('nsims',
                        'Simulation Size',
                        min = 10000,
                        max = 100000,
                        value = 50000,
                        step = 10000),
            sliderInput('datasize',
                        'Sample Size',
                        min = 10,
                        max = 150,
                        value = 100,
                        step = 10),
            sliderInput('tcensor',
                        'Censor Time',
                        min = 90,
                        max = 150,
                        value = 100,
                        step = 10)),
           mainPanel(plotOutput('bayesplot', height = '600px')))))

