/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;

class DelegateDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateDComplexMatrix2D(DComplexMatrix3D dComplexMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= dComplexMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(dComplexMatrix3D.rows(), dComplexMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= dComplexMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(dComplexMatrix3D.slices(), dComplexMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= dComplexMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(dComplexMatrix3D.slices(), dComplexMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = dComplexMatrix3D;
    }

    public synchronized double[] getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public DComplexMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, double[] dArray) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, dArray);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, dArray);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, dArray);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public synchronized void setQuick(int n, int n2, double d, double d2) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, d, d2);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, d, d2);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, d, d2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public DComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperDComplexMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DComplexMatrix1D like1D(int n) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseDComplexMatrix1D;
    }

    public DoubleMatrix2D getImaginaryPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getImaginaryPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getImaginaryPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getImaginaryPart();
            }
        }
        throw new IllegalArgumentException();
    }

    public DoubleMatrix2D getRealPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getRealPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getRealPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getRealPart();
            }
        }
        throw new IllegalArgumentException();
    }
}

