/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dmperm;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lu;
import edu.emory.mathcs.csparsej.tdouble.Dcs_sqr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_usolve;

public class SparseDoubleLUDecomposition {
    private Dcs_common.Dcss S;
    private Dcs_common.Dcsn N;
    private DoubleMatrix2D L;
    private DoubleMatrix2D U;
    private boolean rcMatrix = false;
    private boolean isNonSingular = true;
    private int n;

    public SparseDoubleLUDecomposition(DoubleMatrix2D doubleMatrix2D, int n, boolean bl) {
        Dcs_common.Dcsd dcsd;
        Dcs_common.Dcs dcs;
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCDoubleMatrix2D)doubleMatrix2D).getColumnCompressed().elements();
        } else {
            dcs = (Dcs_common.Dcs)doubleMatrix2D.elements();
        }
        this.n = doubleMatrix2D.rows();
        this.S = Dcs_sqr.cs_sqr((int)n, (Dcs_common.Dcs)dcs, (boolean)false);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Dcs_lu.cs_lu((Dcs_common.Dcs)dcs, (Dcs_common.Dcss)this.S, (double)1.0);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_lu()");
        }
        if (bl && (dcsd = Dcs_dmperm.cs_dmperm((Dcs_common.Dcs)dcs, (int)1)) != null && dcsd.rr[3] < this.n) {
            this.isNonSingular = false;
        }
    }

    public double det() {
        if (!this.isNonsingular()) {
            return 0.0;
        }
        int n = 1;
        for (int i = 0; i < this.n; ++i) {
            if (this.N.pinv[i] == i) continue;
            n = -n;
        }
        if (this.U == null) {
            this.U = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCDoubleMatrix2D)this.U).getRowCompressed();
            }
        }
        double d = n;
        for (int i = 0; i < this.n; ++i) {
            d *= this.U.getQuick(i, i);
        }
        return d;
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCDoubleMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDoubleMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public int[] getPivot() {
        if (this.N.pinv == null) {
            return null;
        }
        int[] nArray = new int[this.N.pinv.length];
        System.arraycopy(this.N.pinv, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public DoubleMatrix2D getU() {
        if (this.U == null) {
            this.U = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCDoubleMatrix2D)this.U).getRowCompressed();
            }
        }
        return this.U.copy();
    }

    public Dcs_common.Dcss getSymbolicAnalysis() {
        Dcs_common.Dcss dcss = new Dcs_common.Dcss();
        dcss.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        dcss.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        dcss.lnz = this.S.lnz;
        dcss.m2 = this.S.m2;
        dcss.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        dcss.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        dcss.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        dcss.unz = this.S.unz;
        return dcss;
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("A is singular");
        }
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        double[] dArray = new double[this.n];
        double[] dArray2 = doubleMatrix1D.isView() ? (double[])doubleMatrix1D.copy().elements() : (double[])doubleMatrix1D.elements();
        Dcs_ipvec.cs_ipvec((int[])this.N.pinv, (double[])dArray2, (double[])dArray, (int)this.n);
        Dcs_lsolve.cs_lsolve((Dcs_common.Dcs)this.N.L, (double[])dArray);
        Dcs_usolve.cs_usolve((Dcs_common.Dcs)this.N.U, (double[])dArray);
        Dcs_ipvec.cs_ipvec((int[])this.S.q, (double[])dArray, (double[])dArray2, (int)this.n);
        if (doubleMatrix1D.isView()) {
            doubleMatrix1D.assign(dArray2);
        }
    }
}

