/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleIR
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D z;
    private DoubleMatrix1D r;

    public DoubleIR(DoubleMatrix1D doubleMatrix1D) {
        this.z = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            this.M.apply(this.r, this.z);
            doubleMatrix1D2.assign(this.z, DoubleFunctions.plus);
            doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

