/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseRCObjectMatrix2D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;
import java.util.Arrays;

public class SparseCCObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected Object[] values;
    protected boolean rowIndexesSorted;

    public SparseCCObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray[0].length);
        this.assign(objectArray);
    }

    public SparseCCObjectMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCObjectMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new int[n3];
        this.values = new Object[n3];
        this.columnPointers = new int[n2 + 1];
    }

    public SparseCCObjectMatrix2D(int n, int n2, int[] nArray, int[] nArray2, Object object, boolean bl) {
        int n3;
        block7: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (object == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new Object[n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var9_11] = nArray[n3];
            this.values[var9_11] = object;
        }
        if (bl) {
            this.sortRowIndexes();
        }
    }

    public SparseCCObjectMatrix2D(int n, int n2, int[] nArray, int[] nArray2, Object[] objectArray, boolean bl, boolean bl2) {
        int n3;
        block7: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != objectArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new Object[n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var10_12] = nArray[n3];
            this.values[var10_12] = objectArray[n3];
        }
        if (bl2) {
            this.sortRowIndexes();
        }
    }

    public ObjectMatrix2D assign(final ObjectFunction objectFunction) {
        this.forEachNonZero(new IntIntObjectFunction(){

            public Object apply(int n, int n2, Object object) {
                return objectFunction.apply(object);
            }
        });
        return this;
    }

    public ObjectMatrix2D assign(Object object) {
        if (object == null) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, null);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[i] = object;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D == this) {
            return this;
        }
        this.checkShape(objectMatrix2D);
        if (objectMatrix2D instanceof SparseCCObjectMatrix2D) {
            SparseCCObjectMatrix2D sparseCCObjectMatrix2D = (SparseCCObjectMatrix2D)objectMatrix2D;
            System.arraycopy(sparseCCObjectMatrix2D.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int n = sparseCCObjectMatrix2D.getRowIndexes().length;
            if (this.rowIndexes.length < n) {
                this.rowIndexes = new int[n];
                this.values = new Object[n];
            }
            System.arraycopy(sparseCCObjectMatrix2D.getRowIndexes(), 0, this.rowIndexes, 0, n);
            System.arraycopy(sparseCCObjectMatrix2D.getValues(), 0, this.values, 0, n);
            this.rowIndexesSorted = sparseCCObjectMatrix2D.rowIndexesSorted;
        } else if (objectMatrix2D instanceof SparseRCObjectMatrix2D) {
            SparseRCObjectMatrix2D sparseRCObjectMatrix2D = ((SparseRCObjectMatrix2D)objectMatrix2D).getTranspose();
            this.columnPointers = sparseRCObjectMatrix2D.getRowPointers();
            this.rowIndexes = sparseRCObjectMatrix2D.getColumnIndexes();
            this.values = sparseRCObjectMatrix2D.getValues();
            this.rowIndexesSorted = true;
        } else {
            this.assign((Object)null);
            objectMatrix2D.forEachNonZero(new IntIntObjectFunction(){

                public Object apply(int n, int n2, Object object) {
                    SparseCCObjectMatrix2D.this.setQuick(n, n2, object);
                    return object;
                }
            });
        }
        return this;
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public ObjectMatrix2D forEachNonZero(IntIntObjectFunction intIntObjectFunction) {
        int[] nArray = this.rowIndexes;
        int[] nArray2 = this.columnPointers;
        Object[] objectArray = this.values;
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                Object object;
                int n4 = nArray[n3];
                Object object2 = objectArray[n3];
                objectArray[n3] = object = intIntObjectFunction.apply(n4, n, object2);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseObjectMatrix2D getDense() {
        final DenseObjectMatrix2D denseObjectMatrix2D = new DenseObjectMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntObjectFunction(){

            public Object apply(int n, int n2, Object object) {
                denseObjectMatrix2D.setQuick(n, n2, SparseCCObjectMatrix2D.this.getQuick(n, n2));
                return object;
            }
        });
        return denseObjectMatrix2D;
    }

    public synchronized Object getQuick(int n, int n2) {
        int n3 = SparseCCObjectMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        Object object = 0;
        if (n3 >= 0) {
            object = this.values[n3];
        }
        return object;
    }

    public SparseRCObjectMatrix2D getRowCompressed() {
        SparseCCObjectMatrix2D sparseCCObjectMatrix2D = this.getTranspose();
        SparseRCObjectMatrix2D sparseRCObjectMatrix2D = new SparseRCObjectMatrix2D(this.rows, this.columns);
        sparseRCObjectMatrix2D.columnIndexes = sparseCCObjectMatrix2D.rowIndexes;
        sparseRCObjectMatrix2D.rowPointers = sparseCCObjectMatrix2D.columnPointers;
        sparseRCObjectMatrix2D.values = sparseCCObjectMatrix2D.values;
        sparseRCObjectMatrix2D.columnIndexesSorted = true;
        return sparseRCObjectMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCObjectMatrix2D getTranspose() {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        Object[] objectArray = this.values;
        SparseCCObjectMatrix2D sparseCCObjectMatrix2D = new SparseCCObjectMatrix2D(this.columns, this.rows, nArray2.length);
        int[] nArray3 = new int[n2];
        int[] nArray4 = sparseCCObjectMatrix2D.columnPointers;
        int[] nArray5 = sparseCCObjectMatrix2D.rowIndexes;
        Object[] objectArray2 = sparseCCObjectMatrix2D.values;
        for (n = 0; n < nArray[n3]; ++n) {
            int n4 = nArray2[n];
            nArray3[n4] = nArray3[n4] + 1;
        }
        this.cumsum(nArray4, nArray3, n2);
        for (int i = 0; i < n3; ++i) {
            for (n = nArray[i]; n < nArray[i + 1]; ++n) {
                int n5 = nArray2[n];
                nArray3[n5] = nArray3[n5] + 1;
                nArray5[var2_13] = i;
                objectArray2[var2_13] = objectArray[n];
            }
        }
        return sparseCCObjectMatrix2D;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseCCObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new SparseObjectMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, Object object) {
        int n3 = SparseCCObjectMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (object == null) {
                this.remove(n2, n3);
            } else {
                this.values[n3] = object;
            }
            return;
        }
        if (object != null) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, object);
        }
    }

    public void sortRowIndexes() {
        SparseCCObjectMatrix2D sparseCCObjectMatrix2D = this.getTranspose();
        sparseCCObjectMatrix2D = sparseCCObjectMatrix2D.getTranspose();
        this.columnPointers = sparseCCObjectMatrix2D.columnPointers;
        this.rowIndexes = sparseCCObjectMatrix2D.rowIndexes;
        this.values = sparseCCObjectMatrix2D.values;
        this.rowIndexesSorted = true;
    }

    public void removeZeroes() {
        int n = 0;
        int n2 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        Object[] objectArray = this.values;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (objectArray[j] == null) continue;
                objectArray[n] = objectArray[j];
                nArray2[n++] = nArray2[j];
            }
        }
        nArray[n2] = n;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, Object object) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        ObjectArrayList objectArrayList = new ObjectArrayList(this.values);
        objectArrayList.setSizeRaw(this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        objectArrayList.beforeInsert(n3, object);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = objectArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        ObjectArrayList objectArrayList = new ObjectArrayList(this.values);
        intArrayList.remove(n2);
        objectArrayList.remove(n2);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = objectArrayList.elements();
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    private Object cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            d += (double)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return d;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.columnPointers[this.columns];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, nArray, 0, n2);
        this.rowIndexes = nArray;
        Object[] objectArray = new Object[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, objectArray, 0, n2);
        this.values = objectArray;
    }
}

