/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class ExponentialPower
extends AbstractContinousDoubleDistribution {
    private static final long serialVersionUID = 1L;
    protected double tau;
    private double s;
    private double sm1;
    private double tau_set = -1.0;
    protected static ExponentialPower shared = new ExponentialPower(1.0, ExponentialPower.makeDefaultGenerator());

    public ExponentialPower(double d, DoubleRandomEngine doubleRandomEngine) {
        this.setRandomGenerator(doubleRandomEngine);
        this.setState(d);
    }

    public double nextDouble() {
        return this.nextDouble(this.tau);
    }

    public double nextDouble(double d) {
        double d2;
        double d3;
        double d4;
        if (d != this.tau_set) {
            this.s = 1.0 / d;
            this.sm1 = 1.0 - this.s;
            this.tau_set = d;
        }
        do {
            d2 = this.randomGenerator.raw();
            d2 = 2.0 * d2 - 1.0;
            double d5 = Math.abs(d2);
            d4 = this.randomGenerator.raw();
            if (d5 <= this.sm1) {
                d3 = d5;
                continue;
            }
            double d6 = d * (1.0 - d5);
            d3 = this.sm1 - this.s * Math.log(d6);
            d4 *= d6;
        } while (Math.log(d4) > -Math.exp(Math.log(d3) * d));
        if (d2 < 0.0) {
            return d3;
        }
        return -d3;
    }

    public void setState(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException();
        }
        this.tau = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d) {
        ExponentialPower exponentialPower = shared;
        synchronized (exponentialPower) {
            return shared.nextDouble(d);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.tau + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine doubleRandomEngine) {
        ExponentialPower exponentialPower = shared;
        synchronized (exponentialPower) {
            shared.setRandomGenerator(doubleRandomEngine);
        }
    }
}

