/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.toolkit.JComboBoxExt;
import org.rosuda.JGR.toolkit.JGRPrefs;

public class JGRDataFileSaveDialog
extends JFileChooser
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1217232299652353695L;
    private final JCheckBox append = new JCheckBox("append", false);
    private final JCheckBox quote = new JCheckBox("quote", false);
    private final JCheckBox rownames = new JCheckBox("row.names", false);
    private final JComboBoxExt sepsBox = new JComboBoxExt(new String[]{"\\t", "blank", ",", ";", "|", "Others..."});
    private final String[] seps = new String[]{"\\t", " ", ",", ";", "|"};
    private String data;

    public JGRDataFileSaveDialog(Frame f, String data, String directory) {
        this.setDialogTitle("Save DatFile - " + data);
        if (directory != null && new File(directory).exists()) {
            this.setCurrentDirectory(new File(directory));
        }
        this.data = data;
        this.addActionListener(this);
        this.sepsBox.setMinimumSize(new Dimension(90, 22));
        this.sepsBox.setPreferredSize(new Dimension(90, 22));
        this.sepsBox.setMaximumSize(new Dimension(90, 22));
        this.sepsBox.addItemListener(this);
        if (System.getProperty("os.name").startsWith("Window")) {
            JPanel fileview = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(2);
            JPanel command = new JPanel(new FlowLayout(0));
            command.add(this.append);
            command.add(new JLabel("seps="));
            command.add(this.sepsBox);
            command.add(this.rownames);
            command.add(this.quote);
            fileview.add(command);
            JPanel pp = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(0);
            pp.add(new JPanel());
            this.setPreferredSize(new Dimension(655, 450));
        } else {
            JPanel command = new JPanel(new FlowLayout(0));
            command.add(this.append);
            command.add(new JLabel("seps="));
            command.add(this.sepsBox);
            command.add(this.rownames);
            command.add(this.quote);
            JPanel filename = (JPanel)this.getComponent(this.getComponentCount() - 1);
            filename.add((Component)command, filename.getComponentCount() - 1);
            this.setPreferredSize(new Dimension(550, 450));
        }
        this.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
        this.showSaveDialog(f);
    }

    public void saveFile() {
        if (this.getSelectedFile() != null) {
            JGRPrefs.workingDirectory = this.getCurrentDirectory().getAbsolutePath() + File.separator;
            String file = this.getSelectedFile().toString();
            String useSep = this.sepsBox.getSelectedIndex() >= this.seps.length ? this.sepsBox.getSelectedItem().toString() : this.seps[this.sepsBox.getSelectedIndex()];
            String cmd = "write.table(" + this.data + ",\"" + file.replace('\\', '/') + "\",append=" + (this.append.isSelected() ? "T" : "F") + ",quote=" + (this.quote.isSelected() ? "T" : "F") + ",sep=\"" + useSep + "\",row.names=" + (this.rownames.isSelected() ? "T" : "F") + ")";
            JGR.MAINRCONSOLE.execute(cmd, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "ApproveSelection") {
            this.saveFile();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.sepsBox) {
            this.sepsBox.setEditable(this.sepsBox.getSelectedIndex() == this.sepsBox.getItemCount() - 1);
        }
    }
}

