/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.browser.BrowserController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.REngine.REXP;

public class HeadNode
implements BrowserNode {
    protected boolean expanded = true;
    ArrayList children = new ArrayList();
    TreeCellRenderer renderer = new BlankCellRenderer();

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (node != this.children.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public void setParent(MutableTreeNode arg0) {
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getExecuteableRObjectName() {
        return "globalenv()";
    }

    @Override
    public String getChildExecuteableRObjectName(BrowserNode child) {
        return child.getRName();
    }

    @Override
    public TreeCellRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public String getRName() {
        return null;
    }

    @Override
    public void addChild(BrowserNode node) {
        this.children.add(node);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
    }

    @Override
    public void remove(int index) {
        this.children.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(this.getIndex(node));
    }

    @Override
    public void removeFromParent() {
    }

    @Override
    public void setUserObject(Object arg0) {
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expand) {
        this.expanded = expand;
    }

    @Override
    public void update(DefaultTreeModel mod) {
        final DefaultTreeModel m = mod;
        if (!this.expanded) {
            return;
        }
        try {
            REXP rexp = JGR.idleEval("ls()");
            if (rexp == null) {
                return;
            }
            String[] objectNames = rexp.asStrings();
            String[] objectClasses = new String[]{};
            if (objectNames.length > 0) {
                rexp = JGR.idleEval("sapply(ls(),function(a)class(get(a,envir=globalenv()))[1])");
                if (rexp == null) {
                    return;
                }
                objectClasses = rexp.asStrings();
            }
            int[] ord = new int[]{};
            if (objectNames.length > 0) {
                rexp = JGR.idleEval("order(sapply(ls(),function(x) {tmp <- which(class(get(x,envir=globalenv()))[1]==" + RController.makeRStringVector(BrowserController.getClasses()) + ");if(length(tmp)==0)NA else tmp}))");
                if (rexp == null) {
                    return;
                }
                ord = rexp.asIntegers();
                int i = 0;
                while (i < ord.length) {
                    int n = i++;
                    ord[n] = ord[n] - 1;
                }
            }
            if (objectNames.length < this.children.size()) {
                final String[] objNms = objectNames;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = HeadNode.this.children.size() - 1; i >= objNms.length; --i) {
                            m.removeNodeFromParent((MutableTreeNode)HeadNode.this.children.get(i));
                        }
                    }
                });
            }
            int nc = Math.min(objectNames.length, BrowserController.MAX_CHILDREN);
            for (int i = 0; i < nc; ++i) {
                if (i >= objectClasses.length) continue;
                final BrowserNode node = BrowserController.createNode(this, objectNames[ord[i]], objectClasses[ord[i]]);
                boolean shSep = i > 0 && !objectClasses[ord[i]].equals(objectClasses[ord[i - 1]]);
                node.setShowSep(shSep);
                if (this.children.size() > i && this.children.get(i).equals(node)) {
                    ((BrowserNode)this.children.get(i)).setShowSep(shSep);
                    ((BrowserNode)this.children.get(i)).update(mod);
                    continue;
                }
                final Object[] tmp = this.children.toArray();
                final int j = i;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (tmp.length > j) {
                            for (int ind = j; ind < tmp.length; ++ind) {
                                m.removeNodeFromParent((MutableTreeNode)tmp[ind]);
                            }
                        }
                        m.insertNodeInto(node, HeadNode.this, HeadNode.this.children.size());
                    }
                });
                node.update(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return null;
    }

    @Override
    public void editObject() {
    }

    @Override
    public void removeChildObjectFromR(BrowserNode child) {
        JGR.MAINRCONSOLE.execute("rm(\"" + child.getRName() + "\",envir=" + this.getExecuteableRObjectName() + ")");
    }

    @Override
    public void setShowSep(boolean show) {
    }

    class BlankCellRenderer
    implements TreeCellRenderer {
        JLabel lab = new JLabel();

        BlankCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.lab.setSize(0, 0);
            return this.lab;
        }
    }
}

