/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class FontTracker {
    public static FontTracker current = null;
    Vector components = new Vector();

    public void add(Component comp) {
        comp.setFont(JGRPrefs.DefaultFont);
        this.components.add(comp);
    }

    public void add(JComponent comp) {
        this.add((Component)comp);
    }

    public void setFontBigger() {
        JGRPrefs.FontSize += 2;
        JGRPrefs.refresh();
        this.applyFont();
    }

    public void setFontSmaller() {
        if ((JGRPrefs.FontSize -= 2) <= 6) {
            JGRPrefs.FontSize = 6;
        }
        JGRPrefs.refresh();
        this.applyFont();
    }

    public void applyFont() {
        Enumeration e = this.components.elements();
        Font f = JGRPrefs.DefaultFont;
        while (e.hasMoreElements()) {
            Component comp = (Component)e.nextElement();
            try {
                Class<?> sc = comp.getClass().getSuperclass();
                while (!sc.getName().startsWith("java")) {
                    sc = sc.getSuperclass();
                }
                if (sc.getName().equals("javax.swing.JTable")) {
                    if (f.getSize() > 18) {
                        f = new Font(f.getName(), f.getStyle(), 18);
                    }
                    ((JTable)comp).setRowHeight((int)((double)f.getSize() * 1.6));
                } else if (sc.getName().equals("javax.swing.JTextComponent") || sc.getName().equals("javax.swing.JTextPane") || comp.getClass().getName().equals("jedit.syntax.JEditTextArea")) {
                    f = JGRPrefs.DefaultFont;
                } else if (f.getSize() > 18) {
                    f = new Font(f.getName(), f.getStyle(), 18);
                }
                comp.setFont(f);
            }
            catch (Exception exception) {}
        }
        if (JGR.getREngine() != null && JGR.STARTED) {
            try {
                JGR.eval("options(width=" + JGR.MAINRCONSOLE.getFontWidth() + ")");
            }
            catch (REngineException e1) {
                new ErrorMsg(e1);
            }
            catch (REXPMismatchException e1) {
                new ErrorMsg(e1);
            }
        }
    }
}

