/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.SyntaxArea;
import org.rosuda.JGR.toolkit.SyntaxDocument;

public class SyntaxInput
extends SyntaxArea
implements KeyListener {
    private static final long serialVersionUID = -133939952728860682L;
    public CodeCompleteMultiple mComplete;
    Popup funHelpTip = null;
    private boolean disableEnter = false;
    private String fun = null;
    private String funHelp = null;
    private Popup cmdHelp = null;
    private JToolTip Tip = new JToolTip();
    private Point pc;
    private Point pco;
    private Point ph;
    private String comp;

    public SyntaxInput(String parent, boolean disableEnter) {
        this.disableEnter = disableEnter;
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SyntaxInput.this.funHelpTip != null) {
                    SyntaxInput.this.funHelpTip.hide();
                }
                if (SyntaxInput.this.mComplete != null && SyntaxInput.this.mComplete.isVisible()) {
                    if (SyntaxInput.this.cmdHelp != null) {
                        SyntaxInput.this.cmdHelp.hide();
                    }
                    SyntaxInput.this.mComplete.setVisible(false);
                }
            }
        });
        this.setDocument(new SyntaxInputDocument());
        this.mComplete = new CodeCompleteMultiple(this);
        this.comp = parent;
        this.setFocusTraversalKeysEnabled(false);
    }

    private String getLastCommand() {
        char c;
        int lend;
        int loffset;
        int line;
        if (this.funHelpTip != null) {
            this.funHelpTip.hide();
        }
        String text = this.getText();
        int pos = this.getCaretPosition();
        int lastb = this.getText(0, pos + 1).lastIndexOf(40);
        int lasteb = this.getText(0, pos).lastIndexOf(41);
        if (lasteb > lastb) {
            return null;
        }
        if (lastb < 0) {
            return null;
        }
        if (pos < 0) {
            return null;
        }
        try {
            line = this.getLineOfOffset(pos);
            loffset = this.getLineStartOffset(line);
            lend = this.getLineEndOffset(line);
            if (lastb > lend) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (text.substring(loffset, pos).indexOf("#") >= 0) {
            return null;
        }
        int offset = lastb--;
        int end2 = lastb;
        if (text == null) {
            return null;
        }
        for (pos = lastb; offset > -1 && pos > -1 && ((c = text.charAt(pos)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_'); --offset, --pos) {
        }
        offset = offset == -1 ? 0 : offset;
        try {
            line = this.getLineOfOffset(this.getCaretPosition());
            loffset = this.getLineStartOffset(line);
            lend = this.getLineEndOffset(line);
            if (offset < loffset || end2 > lend) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (this.getCaretPosition() < offset) {
            return null;
        }
        return offset != (end2 = ++lastb) ? text.substring(offset, end2).trim() : null;
    }

    private String getLastPart() {
        char c;
        String text = this.getText();
        int pos = this.getCaretPosition();
        if (pos > 0 && text.length() > 0 && text.charAt(pos - 1) == '(') {
            --pos;
        }
        if (pos < 0) {
            return null;
        }
        int offset = pos - 1;
        int end2 = pos--;
        if (text == null) {
            return null;
        }
        while (offset > -1 && pos > -1 && ((c = text.charAt(pos)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '\\' || c == '/' || c == '~' || c == '$')) {
            --offset;
            --pos;
        }
        offset = offset == -1 ? 0 : ++offset;
        return offset != end2 ? text.substring(offset, end2).trim() : null;
    }

    public void commentSelection(boolean comment) throws BadLocationException {
        int b = this.getLineOfOffset(this.getSelectionEnd());
        for (int a = this.getLineOfOffset(this.getSelectionStart()); a <= b; ++a) {
            int i;
            int ls = this.getLineStartOffset(a);
            ls = this.getSelectionStart() > ls ? this.getSelectionStart() : ls;
            int le = this.getLineEndOffset(a);
            if (comment && this.getText(ls, le - ls) != null && !this.getText(ls, le - ls).trim().startsWith("#") && !this.getText(ls - 1, 1).equals("#")) {
                this.insertAt(ls, "#");
            }
            if (comment || (i = this.getText(ls = this.getLineStartOffset(a), le - ls).indexOf("#")) < 0) continue;
            this.getDocument().remove(ls + i, 1);
        }
    }

    public void shiftSelection(int direction) throws BadLocationException {
        int b = this.getLineOfOffset(this.getSelectionEnd());
        for (int a = this.getLineOfOffset(this.getSelectionStart()); a <= b; ++a) {
            int ls = this.getLineStartOffset(a);
            int le = this.getLineEndOffset(a);
            String tab = "";
            for (int i = 0; i < JGRPrefs.tabWidth; ++i) {
                tab = tab + " ";
            }
            if (direction == -1 && (this.getText(ls, le - ls).startsWith("\t") || this.getText(ls, le - ls).startsWith(tab))) {
                this.getDocument().remove(ls, this.getText(ls, le - ls).startsWith("\t") ? 1 : JGRPrefs.tabWidth);
                continue;
            }
            if (direction != 1) continue;
            this.insertAt(ls, "\t");
        }
    }

    public void showCompletions(String[] result) {
        try {
            this.requestFocus(true);
            if (this.cmdHelp != null) {
                this.cmdHelp.hide();
            }
            this.pc = this.getCaret().getMagicCaretPosition();
            if (this.pc == null) {
                this.processKeyEvent(new KeyEvent(this, 400, 0L, 9, 9, '\t'));
                this.pc = this.getCaret().getMagicCaretPosition();
            }
            if (this.pco != null && this.pco.equals(this.pc)) {
                this.pc = this.pco;
            } else {
                SwingUtilities.convertPointToScreen(this.pc, this);
            }
            this.mComplete.refresh(result);
            this.mComplete.setVisible(true);
            this.cmdHelp = PopupFactory.getSharedInstance().getPopup(this, this.mComplete, this.pc.x, this.pc.y + 15);
            this.cmdHelp.show();
        }
        catch (Exception exception) {
        }
        finally {
            this.requestFocus(true);
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.requestFocus(true);
        if (JGRPrefs.useEmacsKeyBindings) {
            int line;
            if (ke.getKeyCode() == 69 && ke.isControlDown()) {
                try {
                    line = this.getLineOfOffset(this.getCaretPosition());
                    int lend = this.getLineEndOffset(line);
                    this.setCaretPosition(this.getLineCount() == 1 ? lend : lend - 1);
                }
                catch (Exception e) {
                    this.setCaretPosition(this.getText().length());
                }
            }
            if (ke.getKeyCode() == 65 && ke.isControlDown()) {
                try {
                    line = this.getLineOfOffset(this.getCaretPosition());
                    int loffset = this.getLineStartOffset(line);
                    this.setCaretPosition(loffset);
                }
                catch (Exception e) {
                    this.setCaretPosition(0);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 9) {
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
                this.funHelpTip = null;
            }
            String text = null;
            int pos = this.getCaretPosition();
            if (pos == 0) {
                return;
            }
            try {
                int i = this.getLineStartOffset(this.getLineOfOffset(pos));
                text = this.getText(i, pos - i);
            }
            catch (Exception i) {
                // empty catch block
            }
            if (text == null) {
                return;
            }
            int tl = text.length();
            int quotes = 0;
            int dquotes = 0;
            for (int tp = 0; tp < tl; ++tp) {
                char c = text.charAt(tp);
                if (c == '\\') {
                    ++tp;
                    continue;
                }
                if (dquotes != 0 || c != '\'' || (quotes ^= 1) == 0) {
                    // empty if block
                }
                if (quotes == 0 && c == '\"' && (dquotes ^= 1) != 0) continue;
            }
            this.fun = this.getLastPart();
            String[] result = null;
            if (quotes + dquotes > 0) {
                result = RController.completeFile(this.fun == null ? "" : this.fun);
            } else if (this.fun != null) {
                result = RController.completeCommand(this.fun.replaceAll("\\.", "\\."));
            }
            if (result != null && result.length > 1) {
                if (this.funHelpTip != null) {
                    this.funHelpTip.hide();
                }
                if (this.pc == null || !this.pc.equals(this.getCaret().getMagicCaretPosition())) {
                    this.showCompletions(result);
                }
            } else if (result != null && result.length > 0 && result[0] != null && !result[0].equals(this.fun)) {
                if (this.fun.indexOf(File.separator) > 0) {
                    this.fun = this.fun.substring(this.fun.lastIndexOf(File.separator) + 1);
                }
                if (this.fun.indexOf("$") > 0) {
                    this.fun = this.fun.substring(this.fun.lastIndexOf("$") + 1);
                }
                this.insertAt(pos, result[0].replaceFirst(this.fun, ""));
                if (this.cmdHelp != null) {
                    this.cmdHelp.hide();
                }
                if (this.mComplete != null) {
                    this.mComplete.setVisible(false);
                }
            } else if (this.fun != null && this.fun.length() > 0) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.mComplete != null && this.mComplete.isVisible()) {
            int k = ke.getKeyCode();
            if (!(k == 27 || k == 10 || k == 40 || k == 38 || k == 37 || k == 39 || k == 9 || ke.isShiftDown() || ke.isMetaDown() || ke.isControlDown() || ke.isAltDown() || ke.isAltGraphDown())) {
                this.fun = this.getLastPart();
                if (this.fun != null) {
                    String[] result = new String[1];
                    result = RController.completeCommand(this.fun);
                    if (result != null && result.length > 0) {
                        if (this.funHelpTip != null) {
                            this.funHelpTip.hide();
                            this.funHelpTip = null;
                        }
                        this.showCompletions(result);
                    } else {
                        if (this.cmdHelp != null) {
                            this.cmdHelp.hide();
                        }
                        this.mComplete.setVisible(false);
                    }
                } else {
                    if (this.cmdHelp != null) {
                        this.cmdHelp.hide();
                    }
                    this.mComplete.setVisible(false);
                }
            }
        } else if (ke.getKeyCode() == 10) {
            if (this.cmdHelp != null) {
                this.cmdHelp.hide();
            }
            this.mComplete.setVisible(false);
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
                this.funHelpTip = null;
            }
        }
        if (!(ke.getKeyCode() == 9 || ke.getKeyCode() == 38 || ke.getKeyCode() == 40 || ke.getKeyCode() == 27 || ke.getKeyCode() == 10 || ke.isMetaDown() || ke.isControlDown() || ke.isAltDown() || ke.isShiftDown() || !JGRPrefs.useHelpAgent || !this.isHelpAgentWanted() || ke.isShiftDown())) {
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
                this.funHelpTip = null;
            }
            this.showFunHelp(this.getLastCommand());
        }
        if (ke.getKeyCode() == 27) {
            if (this.cmdHelp != null) {
                this.cmdHelp.hide();
                this.pco = this.pc;
            }
            this.mComplete.setVisible(false);
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
            }
            this.pc = null;
        }
        if ((this.mComplete.isVisible() || ke.getKeyCode() == 38 || ke.getKeyCode() == 40 || ke.getKeyCode() == 9) && this.funHelpTip != null) {
            this.funHelpTip.hide();
        }
    }

    private boolean isHelpAgentWanted() {
        if (this.comp.equals("console")) {
            return JGRPrefs.useHelpAgentConsole;
        }
        if (this.comp.equals("editor")) {
            return JGRPrefs.useHelpAgentEditor;
        }
        return false;
    }

    private void showFunHelp(String fun) {
        try {
            this.requestFocus(true);
            this.funHelp = RController.getFunHelpTip(fun);
            if (fun != null && this.funHelp != null) {
                this.Tip = new JToolTip();
                this.Tip.setTipText(this.funHelp);
                this.Tip.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SyntaxInput.this.funHelpTip != null) {
                            SyntaxInput.this.funHelpTip.hide();
                            SyntaxInput.this.funHelpTip = null;
                        }
                    }
                });
                this.ph = this.getCaret().getMagicCaretPosition();
                SwingUtilities.convertPointToScreen(this.ph, this);
                this.funHelpTip = PopupFactory.getSharedInstance().getPopup(this, this.Tip, this.ph.x, this.ph.y + 20);
                this.funHelpTip.show();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.requestFocus(true);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.disableEnter && e.getKeyCode() == 10) {
            return true;
        }
        if (this.mComplete.isVisible() && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
            return true;
        }
        InputMap map = this.getInputMap(condition);
        ActionMap am = this.getActionMap();
        if (map != null && am != null && this.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                return SwingUtilities.notifyAction(action, ks, e, this, e.getModifiers());
            }
        }
        return false;
    }

    class SyntaxInputDocument
    extends SyntaxDocument {
        private static final long serialVersionUID = -6657259742955478662L;

        SyntaxInputDocument() {
        }
    }

    public class CodeCompleteMultiple
    extends JPanel {
        private static final long serialVersionUID = -1282154753438092531L;
        public JList cmds = new JList();
        private JScrollPane sp = new JScrollPane();
        private SyntaxInput parent = null;

        public CodeCompleteMultiple(SyntaxInput tcomp) {
            this.parent = tcomp;
            this.cmds.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        CodeCompleteMultiple.this.completeCommand();
                    }
                }
            });
            this.cmds.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CodeCompleteMultiple.this.completeCommand();
                    }
                }
            });
            this.sp = new JScrollPane(this.cmds);
            this.sp.setMinimumSize(new Dimension(200, 120));
            this.sp.setPreferredSize(new Dimension(200, 120));
            this.sp.setMaximumSize(new Dimension(200, 120));
            this.sp.setVerticalScrollBarPolicy(22);
            this.sp.setAutoscrolls(true);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.sp);
            this.setVisible(false);
        }

        public void refresh(String[] commands) {
            this.cmds.setListData(commands);
            this.cmds.setSelectedIndex(0);
            this.cmds.ensureIndexIsVisible(0);
        }

        public void completeCommand() {
            if (SyntaxInput.this.fun.indexOf(File.separator) >= 0) {
                SyntaxInput.this.fun = SyntaxInput.this.fun.substring(SyntaxInput.this.fun.lastIndexOf(File.separator) + 1);
            }
            if (SyntaxInput.this.fun.indexOf("$") > 0) {
                SyntaxInput.this.fun = SyntaxInput.this.fun.substring(SyntaxInput.this.fun.lastIndexOf("$") + 1);
            }
            this.parent.insertAt(this.parent.getCaretPosition(), this.cmds.getSelectedValue().toString().replaceFirst(SyntaxInput.this.fun == null ? "" : SyntaxInput.this.fun, ""));
            this.setVisible(false);
            if (SyntaxInput.this.cmdHelp != null) {
                SyntaxInput.this.cmdHelp.hide();
            }
        }

        public void selectPrevious() {
            int i = this.cmds.getSelectedIndex();
            if (--i >= 0) {
                this.cmds.setSelectedIndex(i);
            }
            this.cmds.ensureIndexIsVisible(this.cmds.getSelectedIndex());
        }

        public void selectNext() {
            int i = this.cmds.getSelectedIndex();
            if (++i < this.cmds.getModel().getSize()) {
                this.cmds.setSelectedIndex(i);
            }
            this.cmds.ensureIndexIsVisible(this.cmds.getSelectedIndex());
        }

        @Override
        public void setVisible(boolean b) {
            if (!b && SyntaxInput.this.cmdHelp != null) {
                SyntaxInput.this.cmdHelp.hide();
            }
            super.setVisible(b);
        }
    }
}

