/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyMenus;
import cytoscape.view.CyNetworkView;
import ding.view.NodeContextMenuListener;
import giny.model.Node;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.CohesivenessFunction;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.ui.cytoscape.AboutAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.AffinityColouringAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ClusterONECytoscapeTask;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CyNetworkCache;
import uk.ac.rhul.cs.cl1.ui.cytoscape.Graph;
import uk.ac.rhul.cs.cl1.ui.cytoscape.GrowClusterAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.HelpAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.NodeContextMenuAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.NonNumericAttributeException;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ShowControlPanelAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.VisualStyleManager;
import uk.ac.rhul.cs.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoscapePlugin
extends cytoscape.plugin.CytoscapePlugin
implements PropertyChangeListener {
    public static final String ATTRIBUTE_STATUS = "cl1.Status";
    public static final String ATTRIBUTE_AFFINITY = "cl1.Affinity";
    private static CyNetworkCache networkCache = new CyNetworkCache();
    private NodeContextMenuAction nodeContextMenuAction = new NodeContextMenuAction();

    public CytoscapePlugin() {
        CyMenus cyMenus = Cytoscape.getDesktop().getCyMenus();
        cyMenus.addAction((CytoscapeAction)new ShowControlPanelAction());
        cyMenus.addAction((CytoscapeAction)GrowClusterAction.getGlobalInstance());
        cyMenus.addAction((CytoscapeAction)AffinityColouringAction.getGlobalInstance());
        cyMenus.addAction((CytoscapeAction)new HelpAction("introduction"));
        cyMenus.addAction((CytoscapeAction)new AboutAction());
        GrowClusterAction.getGlobalInstance().setEnabled(false);
        AffinityColouringAction.getGlobalInstance().setEnabled(false);
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        nodeAttributes.setAttributeDescription(ATTRIBUTE_STATUS, "This attribute is used by the ClusterONE plugin to indicate the status of a node after a ClusterONE run. The status codes are as follows:\n\nOutlier = the node is not part of any cluster (i.e. it is an outlier)\nCluster = the node is part of exactly one cluster\nOverlap = the node is part of multiple clusters (i.e. it is an overlap)");
        nodeAttributes.setAttributeDescription(ATTRIBUTE_AFFINITY, "This attribute is used by the ClusterONE plugin to indicate the affinity of a node to a given cluster. The attribute values can be (re)calculated manually by right-clicking on a cluster in the ClusterONE result table and selecting the appropriate menu item.");
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_CREATED", this);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public static Graph convertCyNetworkToGraph(CyNetwork network, String weightAttr) {
        Graph graph = null;
        try {
            graph = networkCache.convertCyNetworkToGraph(network, weightAttr);
        }
        catch (NonNumericAttributeException ex) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Weight attribute values must be numeric.", "Error - invalid weight attribute", 0);
            return null;
        }
        return graph;
    }

    public static CyNetworkCache getNetworkCache() {
        return networkCache;
    }

    protected static Pair<List<ValuedNodeSet>, List<Node>> runAlgorithm(CyNetwork network, ClusterONEAlgorithmParameters parameters, String weightAttr, boolean setAttributes) {
        networkCache.invalidate(network);
        Graph graph = CytoscapePlugin.convertCyNetworkToGraph(network, weightAttr);
        if (graph == null) {
            return null;
        }
        List<ValuedNodeSet> clusters = CytoscapePlugin.runAlgorithm(graph, parameters, weightAttr);
        if (clusters != null && setAttributes) {
            CytoscapePlugin.setStatusAttributesOnGraph(graph, clusters);
        }
        return Pair.create(clusters, graph.getNodeMapping());
    }

    protected static List<ValuedNodeSet> runAlgorithm(Graph graph, ClusterONEAlgorithmParameters parameters, String weightAttr) {
        if (graph.getEdgeCount() == 0) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "The selected network contains no edges", "Error - no edges in network", 0);
            return null;
        }
        JTaskConfig config = new JTaskConfig();
        config.displayCancelButton(true);
        config.displayStatus(true);
        ClusterONECytoscapeTask task = new ClusterONECytoscapeTask(parameters);
        task.setGraph(graph);
        TaskManager.executeTask((Task)task, (JTaskConfig)config);
        return task.getResults();
    }

    private static void setStatusAttributesOnGraph(Graph graph, List<ValuedNodeSet> results) {
        int[] occurrences = new int[graph.getNodeCount()];
        Arrays.fill(occurrences, 0);
        for (ValuedNodeSet nodeSet : results) {
            for (Integer nodeIdx : nodeSet) {
                int n = nodeIdx;
                occurrences[n] = occurrences[n] + 1;
            }
        }
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        String[] values = new String[]{"Outlier", "Cluster", "Overlap"};
        byte attrType = nodeAttributes.getType(ATTRIBUTE_STATUS);
        if (attrType != -1 && attrType != 4) {
            int response = JOptionPane.showConfirmDialog((Component)Cytoscape.getDesktop(), "A node attribute named cl1.Status already exists and it is not a string attribute.\nDo you want to remove the existing attribute and re-register it as a string attribute?", "Attribute type mismatch", 0, 2);
            if (response == 1) {
                return;
            }
            nodeAttributes.deleteAttribute(ATTRIBUTE_STATUS);
        }
        int i = 0;
        for (Node node : graph.getNodeMapping()) {
            if (occurrences[i] > 2) {
                occurrences[i] = 2;
            }
            nodeAttributes.setAttribute(node.getIdentifier(), ATTRIBUTE_STATUS, values[occurrences[i]]);
            ++i;
        }
    }

    public static void setAffinityAttributesOnGraph(Graph graph, List<Integer> nodes) {
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        byte attrType = nodeAttributes.getType(ATTRIBUTE_AFFINITY);
        if (attrType != -1 && attrType != 2) {
            int response = JOptionPane.showConfirmDialog((Component)Cytoscape.getDesktop(), "A node attribute named cl1.Affinity already exists and it is not a floating point attribute.\nDo you want to remove the existing attribute and re-register it as a floating point attribute?", "Attribute type mismatch", 0, 2);
            if (response == 1) {
                return;
            }
            nodeAttributes.deleteAttribute(ATTRIBUTE_AFFINITY);
        }
        int i = 0;
        MutableNodeSet nodeSet = new MutableNodeSet((uk.ac.rhul.cs.graph.Graph)graph, nodes);
        CohesivenessFunction func = new CohesivenessFunction();
        double currentQuality = func.calculate(nodeSet);
        for (Node node : graph.getNodeMapping()) {
            double affinity = nodeSet.contains(i) ? -(func.getRemovalAffinity(nodeSet, i) - currentQuality) : func.getAdditionAffinity(nodeSet, i) - currentQuality;
            if (Double.isNaN(affinity)) {
                affinity = 0.0;
            }
            nodeAttributes.setAttribute(node.getIdentifier(), ATTRIBUTE_AFFINITY, Double.valueOf(affinity));
            ++i;
        }
        VisualStyleManager.ensureVizMapperStylesRegistered(false);
        VisualStyleManager.updateAffinityStyleRange();
        Cytoscape.getVisualMappingManager().setVisualStyle("ClusterONE - Affinity");
        Cytoscape.getVisualMappingManager().applyAppearances();
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property == null) {
            return;
        }
        if ("NETWORK_VIEW_CREATED".equals(property)) {
            CyNetworkView view = (CyNetworkView)e.getNewValue();
            view.addNodeContextMenuListener((NodeContextMenuListener)this.nodeContextMenuAction);
        } else if ("NETWORK_MODIFIED".equals(property)) {
            networkCache.invalidate(Cytoscape.getCurrentNetwork());
        } else if (Cytoscape.NETWORK_DESTROYED.equals(property)) {
            networkCache.invalidate(Cytoscape.getCurrentNetwork());
        }
    }

    public static void showBugMessage(String message) {
        StringBuilder sb = new StringBuilder(message);
        sb.append("\n\n");
        sb.append("This is possibly a bug in ");
        sb.append("ClusterONE");
        sb.append(".\nPlease inform the developers about what you were doing and\n");
        sb.append("what the expected result would have been.");
        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), sb.toString(), "Possible bug in ClusterONE", 0);
    }

    public static void showErrorMessage(String message) {
        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "ClusterONE", 0);
    }

    public static void showInformationMessage(String message) {
        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "ClusterONE", 1);
    }
}

