/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import uk.ac.rhul.cs.utils.Multiset;
import uk.ac.rhul.cs.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMultiset<E>
implements Multiset<E> {
    protected TreeMap<E, Integer> data = new TreeMap();

    @Override
    public int add(E element, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("occurrences must not be negative");
        }
        int count = this.count(element);
        if (occurrences > 0) {
            this.data.put(element, count + occurrences);
        }
        return count;
    }

    @Override
    public int count(Object element) {
        Integer count = this.data.get(element);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public Set<E> elementSet() {
        return this.data.keySet();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        HashSet<Multiset.Entry<Entry>> result = new HashSet<Multiset.Entry<Entry>>();
        for (Map.Entry<E, Integer> entry : this.data.entrySet()) {
            result.add(new Entry(entry));
        }
        return result;
    }

    @Override
    public int remove(E element, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("occurrences must not be negative");
        }
        int count = this.count(element);
        if (occurrences > 0) {
            if (count <= occurrences) {
                this.data.remove(element);
            } else {
                this.data.put(element, count - occurrences);
            }
        }
        return count;
    }

    @Override
    public int setCount(E element, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must not be negative");
        }
        int oldCount = this.count(element);
        if (count == 0) {
            this.data.remove(element);
        } else {
            this.data.put(element, count);
        }
        return oldCount;
    }

    @Override
    public boolean add(E element) {
        int count = this.count(element);
        this.data.put(element, count + 1);
        return count > 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        boolean result = false;
        for (E element : elements) {
            result |= this.add(element);
        }
        return result;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsAll(Collection<?> keys) {
        for (Object o : keys) {
            if (this.data.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.keySet().iterator();
    }

    @Override
    public boolean remove(Object element) {
        int count = this.count(element);
        if (count == 0) {
            return false;
        }
        if (count == 1) {
            this.data.remove(element);
            return true;
        }
        this.data.put(element, count - 1);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        boolean result = false;
        for (Object element : elements) {
            result |= this.remove(element);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int totalSize = 0;
        for (Map.Entry<E, Integer> entry : this.data.entrySet()) {
            totalSize += entry.getValue().intValue();
        }
        return totalSize;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Map.Entry<E, Integer> entry : this.data.entrySet()) {
            E obj = entry.getKey();
            int n = entry.getValue();
            int j = 0;
            while (j < n) {
                result[i] = obj;
                ++j;
                ++i;
            }
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] dummy) {
        return this.toArray();
    }

    public String toString() {
        return "[" + StringUtils.join(this.entrySet().iterator(), ", ") + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry
    implements Multiset.Entry<E> {
        E object;
        int count;

        private Entry(Map.Entry<E, Integer> entry) {
            this.object = entry.getKey();
            this.count = entry.getValue();
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public E getElement() {
            return this.object;
        }

        @Override
        public String toString() {
            if (this.count == 1) {
                return this.object.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.object.toString());
            sb.append(" x ");
            sb.append(this.count);
            return sb.toString();
        }
    }
}

