/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.message.TransmitDataRequest;
import com.portfolioeffect.quant.client.message.type.FastMessageType;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageParser;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.MetricRefreshValue;
import com.portfolioeffect.quant.client.util.MetricUpdateCallback;
import com.portfolioeffect.quant.client.util.SimpleMetricUpdateCallback;
import java.io.IOException;
import java.util.ArrayList;
import org.openfast.Message;

public class StreamWoker
implements Runnable {
    private ArrayCache[] batchValues;
    private ArrayCache[] batchValuesTime;
    private int[] dimensions;
    private MetricUpdateCallback streamRefreshCallback = null;
    private SimpleMetricUpdateCallback streamRefreshCallbackPureData = null;
    private final ClientConnection client;

    public StreamWoker(ClientConnection client, ArrayCache[] batchValues, ArrayCache[] batchValuesTime, int[] dimensions) {
        this.batchValues = batchValues;
        this.batchValuesTime = batchValuesTime;
        this.dimensions = dimensions;
        this.streamRefreshCallback = client.getStreamRefreshCallback();
        this.streamRefreshCallbackPureData = client.getStreamRefreshCallbackPureData();
        this.client = client;
    }

    @Override
    public void run() {
        Console.writeln("Start stream data");
        this.client.setStreamRuning(true);
        String stopReason = "terminated by user";
        while (this.client.isStreamEnabled() && !Thread.interrupted()) {
            try {
                Message responseMsg = this.client.awaitResponse();
                FastMessageType responseMessageType = this.client.getMessageType(responseMsg);
                if (responseMessageType == FastMessageType.LOGOUT) {
                    this.client.sendToSelf(responseMsg);
                    break;
                }
                TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
                if (response.getMsgType().contains("OK")) {
                    float[] data = response.getDataFloat();
                    long[] time = response.getTime();
                    if (data.length == 0) continue;
                    for (int k = 0; k < this.batchValues.length; ++k) {
                        this.batchValuesTime[k].lockToWrite();
                        this.batchValues[k].lockToWrite();
                    }
                    int len = 0;
                    for (int t = 0; t < time.length; ++t) {
                        for (int k = 0; k < this.dimensions.length; ++k) {
                            for (int m = 0; m < this.dimensions[k]; ++m) {
                                this.batchValues[k].writeNextDouble(data[len]);
                                ++len;
                            }
                            this.batchValuesTime[k].writeNextLong(time[t]);
                        }
                    }
                    for (int k = 0; k < this.batchValues.length; ++k) {
                        this.batchValuesTime[k].unlockToWrite();
                        this.batchValues[k].unlockToWrite();
                    }
                    if (this.streamRefreshCallback != null) {
                        ArrayList<MetricRefreshValue> refreshValue = new ArrayList<MetricRefreshValue>();
                        len = 0;
                        for (int i = 0; i < time.length; ++i) {
                            for (int j = 0; j < this.dimensions.length; ++j) {
                                for (int k = 0; k < this.dimensions[j]; ++k) {
                                    if (!Double.isNaN(data[len]) && this.client.getBatchMetricKeys() != null) {
                                        refreshValue.add(new MetricRefreshValue(this.client.getBatchMetricKeys().get(j), k, data[len], time[i]));
                                    }
                                    ++len;
                                }
                            }
                        }
                        if (refreshValue.size() > 0) {
                            this.streamRefreshCallback.onDataRefresh(refreshValue);
                        }
                    }
                    if (this.streamRefreshCallbackPureData != null && time.length > 0) {
                        this.streamRefreshCallbackPureData.onDataRefresh(data, time);
                    }
                    if (!response.getMsgType().contains("STOP")) continue;
                    stopReason = "terminated by server";
                    break;
                }
                stopReason = response.getMsgBody();
                break;
            }
            catch (IOException e) {
                stopReason = "Error - " + e.getMessage();
                break;
            }
            catch (Exception e) {
                stopReason = "Error - " + e.getMessage();
                break;
            }
        }
        Console.writeln("Stop stream data: " + stopReason);
        this.client.setStreamEnabled(false);
        this.client.setStreamRuning(false);
    }
}

