/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.result;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.PortfolioContainer;
import com.portfolioeffect.quant.client.portfolio.Position;
import com.portfolioeffect.quant.client.result.AbstractMethodResult;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.type.MetricsTypeFull;
import com.portfolioeffect.quant.client.util.LazyMetricBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LazyMetric
extends AbstractMethodResult {
    private Portfolio portfolio;
    private Position position;
    private String metricType;
    private HashMap<String, String> metricMapFull;
    private HashMap<String, String> metricParams;
    private final LazyMetricBuilder lazyMetricBuilder;
    private ReentrantLock lockC = new ReentrantLock();
    private HashMap<String, String> portfolioParams;
    private boolean isComputed = false;
    private LazyMetric timeShift = null;
    private volatile boolean isAsyncComputation = false;
    private volatile boolean isMultiplexConnection = true;

    public LazyMetric(Metric result) {
        this.lazyMetricBuilder = null;
        this.isComputed = true;
        this.isDebug = result.isDebug;
        this.hasResult = result.hasResult;
        this.hasError = result.hasError;
        this.hasWarning = result.hasWarning;
        this.errorMessage = result.errorMessage;
        this.warningMessage = result.warningMessage;
        this.message = result.message;
        this.infoParams = result.infoParams;
        this.data = new HashMap(result.data);
        this.dataType = new HashMap(result.dataType);
        this.portfolio = null;
    }

    public LazyMetric(PortfolioContainer container, String metricType, String metricTypeFull, LazyMetricBuilder builder) {
        this.portfolio = new Portfolio(container);
        this.metricType = metricTypeFull;
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        this.metricMapFull = (HashMap)gson.fromJson(metricTypeFull, mapType);
        this.metricParams = (HashMap)gson.fromJson(metricType, mapType);
        this.portfolioParams = new HashMap<String, String>(this.portfolio.getPortfolioData().getPortfolioSettings());
        this.portfolioParams.putAll(this.portfolio.getPortfolioData().getEstimatorSettings());
        this.lazyMetricBuilder = new LazyMetricBuilder(builder);
    }

    public LazyMetric(String errorMessage) {
        super(errorMessage);
        this.lazyMetricBuilder = null;
    }

    public LazyMetric(String errorMessage, String warnnigMessage) {
        super(errorMessage, warnnigMessage);
        this.lazyMetricBuilder = null;
    }

    public LazyMetric(boolean hasError, String errorMessage) {
        super(hasError, errorMessage);
        this.lazyMetricBuilder = null;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void computeAsync() {
        this.asyncComputationEnable();
        this.compute();
    }

    public void restoreComputation() {
        this.portfolio.restoreBatch();
    }

    @Override
    public void compute() {
        Metric result;
        boolean flagNewConnection;
        block14: {
            this.lockC.lock();
            if (this.metricType == null) {
                this.isComputed = true;
            }
            if (this.isComputed) {
                this.lockC.unlock();
                return;
            }
            this.lock();
            flagNewConnection = false;
            result = new Metric();
            try {
                if (!this.portfolio.isContainsResult(this.metricType) && this.isAsyncComputation) {
                    this.portfolio.getContainer().makeAsincConnection(this.isMultiplexConnection);
                    flagNewConnection = true;
                }
                result = this.portfolio.finishBatch();
            }
            catch (Exception e) {
                if (!this.isDebug) break block14;
                e.printStackTrace();
            }
        }
        if (!result.getErrorMessage().contains("server overloaded")) {
            result = this.portfolio.getMetric(this.metricType);
        }
        if (!result.hasError() || !result.errorMessage.contains("server overloaded")) {
            this.isComputed = true;
            this.isDebug = result.isDebug;
            this.hasResult = result.hasResult;
            this.hasError = result.hasError;
            this.hasWarning = result.hasWarning;
            this.errorMessage = result.errorMessage;
            this.warningMessage = result.warningMessage;
            this.message = result.message;
            this.infoParams = result.infoParams;
            this.data = new HashMap(result.data);
            this.dataType = result.dataType;
            if (flagNewConnection) {
                this.portfolio.getContainer().makeSincConnection(this.isMultiplexConnection);
                this.isAsyncComputation = false;
            }
            this.unlock();
            this.portfolio = null;
            this.position = null;
            if (this.timeShift != null) {
                try {
                    this.addShiftToTime(this.timeShift);
                }
                catch (ComputeErrorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.lockC.unlock();
        } else {
            this.isComputed = false;
            this.isDebug = result.isDebug;
            this.hasResult = result.hasResult;
            this.hasError = result.hasError;
            this.hasWarning = result.hasWarning;
            this.errorMessage = result.errorMessage;
            this.warningMessage = result.warningMessage;
            this.message = result.message;
            this.infoParams = result.infoParams;
            this.data = new HashMap(result.data);
            this.dataType = result.dataType;
            if (flagNewConnection) {
                this.portfolio.getContainer().makeSincConnection(this.isMultiplexConnection);
                this.isAsyncComputation = false;
            }
            this.portfolio.restoreBatch();
            this.unlock();
            this.lockC.unlock();
        }
    }

    @Override
    protected void computeMetric() throws ComputeErrorException {
        this.compute();
        if (this.hasError) {
            throw new ComputeErrorException(this.errorMessage);
        }
    }

    public String getDescription() {
        String description = "";
        MetricsTypeFull metric = MetricsTypeFull.valueOf(this.metricMapFull.get("metric").trim());
        description = metric.getDescription();
        if (this.metricMapFull.containsKey("goal")) {
            description = description + "(" + this.getDescription(this.metricMapFull.get("goal")) + ")";
        }
        String[][] args = metric.getMetricArguments();
        for (int i = 0; i < args.length; ++i) {
            description = i == 0 ? description + ": " : description + ", ";
            description = description + args[i][1] + "=" + this.metricMapFull.get(args[i][0]);
        }
        description = description + "";
        return description;
    }

    private String getDescription(String str) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap metricMap = (HashMap)gson.fromJson(str, mapType);
        String description = "";
        MetricsTypeFull metric = MetricsTypeFull.valueOf(((String)metricMap.get("metric")).trim());
        description = metric.getDescription();
        String[][] args = metric.getMetricArguments();
        for (int i = 0; i < args.length; ++i) {
            description = i == 0 ? description + ": " : description + ", ";
            description = description + args[i][1] + "=" + (String)metricMap.get(args[i][0]);
        }
        description = description + "";
        return description;
    }

    public String getSymbol() {
        if (this.metricMapFull.containsKey("position")) {
            return this.metricMapFull.get("position");
        }
        return "Portfolio";
    }

    @Override
    protected void clear() {
        this.portfolio = null;
        this.position = null;
    }

    @Override
    protected void finalize() throws Throwable {
        this.portfolio = null;
        this.position = null;
        super.finalize();
    }

    @Override
    public void del() throws Throwable {
        this.finalize();
    }

    public HashMap<String, String> getMetricParams() {
        return this.metricParams;
    }

    public HashMap<String, String> getPortfolioParams() {
        return this.portfolioParams;
    }

    public LazyMetricBuilder getLazyMetricBuilder() {
        return new LazyMetricBuilder(this.lazyMetricBuilder);
    }

    public void setTimeShift(LazyMetric timeShift) {
        this.timeShift = timeShift;
    }

    public LazyMetric addInput(LazyMetric[] metrics) throws Exception {
        LazyMetricBuilder builder = new LazyMetricBuilder(this.lazyMetricBuilder);
        LazyMetricBuilder builderIn = metrics[0].getLazyMetricBuilder();
        if (builderIn.contains("forecastStep") && builderIn.contains("timeShift")) {
            builder.setParam("forecastStep", builderIn.getParam("forecastStep"));
            builder.setParam("timeShift", builderIn.getParam("timeShift"));
        }
        for (LazyMetric e : metrics) {
            String metricType = e.getLazyMetricBuilder().getParam("metricType");
            builder.setParam(metricType, e);
        }
        if (this.position != null) {
            return builder.build(this.position);
        }
        return new LazyMetric("ERROR: this method don't work with portfolio metrics");
    }

    public LazyMetric addInput(LazyMetric metric) throws Exception {
        return this.addInput(new LazyMetric[]{metric});
    }

    public void lock() {
        this.portfolio.lock();
    }

    public void unlock() {
        this.portfolio.unlock();
    }

    public boolean tryLock() {
        return this.portfolio.tryLock();
    }

    public boolean isComputed() {
        return this.isComputed;
    }

    public boolean isAsyncComputation() {
        return this.isAsyncComputation;
    }

    public void setAsyncComputation(boolean isAsyncComputation) {
        this.isAsyncComputation = isAsyncComputation;
    }

    public void asyncComputationEnable() {
        this.isAsyncComputation = true;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public boolean isMultiplexConnection() {
        return this.isMultiplexConnection;
    }

    public void setMultiplexConnection(boolean isMultiplexConnection) {
        this.isMultiplexConnection = isMultiplexConnection;
    }
}

