/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.h2.constant.SysProperties;
import org.h2.engine.Constants;
import org.h2.store.DataHandler;
import org.h2.store.LobStorageInterface;
import org.h2.store.LobStorageRemoteInputStream;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;

public class LobStorageFrontend
implements LobStorageInterface {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    private final DataHandler handler;

    public LobStorageFrontend(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    @Override
    public void removeLob(long l) {
    }

    @Override
    public InputStream getInputStream(long l, byte[] byArray, long l2) throws IOException {
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        return new BufferedInputStream(new LobStorageRemoteInputStream(this.handler, l, byArray, l2));
    }

    @Override
    public ValueLobDb copyLob(int n, long l, int n2, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTable(long l, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value createBlob(InputStream inputStream, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            return ValueLobDb.createTempBlob(inputStream, l, this.handler);
        }
        return ValueLob.createBlob(inputStream, l, this.handler);
    }

    @Override
    public Value createClob(Reader reader, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            return ValueLobDb.createTempClob(reader, l, this.handler);
        }
        return ValueLob.createClob(reader, l, this.handler);
    }

    public static Value createSmallLob(int n, byte[] byArray) {
        if (SysProperties.LOB_IN_DATABASE) {
            int n2 = n == 16 ? new String(byArray, Constants.UTF8).length() : byArray.length;
            return ValueLobDb.createSmallLob(n, byArray, n2);
        }
        return ValueLob.createSmallLob(n, byArray);
    }
}

