/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultExtremeValuesCorrector;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;

public class PeriodSpecificExtremeValuesCorrector
extends DefaultExtremeValuesCorrector {
    private static final double EPS = 1.0E-15;
    private static final double EPS_STDEV = 1.0E-5;

    @Override
    protected void calcStdev() {
        Integer i = 0;
        PeriodIterator iteri = new PeriodIterator(this.scur);
        Integer np = this.scur.getFrequency().intValue();
        this.stdev = new double[np.intValue()];
        while (iteri.hasMoreElements()) {
            DataBlock dbi = iteri.nextElement().data;
            this.stdev[i.intValue()] = this.calcStdev(dbi);
            i = i + 1;
        }
    }

    @Override
    protected int outliersDetection() {
        int nval = 0;
        this.sweights = new TsData(this.scur.getDomain());
        PeriodIterator iteri = new PeriodIterator(this.scur);
        PeriodIterator itero = new PeriodIterator(this.sweights);
        this.sweights.set(() -> 1.0);
        double xbar = this.getMean();
        int y = 0;
        while (iteri.hasMoreElements()) {
            boolean isNullStdev = false;
            double lv = this.stdev[y] * this.lsigma;
            double uv = this.stdev[y] * this.usigma;
            if (Math.abs(this.stdev[y]) < 1.0E-5) {
                isNullStdev = true;
            }
            DataBlock dbi = iteri.nextElement().data;
            DataBlock dbo = itero.nextElement().data;
            if (!isNullStdev) {
                for (int i = 0; i < dbi.getLength(); ++i) {
                    double tt = Math.abs(dbi.get(i) - xbar);
                    if (tt - uv > 1.0E-15) {
                        dbo.set(i, 0.0);
                        ++nval;
                        continue;
                    }
                    if (!(tt - lv > 1.0E-15)) continue;
                    dbo.set(i, (uv - tt) / (uv - lv));
                }
            }
            ++y;
        }
        return nval;
    }

    @Override
    public double[] getStandardDeviations() {
        return this.stdev;
    }
}

