/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x13;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.IPreprocessingFilter;
import ec.satoolkit.x11.DefaultPreprocessor;
import ec.satoolkit.x11.X11Kernel;
import ec.satoolkit.x11.X11Results;
import ec.satoolkit.x11.X11Specification;
import ec.satoolkit.x11.X11Toolkit;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;

public class X11Decomposer
implements IDefaultSeriesDecomposer<X11Results> {
    private X11Specification spec_;
    private X11Results results_;

    public X11Decomposer(X11Specification spec) {
        this.spec_ = spec;
    }

    @Override
    public boolean decompose(TsData s) {
        X11Specification spec = this.spec_.clone();
        X11Toolkit toolkit = X11Toolkit.create(spec);
        X11Kernel kernel = new X11Kernel();
        kernel.setToolkit(toolkit);
        this.results_ = kernel.process(s);
        return this.results_ != null;
    }

    @Override
    public boolean decompose(PreprocessingModel model, IPreprocessingFilter filter) {
        X11Specification spec = this.prepareSpec(model);
        X11Toolkit toolkit = X11Toolkit.create(spec);
        toolkit.setPreprocessor(new DefaultPreprocessor(model, filter, spec.getMode() == DecompositionMode.PseudoAdditive));
        X11Kernel kernel = new X11Kernel();
        kernel.setToolkit(toolkit);
        this.results_ = kernel.process(model.interpolatedSeries(false));
        return this.results_ != null;
    }

    @Override
    public X11Results getDecomposition() {
        return this.results_;
    }

    private X11Specification prepareSpec(PreprocessingModel model) {
        X11Specification spec = this.spec_.clone();
        if (spec.getMode() == DecompositionMode.PseudoAdditive) {
            return spec;
        }
        boolean mul = model.isMultiplicative();
        if (mul) {
            if (!spec.getMode().isMultiplicative()) {
                spec.setMode(DecompositionMode.Multiplicative);
            }
        } else {
            spec.setMode(DecompositionMode.Additive);
        }
        return spec;
    }

    private X11Specification prepareSpec(TsData s) {
        X11Specification spec = this.spec_.clone();
        DescriptiveStatistics stats = new DescriptiveStatistics(s);
        boolean add = stats.isNegativeOrNull();
        if (add) {
            spec.setMode(DecompositionMode.Additive);
        }
        return spec;
    }
}

