/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.levmar;

import ec.tstoolkit.algorithm.IProcessingHook;
import ec.tstoolkit.algorithm.ProcessingHookProvider;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ParamValidation;

public class LevenbergMarquardtMethod
extends ProcessingHookProvider<LevenbergMarquardtMethod, ISsqFunctionInstance>
implements ISsqFunctionMinimizer {
    static final int DEF_MAX_ITER = 200;
    static final double EPSILON = 1.0E-17;
    static final double DEF_INIT_MU = 0.001;
    static final double DEF_STOP_THRESH = 1.0E-15;
    static final double DEF_STOP_THRESH_3 = 1.0E-12;
    private int itmax = 200;
    private int iter = 0;
    private double tau = 0.001;
    private double eps1 = 1.0E-15;
    private double eps2 = 1.0E-15;
    private double eps2_sq = 1.0E-30;
    private double eps3 = 1.0E-12;
    private DataBlock Jte;
    private ISsqFunction fn_;
    private ISsqFunctionInstance fcur_;
    private ISsqFunctionInstance ftry_;
    private DataBlock ecur;
    private double Fcur_;
    private double Ftry_;
    private Matrix J;
    private Matrix V;
    private double[] G;
    private double scale_;
    private double scale2_;
    private double mu;
    private long nu;
    private int stop;
    private static final double ONE_THIRD = 0.3333333333333333;

    public boolean minimize(ISsqFunction fn, IReadDataBlock pstart) {
        return this.minimize(fn, fn.ssqEvaluate(pstart));
    }

    public boolean hasConverged() {
        return this.stop == 2;
    }

    @Override
    public ISsqFunctionMinimizer exemplar() {
        LevenbergMarquardtMethod ex = new LevenbergMarquardtMethod();
        ex.eps1 = this.eps1;
        ex.eps2 = this.eps2;
        ex.eps3 = this.eps3;
        ex.eps2_sq = this.eps2_sq;
        ex.itmax = this.itmax;
        ex.copyHooks(this);
        return ex;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.eps3;
    }

    @Override
    public Matrix getCurvature() {
        if (this.V == null) {
            ISsqFunctionDerivatives derivatives = this.fn_.getDerivatives(this.fcur_);
            this.V = derivatives.getHessian();
            this.G = derivatives.getGradient();
        }
        return this.V;
    }

    @Override
    public double[] getGradient() {
        if (this.G == null) {
            ISsqFunctionDerivatives derivatives = this.fn_.getDerivatives(this.fcur_);
            this.V = derivatives.getHessian();
            this.G = derivatives.getGradient();
        }
        return this.G;
    }

    @Override
    public int getIterCount() {
        return this.iter;
    }

    @Override
    public int getMaxIter() {
        return this.itmax;
    }

    @Override
    public ISsqFunctionInstance getResult() {
        return this.fcur_;
    }

    @Override
    public double getObjective() {
        return this.Fcur_;
    }

    @Override
    public boolean minimize(ISsqFunction function, ISsqFunctionInstance start) {
        this.fn_ = function;
        this.fcur_ = start;
        return this.calc();
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.eps3 = value;
    }

    @Override
    public void setMaxIter(int n) {
        this.itmax = n;
    }

    protected boolean iterate() {
        if (!Double.isFinite(this.Fcur_)) {
            this.stop = 7;
            return false;
        }
        if (this.Fcur_ <= this.eps3 * this.scale2_) {
            this.stop = 6;
            return false;
        }
        this.fn_.getDerivatives(this.fcur_).getJacobian(this.J.subMatrix());
        this.Jte.product(this.J.columns(), this.ecur);
        int m = this.J.getColumnsCount();
        this.V = SymmetricMatrix.XtX(this.J);
        double nJte = this.Jte.nrmInf();
        if (nJte <= this.eps1 * this.scale_) {
            this.stop = 1;
            return false;
        }
        int kiter = 0;
        while (kiter++ < 100) {
            block20: {
                DataBlock dp = null;
                Matrix K = this.V.clone();
                if (this.mu > 0.0) {
                    K.diagonal().add(this.mu);
                }
                boolean solved = false;
                try {
                    SymmetricMatrix.lcholesky(K);
                    dp = this.Jte.deepClone();
                    dp.chs();
                    LowerTriangularMatrix.rsolve(K, dp);
                    LowerTriangularMatrix.lsolve(K, dp);
                    solved = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (solved) {
                    double pl2;
                    if (!Double.isFinite(dp.ssq())) {
                        this.stop = 7;
                        return false;
                    }
                    DataBlock np = new DataBlock(this.fcur_.getParameters());
                    double dpl2 = dp.ssq();
                    if (dpl2 <= this.eps2 * ((pl2 = np.ssq()) + this.eps2)) {
                        this.stop = 2;
                        return false;
                    }
                    if (dpl2 >= (pl2 + this.eps2) / 1.0000000000000001E-34) {
                        this.stop = 4;
                        return false;
                    }
                    np.add(dp);
                    ParamValidation status = this.fn_.getDomain().validate(np);
                    if (status != ParamValidation.Invalid) {
                        try {
                            this.ftry_ = this.fn_.ssqEvaluate(np);
                            this.Ftry_ = this.ftry_.getSsqE();
                            double dF = this.Fcur_ - this.Ftry_;
                            if (!(dF > 0.0)) break block20;
                            if (status == ParamValidation.Changed) {
                                this.fcur_ = this.ftry_;
                                this.Fcur_ = this.Ftry_;
                                this.ecur = new DataBlock(this.fcur_.getE());
                                return true;
                            }
                            DataBlock dl = this.Jte.deepClone();
                            dl.addAY(-this.mu, dp);
                            double dL = -dl.dot(dp);
                            double ratio = dF / dL;
                            if (ratio > 1.0E-4) {
                                double tmp = 2.0 * ratio - 1.0;
                                tmp = 1.0 - tmp * tmp * tmp;
                                if (this.mu != 0.0) {
                                    this.mu *= tmp >= 0.3333333333333333 ? tmp : 0.3333333333333333;
                                }
                                this.nu = 4L;
                                boolean end = dF <= this.eps3 * this.scale2_;
                                this.fcur_ = this.ftry_;
                                this.Fcur_ = this.Ftry_;
                                this.ecur = new DataBlock(this.fcur_.getE());
                                if (end) {
                                    this.V = null;
                                    this.stop = 2;
                                    return false;
                                }
                                return true;
                            }
                        }
                        catch (Exception err) {
                            solved = false;
                        }
                    } else {
                        solved = false;
                    }
                }
            }
            this.mu = this.mu == 0.0 ? this.tau * this.V.diagonal().max() : (this.mu *= (double)this.nu);
            long nu2 = this.nu << 2;
            if (nu2 <= this.nu) {
                this.stop = 5;
                return false;
            }
            this.nu = nu2;
        }
        return false;
    }

    private boolean calc() {
        this.G = null;
        this.V = null;
        this.iter = 0;
        this.nu = 4L;
        this.mu = 0.0;
        this.ecur = new DataBlock(this.fcur_.getE());
        this.scale2_ = this.Fcur_ = this.fcur_.getSsqE();
        this.scale_ = Math.sqrt(this.Fcur_);
        int n = this.ecur.getLength();
        int m = this.fn_.getDomain().getDim();
        this.J = new Matrix(n, m);
        this.Jte = new DataBlock(m);
        while (this.iter++ < this.itmax) {
            boolean rslt = this.iterate();
            if (this.hasHooks()) {
                IProcessingHook.HookInformation<LevenbergMarquardtMethod, ISsqFunctionInstance> hinfo = new IProcessingHook.HookInformation<LevenbergMarquardtMethod, ISsqFunctionInstance>(this, this.fcur_);
                this.processHooks(hinfo, true);
                if (hinfo.cancel) {
                    rslt = false;
                }
            }
            if (rslt) continue;
            break;
        }
        return this.stop != 7 && this.stop != 4;
    }
}

