/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.Spectrum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UcarimaModel
implements Cloneable {
    private static final double EPS = 1.0E-6;
    private IArimaModel m_model;
    private ArrayList<ArimaModel> m_cmps = new ArrayList();

    public UcarimaModel() {
    }

    public UcarimaModel(IArimaModel model, ArimaModel[] cmps) {
        Collections.addAll(this.m_cmps, cmps);
        if (model != null) {
            this.m_model = model;
        }
    }

    public UcarimaModel(IArimaModel model, List<ArimaModel> cmps) {
        this.m_cmps.addAll(cmps);
        if (model != null) {
            this.m_model = model;
        }
    }

    public void addComponent(ArimaModel model) {
        this.m_cmps.add(model);
        this.m_model = null;
    }

    public void clear() {
        this.m_cmps.clear();
        this.m_model = null;
    }

    public UcarimaModel clone() {
        try {
            UcarimaModel model = (UcarimaModel)super.clone();
            model.m_cmps = (ArrayList)this.m_cmps.clone();
            return model;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void compact(int istart, int count) {
        int i;
        ArimaModel sum = this.m_cmps.get(istart);
        for (i = 1; i < count; ++i) {
            sum = sum.plus(this.m_cmps.get(istart + i), false);
        }
        for (i = istart + 1; i < istart + 1 + count - 1; ++i) {
            this.m_cmps.remove(i);
        }
        this.m_cmps.set(istart, sum);
    }

    public ArimaModel getComplement(int cmp) {
        if (this.m_cmps.size() <= 1) {
            return new ArimaModel(null, null, null, 0.0);
        }
        ArimaModel sum = null;
        for (int i = 0; i < this.m_cmps.size(); ++i) {
            ArimaModel cur;
            if (cmp == i || (cur = this.m_cmps.get(i)).isNull()) continue;
            sum = sum == null ? cur : sum.plus(cur, false);
        }
        if (sum == null) {
            return new ArimaModel(null, null, null, 0.0);
        }
        return sum;
    }

    public ArimaModel getComponent(int idx) {
        return this.m_cmps.get(idx);
    }

    public int getComponentsCount() {
        return this.m_cmps.size();
    }

    public IArimaModel getModel() {
        if (this.m_model == null) {
            this.m_model = this.sum();
        }
        return this.m_model;
    }

    public ArimaModel[] getComponents() {
        int n = 0;
        for (ArimaModel cmp : this.m_cmps) {
            if (cmp == null) continue;
            ++n;
        }
        ArimaModel[] cmps = new ArimaModel[n];
        n = 0;
        for (ArimaModel cmp : this.m_cmps) {
            if (cmp == null) continue;
            cmps[n++] = cmp;
        }
        return cmps;
    }

    public boolean isValid() {
        try {
            for (int i = 0; i < this.m_cmps.size(); ++i) {
                if (this.m_cmps.get(i) == null || !(this.m_cmps.get(i).getInnovationVariance() < 0.0)) continue;
                return false;
            }
            return true;
        }
        catch (ArimaException e) {
            return false;
        }
    }

    public boolean setVarianceMax(int ncmp) {
        double var = this.setVarianceMax(ncmp, false);
        return var >= 0.0;
    }

    public double setVarianceMax(int ncmp, boolean adjustModel) {
        return this.setVarianceMax(ncmp, adjustModel, true);
    }

    @Deprecated
    public double setVarianceMax(int ncmp, boolean adjustModel, boolean def) {
        double var = 0.0;
        if (this.m_cmps.isEmpty()) {
            return 0.0;
        }
        if (ncmp < 0) {
            this.m_cmps.add(new ArimaModel(null, null, null, 0.0));
            ncmp = this.m_cmps.size() - 1;
        } else {
            for (int i = this.m_cmps.size(); i <= ncmp; ++i) {
                this.m_cmps.add(new ArimaModel(null, null, null, 0.0));
            }
        }
        Spectrum.Minimizer min = new Spectrum.Minimizer();
        for (int i = 0; i < this.m_cmps.size(); ++i) {
            ArimaModel m;
            if (i == ncmp || (m = this.m_cmps.get(i)) == null) continue;
            if (def) {
                min.minimize(m.getSpectrum());
            } else {
                min.minimize2(m.getSpectrum());
            }
            if (min.getMinimum() == 0.0) continue;
            var += min.getMinimum();
            this.m_cmps.set(i, m.minus(min.getMinimum()));
        }
        if (var < 0.0 && adjustModel) {
            this.m_model = ArimaModel.add(-var, ArimaModel.create(this.m_model));
        } else {
            this.m_cmps.set(ncmp, this.m_cmps.get(ncmp).plus(var));
        }
        return var;
    }

    public void simplify() {
        for (int i = this.m_cmps.size() - 1; i >= 0; --i) {
            if (!this.m_cmps.get(i).isNull()) continue;
            this.m_cmps.remove(i);
        }
    }

    public final ArimaModel sum() {
        if (this.m_cmps.isEmpty()) {
            return new ArimaModel(null, null, null, 0.0);
        }
        ArimaModel sum = this.m_cmps.get(0);
        for (int i = 1; i < this.m_cmps.size(); ++i) {
            sum = sum.plus(this.m_cmps.get(i), false);
        }
        return sum;
    }

    public double normalize() {
        ArimaModel sum = ArimaModel.create(this.getModel());
        double var = sum.getInnovationVariance();
        if (Math.abs(var - 1.0) < 1.0E-6) {
            return 1.0;
        }
        this.m_model = sum.normalize();
        ArrayList<ArimaModel> tmp = new ArrayList<ArimaModel>();
        for (int i = 0; i < this.m_cmps.size(); ++i) {
            ArimaModel cur = this.m_cmps.get(i);
            if (!cur.isNull()) {
                tmp.add(cur.scaleVariance(1.0 / var));
                continue;
            }
            tmp.add(cur);
        }
        this.m_cmps = tmp;
        return var;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Model: ").append(this.getModel()).append(System.lineSeparator());
        int j = 0;
        for (int i = 0; i < this.m_cmps.size(); ++i) {
            ArimaModel cmp = this.m_cmps.get(i);
            if (cmp.isNull()) continue;
            builder.append("component").append(++j).append(": ").append(cmp).append(System.lineSeparator());
        }
        return builder.toString();
    }
}

