/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import java.io.Serializable;

public class Queue
implements Serializable {
    private static final long serialVersionUID = -1141282001146389780L;
    protected QueueNode m_Head = null;
    protected QueueNode m_Tail = null;
    protected int m_Size = 0;

    public final synchronized void removeAllElements() {
        this.m_Size = 0;
        this.m_Head = null;
        this.m_Tail = null;
    }

    public synchronized Object push(Object item) {
        QueueNode newNode = new QueueNode(item);
        if (this.m_Head == null) {
            this.m_Head = this.m_Tail = newNode;
        } else {
            this.m_Tail = this.m_Tail.next(newNode);
        }
        ++this.m_Size;
        return item;
    }

    public synchronized Object pop() throws RuntimeException {
        if (this.m_Head == null) {
            throw new RuntimeException("Queue is empty");
        }
        Object retval = this.m_Head.contents();
        --this.m_Size;
        this.m_Head = this.m_Head.next();
        if (this.m_Head == null) {
            this.m_Tail = null;
        }
        return retval;
    }

    public synchronized Object peek() throws RuntimeException {
        if (this.m_Head == null) {
            throw new RuntimeException("Queue is empty");
        }
        return this.m_Head.contents();
    }

    public boolean empty() {
        return this.m_Head == null;
    }

    public int size() {
        return this.m_Size;
    }

    public String toString() {
        String retval = "Queue Contents " + this.m_Size + " elements\n";
        QueueNode current = this.m_Head;
        if (current == null) {
            return retval + "Empty\n";
        }
        while (current != null) {
            retval = retval + current.contents().toString() + "\n";
            current = current.next();
        }
        return retval;
    }

    protected class QueueNode
    implements Serializable {
        private static final long serialVersionUID = -5119358279412097455L;
        protected QueueNode m_Next;
        protected Object m_Contents;

        public QueueNode(Object contents) {
            this.m_Contents = contents;
            this.next(null);
        }

        public QueueNode next(QueueNode next) {
            this.m_Next = next;
            return this.m_Next;
        }

        public QueueNode next() {
            return this.m_Next;
        }

        public Object contents(Object contents) {
            this.m_Contents = contents;
            return this.m_Contents;
        }

        public Object contents() {
            return this.m_Contents;
        }
    }
}

