/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.fitness;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.base.AbstractFitness;
import net.sf.jclec.fitness.ISimpleFitness;
import net.sf.jclec.fitness.IValueFitness;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SimpleValueFitness
extends AbstractFitness
implements ISimpleFitness,
IValueFitness {
    protected static final XmlFormat<SimpleValueFitness> XML = new XmlFormat<SimpleValueFitness>(SimpleValueFitness.class){

        @Override
        public void format(SimpleValueFitness simpleValueFitness, XmlElement xml) {
            xml.setAttribute("value", simpleValueFitness.value);
        }

        @Override
        public SimpleValueFitness parse(XmlElement xml) {
            SimpleValueFitness simpleValueFitness = (SimpleValueFitness)xml.object();
            simpleValueFitness.value = xml.getAttribute("value", 0.0);
            return simpleValueFitness;
        }

        @Override
        public String defaultName() {
            return "simple-value-fitness";
        }
    };
    private static final long serialVersionUID = 3257285829314556465L;
    protected double value;

    public SimpleValueFitness() {
    }

    public SimpleValueFitness(double value) {
        this.value = value;
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double value) {
        this.value = value;
    }

    public IFitness copy() {
        return new SimpleValueFitness(this.value);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.value);
        return hcb.toHashCode();
    }

    public boolean equals(Object oth) {
        if (oth instanceof SimpleValueFitness) {
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.value, ((SimpleValueFitness)oth).value);
            return eb.isEquals();
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("value", this.value);
        return tsb.toString();
    }
}

