/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.ImbalancedClassification.Auxiliar.AUC.AccAUC;
import keel.Algorithms.ImbalancedClassification.Auxiliar.AUC.CalculateAUC;
import keel.Algorithms.ImbalancedClassification.Auxiliar.AUC.PosProb;
import keel.Algorithms.ImbalancedClassification.Auxiliar.AUC.PredPair;
import keel.Algorithms.ImbalancedClassification.Ensembles.C45.C45;
import keel.Algorithms.ImbalancedClassification.Ensembles.Ensemble;
import keel.Algorithms.ImbalancedClassification.Ensembles.Rule;
import keel.Algorithms.ImbalancedClassification.Ensembles.RuleBase;
import keel.Algorithms.ImbalancedClassification.Ensembles.myDataset;
import keel.Algorithms.ImbalancedClassification.Ensembles.parseParameters;
import org.core.Fichero;
import org.core.Files;

public class multi_C45 {
    parseParameters parameters;
    myDataset train;
    myDataset val;
    myDataset test;
    public static String outputTr;
    String outputTst;
    String ruleBaseFile;
    int instancesPerLeaf;
    int n_classifiers;
    int lambda;
    float confidence;
    boolean pruned;
    boolean[] valid;
    String trainFile;
    String cabecera;
    RuleBase[] treeRuleSet;
    myDataset actua_train_set;
    Ensemble ensemble;
    String ensembleType;
    String evMeas;
    private boolean somethingWrong = false;

    public multi_C45() {
    }

    public multi_C45(parseParameters parameters) {
        this.parameters = parameters;
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        this.trainFile = parameters.getTrainingInputFile();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.ruleBaseFile = parameters.getOutputFile(0);
        this.pruned = parameters.getParameter(1).equalsIgnoreCase("TRUE");
        this.confidence = Float.parseFloat(parameters.getParameter(2));
        this.instancesPerLeaf = Integer.parseInt(parameters.getParameter(3));
        this.n_classifiers = Integer.parseInt(parameters.getParameter(4));
        this.ensembleType = parameters.getParameter(5);
        this.lambda = this.ensembleType.equalsIgnoreCase("ADABOOST.NC") ? Integer.parseInt(parameters.getParameter(7)) : 1;
        this.cabecera = parameters.getTrainingInputFile();
        String[] aux = null;
        aux = this.cabecera.split("\\.");
        this.cabecera = aux[aux.length - 2];
        aux = this.cabecera.split("/");
        this.cabecera = aux[aux.length - 1];
        this.ensemble = new Ensemble(this.ensembleType, this.train, this.n_classifiers, this.lambda, this);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set has missing values.");
            System.err.println("Aborting the program");
        } else {
            this.n_classifiers = this.ensemble.nClassifier;
            this.valid = new boolean[this.n_classifiers];
            this.treeRuleSet = new RuleBase[this.n_classifiers];
            boolean fin = false;
            for (int i = 0; i < this.n_classifiers && !fin; ++i) {
                this.actua_train_set = this.ensemble.getDS();
                if (this.actua_train_set.getnData() > 53000) {
                    System.out.println("Databoost overflow!, nData = " + this.actua_train_set.getnData());
                    fin = true;
                    break;
                }
                boolean mal = false;
                if (!this.actua_train_set.vacio()) {
                    Fichero.escribeFichero(this.ensembleType + this.cabecera + ".txt", this.actua_train_set.printDataSet());
                    this.valid[i] = true;
                    System.out.println("Training classifier[" + i + "]");
                    C45 tree = new C45(this.ensembleType + this.cabecera + ".txt", this.pruned, this.confidence, this.instancesPerLeaf, (double[])this.ensemble.getWeights().clone());
                    try {
                        tree.generateTree();
                    }
                    catch (Exception e) {
                        System.err.println("Error!!");
                        System.err.println(e.getMessage());
                        System.exit(-1);
                    }
                    String cadenaTree = tree.printString();
                    this.obtainRules(cadenaTree, i);
                    if (this.treeRuleSet[i].size() == 0) {
                        mal = true;
                        int clase = tree.getPriorProbabilities()[0] > tree.getPriorProbabilities()[1] ? 0 : 1;
                        this.treeRuleSet[i].ruleBase.add(new Rule(this.train.getOutputValue(clase), this.actua_train_set));
                    }
                    this.treeRuleSet[i].coverExamples();
                    this.treeRuleSet[i].coverExamples((double[])this.ensemble.getWeights().clone());
                } else {
                    this.valid[i] = false;
                }
                if (mal) {
                    if (!this.ensembleType.contains("EUNDERBAGGING") && this.ensemble.weightsBackup != null) {
                        this.ensemble.weights = (double[])this.ensemble.weightsBackup.clone();
                    } else {
                        fin = this.ensemble.nextIteration();
                    }
                } else {
                    fin = this.ensemble.nextIteration();
                }
                if (!this.ensembleType.equalsIgnoreCase("EASYENSEMBLE") && !this.ensembleType.equalsIgnoreCase("BALANCECASCADE")) continue;
                i = this.ensemble.t - 1;
            }
            AccAUC pairTra = this.doOutput(this.val, outputTr);
            AccAUC pairTst = this.doOutput(this.test, this.outputTst);
            this.writeOutput(pairTra, pairTst, this.ruleBaseFile);
            this.ensemble.writeAUCError(this.outputTst);
        }
    }

    private AccAUC doOutput(myDataset dataset, String filename) {
        double TP = 0.0;
        double FP = 0.0;
        double FN = 0.0;
        double TN = 0.0;
        String outputTotal = dataset.copyHeader();
        String claseReal = "";
        String prediccion = "";
        String output2 = "";
        StringBuilder sb = new StringBuilder(dataset.getnData() * 5);
        int aciertos = 0;
        boolean takeOpposite = this.ensemble.originalDS.getOutputValue(0).equals(this.train.claseMasFrecuente());
        PosProb[] valsForAUC = new PosProb[dataset.getnData()];
        for (int i = 0; i < dataset.getnData(); ++i) {
            claseReal = dataset.getOutputAsString(i);
            PredPair predAndVoteValue = this.classificationOutput(dataset.getExample(i));
            prediccion = predAndVoteValue.getPrediction();
            output2 = claseReal.concat(" ").concat(prediccion).concat("\n");
            if (claseReal.equalsIgnoreCase(prediccion)) {
                ++aciertos;
            }
            if (claseReal.equalsIgnoreCase(prediccion) && claseReal.equalsIgnoreCase(this.train.claseMasFrecuente())) {
                TN += 1.0;
            } else if (claseReal.equalsIgnoreCase(prediccion) && !claseReal.equalsIgnoreCase(this.train.claseMasFrecuente())) {
                TP += 1.0;
            } else if (!claseReal.equalsIgnoreCase(prediccion) && claseReal.equalsIgnoreCase(this.train.claseMasFrecuente())) {
                FP += 1.0;
            } else {
                FN += 1.0;
            }
            double voted = predAndVoteValue.getVotingValue();
            boolean isPositive = !claseReal.equals(this.train.claseMasFrecuente());
            double prob = voted;
            if (takeOpposite) {
                prob *= -1.0;
            }
            valsForAUC[i] = new PosProb(isPositive, prob);
            sb.append(output2);
        }
        outputTotal = outputTotal + sb.toString();
        double TPrate = TP / (TP + FN);
        double TNrate = TN / (TN + FP);
        double gmean = Math.sqrt(TPrate * TNrate);
        double precision = TP / (TP + FP);
        double recall = TP / (TP + FN);
        double fmean = 2.0 * recall * precision / (1.0 * recall + precision);
        System.out.println("G-mean: " + gmean);
        System.out.println("F-mean: " + fmean);
        System.out.println("TPrate: " + TPrate);
        System.out.println("TNrate: " + TNrate);
        double FPrate = FP / (FP + TN);
        System.out.println("AUC: " + (1.0 + TPrate - FPrate) / 2.0);
        Files.writeFile(filename, outputTotal);
        double acc = 1.0 * (double)aciertos / (double)dataset.size();
        double auc = this.getAUC(valsForAUC);
        return new AccAUC(acc, auc);
    }

    public double classify(myDataset dataset) {
        int aciertos = 0;
        for (int i = 0; i < dataset.getnData(); ++i) {
            PredPair predAndVoteValue;
            String prediccion;
            String claseReal = dataset.getOutputAsString(i);
            if (!claseReal.equalsIgnoreCase(prediccion = (predAndVoteValue = this.classificationOutput(dataset.getExample(i))).getPrediction())) continue;
            ++aciertos;
        }
        return 1.0 * (double)aciertos / (double)dataset.size();
    }

    private PredPair classificationOutput(double[] example) {
        return this.ensemble.computeClassScores(example);
    }

    protected int obtainClass(int i, double[] example) {
        if (this.valid[i]) {
            String clase = "?";
            for (int j = 0; j < this.treeRuleSet[i].size() && clase.equals("?"); ++j) {
                if (!this.treeRuleSet[i].ruleBase.get(j).covers(example)) continue;
                clase = this.treeRuleSet[i].ruleBase.get((int)j).clase;
            }
            int clase_num = this.train.claseNumerica(clase);
            if (clase_num == -1) {
                clase_num = this.train.claseNumerica(this.train.claseMasFrecuente());
            }
            return clase_num;
        }
        System.err.println("This should not be accessed: " + i + "/" + this.valid[i]);
        return -1;
    }

    protected double obtainConfidence(int i, double[] example) {
        double confianza = 0.0;
        if (this.valid[i]) {
            String clase = "?";
            for (int j = 0; j < this.treeRuleSet[i].size() && clase.equals("?"); ++j) {
                if (!this.treeRuleSet[i].ruleBase.get(j).covers(example)) continue;
                clase = this.treeRuleSet[i].ruleBase.get((int)j).clase;
                double nCubiertosOK = this.treeRuleSet[i].ruleBase.get((int)j).fCubiertosOK;
                double nCubiertos = this.treeRuleSet[i].ruleBase.get((int)j).fCubiertos;
                confianza = nCubiertos == 0.0 ? 0.0 : ((double)this.ensemble.nData * nCubiertosOK + 1.0) / ((double)this.ensemble.nData * nCubiertos + 2.0);
            }
            int clase_num = this.train.claseNumerica(clase);
            if (clase_num == -1) {
                confianza = 0.5;
            }
            return confianza;
        }
        return 0.5;
    }

    private void obtainRules(String treeString, int classifier) {
        String rules = new String("");
        StringTokenizer lines = new StringTokenizer(treeString, "\n");
        String line = lines.nextToken();
        line = lines.nextToken();
        Vector<String> variables = new Vector<String>();
        Vector<String> values = new Vector<String>();
        Vector<String> operators = new Vector<String>();
        int contador = 0;
        while (lines.hasMoreTokens()) {
            int i;
            line = lines.nextToken();
            StringTokenizer field = new StringTokenizer(line, " \t");
            String cosa = field.nextToken();
            if (cosa.compareToIgnoreCase("if") == 0) {
                field.nextToken();
                variables.add(field.nextToken());
                operators.add(field.nextToken());
                values.add(field.nextToken());
                continue;
            }
            if (cosa.compareToIgnoreCase("elseif") == 0) {
                int dejar = Integer.parseInt(field.nextToken());
                for (int i2 = variables.size() - 1; i2 >= dejar; --i2) {
                    variables.remove(variables.size() - 1);
                    operators.remove(operators.size() - 1);
                    values.remove(values.size() - 1);
                }
                field.nextToken();
                variables.add(field.nextToken());
                operators.add(field.nextToken());
                values.add(field.nextToken());
                continue;
            }
            field.nextToken();
            rules = rules + "\nRULE-" + ++contador + ": IF ";
            for (i = 0; i < variables.size() - 1; ++i) {
                rules = rules + (String)variables.get(i) + " " + (String)operators.get(i) + " " + (String)values.get(i) + " AND ";
            }
            rules = rules + (String)variables.get(i) + " " + (String)operators.get(i) + " " + (String)values.get(i);
            rules = rules + " THEN class = " + field.nextToken();
            variables.remove(variables.size() - 1);
            operators.remove(operators.size() - 1);
            values.remove(values.size() - 1);
        }
        this.treeRuleSet[classifier] = new RuleBase(this.actua_train_set, rules);
    }

    public void writeOutput(AccAUC pairTra, AccAUC pairTst, String ruleBaseFile) {
        Files.writeFile(ruleBaseFile, "");
        for (int i = 0; i < this.ensemble.nClassifier; ++i) {
            if (!this.valid[i]) continue;
            Files.addToFile(ruleBaseFile, "@Classifier number " + i + ": \n");
            Files.addToFile(ruleBaseFile, this.treeRuleSet[i].printStringF() + "\n");
        }
        Files.addToFile(ruleBaseFile, "Accuracy in training: " + pairTra.getAcc() + "\n");
        Files.addToFile(ruleBaseFile, "Accuracy in test: " + pairTst.getAcc() + "\n");
        Files.addToFile(ruleBaseFile, "AUC in training: " + pairTra.getAUC() + "\n");
        Files.addToFile(ruleBaseFile, "AUC in test: " + pairTst.getAUC() + "\n");
        System.out.println("Accuracy in training: " + pairTra.getAcc());
        System.out.println("Accuracy in test: " + pairTst.getAcc());
        System.out.println("AUC in training: " + pairTra.getAUC());
        System.out.println("AUC in test: " + pairTst.getAUC());
        System.out.println("Algorithm Finished");
    }

    private double getAUC(PosProb[] valsForAUC) {
        return CalculateAUC.calculate(valsForAUC);
    }
}

