/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.ANR;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;

public class ProcessConfig {
    public static final int IndexTrain = 0;
    public static final int IndexTestKMeans = 1;
    public static final int IndexTest = 2;
    private boolean commandLineParameters = false;
    private boolean createResultFile = false;
    public static boolean parNewFormat = true;
    public static int parAlgorithmType = 0;
    public static Vector parInputData;
    public static Vector parOutputData;
    public static Vector outputData;
    public static String parResultTrainName;
    public static String parResultName;
    public static String parResultLabel;
    public static int parPartitionLabelNum;
    public static int parPopSize;
    public static int parIslandNumber;
    public static boolean parSteady;
    public static int parIterNumber;
    public static int parTourSize;
    public static double parMutProb;
    public static double parMutAmpl;
    public static double parMigProb;
    public static double parLoProb;
    public static int parLoIterNumber;
    public static int parLoId;
    public static int parMaxHeigth;
    public static boolean parNiche;
    public static int parMaxNiche;
    public static double parIntraNicheProb;
    public static double parDeltaFit;
    public static double parP0;
    public static double parP1;
    public static int parNSUB;
    public static double parCrGAProb;
    public static double parMuGAProb;
    public static int parRuleNumber;
    public static int parCrossId1;
    public static int parMutaId1;
    public static int parCrossId2;
    public static int parMutaId2;
    public static int parCrossId3;
    public static int parMutaId3;
    public static int parFitnessType;
    public static int[] parNetTopo;
    public static double parKernel;
    public static int parNMeans;
    public static int parGALen;
    public static double parSigma;
    public static double parSignificanceLevel;
    public static long parSeed;
    public static int parNClusters;
    public static double fuzzyTolerance;
    public static String tableType1;
    public static String tableType2;
    public static String tableType3;
    public static int numberLine;
    public static int numberLine1;
    public static int numberLine2;
    public static int numberLine3;
    public static String dataTable1;
    public static String dataTable2;
    public static String dataTable3;
    public static String dataMatrix;
    public static String matrixConfussion;
    public static int curDataset;
    public static String nameFile;
    public static boolean Iman;
    public static boolean Nem;
    public static boolean Bon;
    public static boolean Holm;
    public static boolean Hoch;
    public static boolean Hommel;
    private int nl;
    String lastRel = new String();

    public ProcessConfig() {
        parInputData = new Vector();
        parInputData.add("noasignado");
        parInputData.add("noasignado");
        parOutputData = new Vector();
        outputData = new Vector();
    }

    public int fileProcess(String nfconfig) {
        try {
            String linea;
            File f1 = new File(nfconfig);
            System.out.println(f1.getAbsolutePath());
            System.out.println(f1.getParent());
            String aux = new String();
            StringTokenizer tokens_name = new StringTokenizer(nfconfig, "/");
            while (tokens_name.hasMoreTokens()) {
                aux = tokens_name.nextToken();
                System.out.println("Aux : " + aux);
            }
            curDataset = Integer.parseInt(aux.substring(aux.indexOf("g") + 1, aux.indexOf("s"))) + 1;
            this.nl = 0;
            BufferedReader in = new BufferedReader(new FileReader(nfconfig));
            while ((linea = in.readLine()) != null) {
                StringTokenizer tokens;
                ++this.nl;
                String lineCopy = linea.trim();
                if (lineCopy.length() == 0 || lineCopy.charAt(0) == '#' || !(tokens = new StringTokenizer(linea, " ,\t")).hasMoreTokens()) continue;
                String tmp = tokens.nextToken();
                String equal = tokens.nextToken();
                if (tmp.equalsIgnoreCase("algorithm")) {
                    this.doAlgorithmDesc(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("subAlgorithm")) {
                    this.doAlgorithmType(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("dataformat")) {
                    this.doDataFormat(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("InputData")) {
                    this.doInputData(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("OutputData")) {
                    this.doOutputData(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("OutLabel")) {
                    this.doResLabel(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("OutputDataTabular")) {
                    this.doOutputDataTabular(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NumLabels")) {
                    this.doLabelNum(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("PopSize")) {
                    this.doPopSize(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NumIsland")) {
                    this.doNumIslands(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Steady")) {
                    this.doSteady(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NumItera")) {
                    this.doNumItera(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("TourSize")) {
                    this.doTourSize(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("ProbMuta")) {
                    this.doMutaProb(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("AmplMuta")) {
                    this.doMutaAmpl(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("ProbMigra")) {
                    this.doMigraProb(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("ProbOptimLocal")) {
                    this.doLocalOptimProb(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NumOptimLocal")) {
                    this.doLocalOptimNum(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("IdOptimLocal")) {
                    this.doLocalOptimId(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NichingGAP")) {
                    this.doNiche(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("MaxIndNiche")) {
                    this.doMaxIndNiche(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("probIntraNiche")) {
                    this.doIntraNicheProb(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("deltaFitSAP")) {
                    this.dodeltaFitSAP(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("P0SAP")) {
                    this.doP0SAP(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("P1SAP")) {
                    this.doP1SAP(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NSUBSAP")) {
                    this.doNSUBSAP(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("ProbCrossGA")) {
                    this.doCrossProbGA(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("ProbMutaGA")) {
                    this.doMutaProbGA(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NumRules")) {
                    this.doRuleNumberBoost(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("TopologyMLP")) {
                    this.doTopoMLP(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("sigmaKernel")) {
                    this.dosigmaKernel(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("NumNeigb")) {
                    this.doNumNeigb(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("LenChainGAP")) {
                    this.doLenChainGAP(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("SigmaFSS98")) {
                    this.doSigmaFSS98(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("SignLevel")) {
                    this.doSignificanceLevel(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("MaxTreeHeight")) {
                    this.doSignificanceLevel(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Seed")) {
                    this.doSeed(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("nInput")) {
                    this.doNInput(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("nClusters")) {
                    this.doNClusters(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("1-Classification")) {
                    this.doTableType1(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("1-RMS")) {
                    this.doTableType1(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("2-Classification")) {
                    this.doTableType2(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("3-Global")) {
                    this.doTableType3(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("numberLine")) {
                    this.doNumberLine(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("1-Header")) {
                    this.doNumberLine1(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("2-Header")) {
                    this.doNumberLine2(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("3-Header")) {
                    this.doNumberLine3(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("4-Confussion")) {
                    this.doMatrixConfussion(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("1-Data")) {
                    this.doDataTable1(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("2-Global")) {
                    this.doTableType2(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("2-Data")) {
                    this.doDataTable2(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("3-Data")) {
                    this.doDataTable3(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("4-Data")) {
                    this.doDataMatrix(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Apply-Iman-Davenport")) {
                    this.doImanDavenport(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Apply-Nemenyi")) {
                    this.doNemenyi(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Apply-Bonferroni-Dunn")) {
                    this.doBonferroni(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Apply-Holm")) {
                    this.doHolm(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Apply-Hochberg")) {
                    this.doHoch(tokens);
                    continue;
                }
                if (tmp.equalsIgnoreCase("Apply-Hommel")) {
                    this.doHommel(tokens);
                    continue;
                }
                throw new SyntaxError("Parametro desconocido " + tmp);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Fichero de configuracion no encontrado");
            return -1;
        }
        catch (IOException e) {
            System.err.println(e + " Error lectura");
            return -2;
        }
        catch (SyntaxError e) {
            System.err.println("Error de sintaxis en linea " + this.nl + " : " + e);
            return -3;
        }
        catch (Exception e) {
            System.err.println("Error en fichero de configuracion");
            e.printStackTrace();
            return -4;
        }
        return 0;
    }

    void doAlgorithmDesc(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Descripcion de algoritmo no especificada");
        }
        String tmp = tokens.nextToken();
        System.out.println("Descripcion algoritmo = " + tmp);
    }

    void doAlgorithmType(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("TipoAlgoritmo no especificado");
        }
        String tmp = tokens.nextToken();
        if (tmp.equalsIgnoreCase("ClasifFuzzyWangMendel")) {
            parAlgorithmType = 1;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzyPitts")) {
            parAlgorithmType = 2;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzyGP")) {
            parAlgorithmType = 3;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzyGAP")) {
            parAlgorithmType = 4;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzySAP")) {
            parAlgorithmType = 5;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzyAdaBoost")) {
            parAlgorithmType = 6;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzyLogitBoost")) {
            parAlgorithmType = 7;
        } else if (tmp.equalsIgnoreCase("ClasifFuzzyMaxLogitBoost")) {
            parAlgorithmType = 8;
        } else if (tmp.equalsIgnoreCase("ClasifMLPerceptron")) {
            parAlgorithmType = 27;
        } else if (tmp.equalsIgnoreCase("ClasifLinearLMS")) {
            parAlgorithmType = 25;
        } else if (tmp.equalsIgnoreCase("ClasifPolQuadraticLMS")) {
            parAlgorithmType = 26;
        } else if (tmp.equalsIgnoreCase("ClasifADLinear")) {
            parAlgorithmType = 23;
        } else if (tmp.equalsIgnoreCase("ClasifADQuadratic")) {
            parAlgorithmType = 24;
        } else if (tmp.equalsIgnoreCase("ClasifKernel")) {
            parAlgorithmType = 28;
        } else if (tmp.equalsIgnoreCase("ClasifKNN")) {
            parAlgorithmType = 29;
        } else if (tmp.equalsIgnoreCase("ModelFuzzyWangMendel")) {
            parAlgorithmType = 9;
        } else if (tmp.equalsIgnoreCase("ModelFuzzyPitts")) {
            parAlgorithmType = 10;
        } else if (tmp.equalsIgnoreCase("ModelFuzzyGP")) {
            parAlgorithmType = 11;
        } else if (tmp.equalsIgnoreCase("ModelFuzzyGAP")) {
            parAlgorithmType = 12;
        } else if (tmp.equalsIgnoreCase("ModelFuzzySAP")) {
            parAlgorithmType = 13;
        } else if (tmp.equalsIgnoreCase("ModelGAPRegSym")) {
            parAlgorithmType = 14;
        } else if (tmp.equalsIgnoreCase("ModelIntervalGAPRegSym")) {
            parAlgorithmType = 15;
        } else if (tmp.equalsIgnoreCase("ModelFuzzyGAPRegSym")) {
            parAlgorithmType = 16;
        } else if (tmp.equalsIgnoreCase("ModelSAPRegSym")) {
            parAlgorithmType = 17;
        } else if (tmp.equalsIgnoreCase("ModelIntervalSAPRegSym")) {
            parAlgorithmType = 18;
        } else if (tmp.equalsIgnoreCase("ModelFuzzySAPRegSym")) {
            parAlgorithmType = 19;
        } else if (tmp.equalsIgnoreCase("ModelMLPerceptron")) {
            parAlgorithmType = 22;
        } else if (tmp.equalsIgnoreCase("ModelLinearLMS")) {
            parAlgorithmType = 20;
        } else if (tmp.equalsIgnoreCase("ModelPolQuadraticLMS")) {
            parAlgorithmType = 21;
        } else if (tmp.equalsIgnoreCase("ModelFSS98")) {
            parAlgorithmType = 30;
        } else if (tmp.equalsIgnoreCase("StatTestClas5x2cv")) {
            parAlgorithmType = 31;
        } else if (tmp.equalsIgnoreCase("StatTestMod5x2cv")) {
            parAlgorithmType = 32;
        } else if (tmp.equalsIgnoreCase("StatTestClast")) {
            parAlgorithmType = 33;
        } else if (tmp.equalsIgnoreCase("StatTestModt")) {
            parAlgorithmType = 34;
        } else if (tmp.equalsIgnoreCase("StatTestClasSW")) {
            parAlgorithmType = 35;
        } else if (tmp.equalsIgnoreCase("StatTestModSW")) {
            parAlgorithmType = 36;
        } else if (tmp.equalsIgnoreCase("StatTestClasRS")) {
            parAlgorithmType = 37;
        } else if (tmp.equalsIgnoreCase("StatTestModRS")) {
            parAlgorithmType = 38;
        } else if (tmp.equalsIgnoreCase("StatTestClasU")) {
            parAlgorithmType = 39;
        } else if (tmp.equalsIgnoreCase("StatTestModU")) {
            parAlgorithmType = 40;
        } else if (tmp.equalsIgnoreCase("StatTestClasF")) {
            parAlgorithmType = 41;
        } else if (tmp.equalsIgnoreCase("StatTestModF")) {
            parAlgorithmType = 42;
        } else if (tmp.equalsIgnoreCase("StatCheckCL")) {
            parAlgorithmType = 43;
        } else if (tmp.equalsIgnoreCase("StatCheckMO")) {
            parAlgorithmType = 44;
        } else if (tmp.equalsIgnoreCase("StatGeneralCL")) {
            parAlgorithmType = 45;
        } else if (tmp.equalsIgnoreCase("StatGeneralMO")) {
            parAlgorithmType = 46;
        } else if (tmp.equalsIgnoreCase("ClusterKMeans")) {
            parAlgorithmType = 47;
        } else if (tmp.equalsIgnoreCase("StatTabularCL")) {
            parAlgorithmType = 48;
        } else if (tmp.equalsIgnoreCase("StatTabularMO")) {
            parAlgorithmType = 49;
        } else if (tmp.equalsIgnoreCase("Wilcoxon")) {
            parAlgorithmType = 50;
        } else if (tmp.equalsIgnoreCase("Friedman")) {
            parAlgorithmType = 51;
        } else {
            throw new SyntaxError("TipoAlgoritmo " + tmp + " no reconocido");
        }
        System.out.println("Ejecutando algoritmo " + tmp);
    }

    void doDataFormat(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Formato no especificado");
        }
        String tmp = tokens.nextToken();
        parNewFormat = tmp.equalsIgnoreCase("keel");
    }

    void doInputData(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("inputdata no especificado");
        }
        String linea = new String();
        while (tokens.hasMoreTokens()) {
            linea = linea + tokens.nextToken();
        }
        System.out.println("Procesando inputdata[" + linea + "]");
        parInputData = new Vector();
        StringTokenizer tk = new StringTokenizer(linea, "\"");
        while (tk.hasMoreTokens()) {
            String tmp = tk.nextToken();
            if ((tmp = tmp.trim()).length() <= 0) continue;
            parInputData.add(tmp);
        }
    }

    void doOutputData(StringTokenizer tokens) throws SyntaxError {
        String tmp;
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("OutputData no especificado");
        }
        String linea = new String();
        while (tokens.hasMoreTokens()) {
            linea = linea + tokens.nextToken();
        }
        System.out.println("Procesando argumento[" + linea + "]");
        StringTokenizer tk = new StringTokenizer(linea, "\"");
        while (tk.hasMoreTokens()) {
            tmp = tk.nextToken();
            if ((tmp = tmp.trim()).length() <= 0) continue;
            System.out.println("Nombre resultados train [" + tmp + "]");
            parResultTrainName = tmp;
            tmp = new String("");
            if (tk.hasMoreTokens()) {
                tmp = tk.nextToken();
                tmp = tmp.trim();
            }
            if (tmp.length() == 0) {
                tmp = new String("result.log");
            }
            System.out.println("Nombre resultados test [" + tmp + "]");
            parResultName = tmp;
            break;
        }
        this.createResultFile = true;
        while (tk.hasMoreTokens()) {
            tmp = tk.nextToken();
            if ((tmp = tmp.trim()).length() <= 0) continue;
            outputData.add(tmp);
        }
    }

    void doOutputDataTabular(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("inputdata no especificado");
        }
        String linea = new String();
        while (tokens.hasMoreTokens()) {
            linea = linea + tokens.nextToken();
        }
        System.out.println("Procesando outputdata[" + linea + "]");
        parOutputData = new Vector();
        StringTokenizer tk = new StringTokenizer(linea, "\"");
        while (tk.hasMoreTokens()) {
            String tmp = tk.nextToken();
            if ((tmp = tmp.trim()).length() <= 0) continue;
            System.out.println("Procesando outputdata[" + tmp + "]");
            parOutputData.add(tmp);
        }
        this.createResultFile = true;
    }

    void doAppNombreResult(StringTokenizer tokens) throws SyntaxError {
        String tmp;
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("result no especificado");
        }
        parResultName = tmp = tokens.nextToken();
        this.createResultFile = false;
    }

    void doResLabel(StringTokenizer tokens) throws SyntaxError {
        String tmp;
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("etiqueta no especificado");
        }
        parResultLabel = tmp = tokens.nextToken();
    }

    void doLabelNum(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero de etiquetas no especificado");
        }
        String tmp = tokens.nextToken();
        parPartitionLabelNum = Integer.parseInt(tmp);
    }

    void doPopSize(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Tamano Poblacion no especificado");
        }
        String tmp = tokens.nextToken();
        parPopSize = Integer.parseInt(tmp);
    }

    void doNumIslands(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero de islas no especificado");
        }
        String tmp = tokens.nextToken();
        parIslandNumber = Integer.parseInt(tmp);
    }

    void doSteady(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Steady no especificado");
        }
        String tmp = tokens.nextToken();
        parSteady = Integer.parseInt(tmp) != 0;
    }

    void doNumItera(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero de iteraciones no especificado");
        }
        String tmp = tokens.nextToken();
        parIterNumber = Integer.parseInt(tmp);
    }

    void doTourSize(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Torneo no especificado");
        }
        String tmp = tokens.nextToken();
        parTourSize = Integer.parseInt(tmp);
    }

    void doMutaProb(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Probabilidad de mutacion no especificado");
        }
        String tmp = tokens.nextToken();
        parMutProb = Double.parseDouble(tmp);
    }

    void doMutaAmpl(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Amplitud de mutacion no especificado");
        }
        String tmp = tokens.nextToken();
        parMutAmpl = Double.parseDouble(tmp);
    }

    void doMigraProb(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Probabilidad de migracion no especificado");
        }
        String tmp = tokens.nextToken();
        parMigProb = Double.parseDouble(tmp);
    }

    void doLocalOptimProb(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Prob. de optim local no especificado");
        }
        String tmp = tokens.nextToken();
        parLoProb = Double.parseDouble(tmp);
    }

    void doLocalOptimNum(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Iteraciones optim. local no especificado");
        }
        String tmp = tokens.nextToken();
        parLoIterNumber = Integer.parseInt(tmp);
    }

    void doLocalOptimId(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Tipo de optim local no especificado");
        }
        String tmp = tokens.nextToken();
        parLoId = Integer.parseInt(tmp);
    }

    void doNiche(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero de nichos no especificado");
        }
        String tmp = tokens.nextToken();
        int inichos = Integer.parseInt(tmp);
        parNiche = inichos == 1;
    }

    void doMaxIndNiche(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Maximo de individuos en nicho no especificado");
        }
        String tmp = tokens.nextToken();
        parMaxNiche = Integer.parseInt(tmp);
    }

    void doIntraNicheProb(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Prob. de cruce intranicho no especificado");
        }
        String tmp = tokens.nextToken();
        parIntraNicheProb = Double.parseDouble(tmp);
    }

    void dodeltaFitSAP(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("delta fitness SAP no especificado");
        }
        String tmp = tokens.nextToken();
        parDeltaFit = Double.parseDouble(tmp);
    }

    void doP0SAP(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("P0 SAP no especificado");
        }
        String tmp = tokens.nextToken();
        parP0 = Double.parseDouble(tmp);
    }

    void doP1SAP(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("P1 SAP no especificado");
        }
        String tmp = tokens.nextToken();
        parP1 = Double.parseDouble(tmp);
    }

    void doNSUBSAP(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Iteraciones por T. SAP no especificado");
        }
        String tmp = tokens.nextToken();
        parNSUB = Integer.parseInt(tmp);
    }

    void doCrossProbGA(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Prob. Cruce GA no especificado");
        }
        String tmp = tokens.nextToken();
        parCrGAProb = Double.parseDouble(tmp);
    }

    void doMutaProbGA(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Prob. Muta GA no especificado");
        }
        String tmp = tokens.nextToken();
        parMuGAProb = Double.parseDouble(tmp);
    }

    void doRuleNumberBoost(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero reglas boosting no especificado");
        }
        String tmp = tokens.nextToken();
        parRuleNumber = Integer.parseInt(tmp);
    }

    void doAlturaMax(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Altura maxima arbol no especificado");
        }
        String tmp = tokens.nextToken();
        parMaxHeigth = Integer.parseInt(tmp);
    }

    void doTopoMLP(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Topologia red neuronal no especificado");
        }
        Vector<Integer> vtmp = new Vector<Integer>();
        while (tokens.hasMoreTokens()) {
            String tmp = tokens.nextToken();
            int itmp = Integer.parseInt(tmp);
            vtmp.addElement(new Integer(itmp));
        }
        parNetTopo = new int[vtmp.size()];
        for (int i = 0; i < parNetTopo.length; ++i) {
            Integer Itmp = (Integer)vtmp.elementAt(i);
            ProcessConfig.parNetTopo[i] = Itmp;
        }
    }

    void dosigmaKernel(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Sigma kernel no especificado");
        }
        String tmp = tokens.nextToken();
        parKernel = Double.parseDouble(tmp);
    }

    void doNumNeigb(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero de vecinos no especificado");
        }
        String tmp = tokens.nextToken();
        parNMeans = Integer.parseInt(tmp);
    }

    void doLenChainGAP(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Longitud cadena GAP no especificado");
        }
        String tmp = tokens.nextToken();
        parGALen = Integer.parseInt(tmp);
    }

    void doSigmaFSS98(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Sigma FSS98 no especificado");
        }
        String tmp = tokens.nextToken();
        parSigma = Double.parseDouble(tmp);
    }

    void doSignificanceLevel(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Nivel de significacion no especificado");
        }
        String tmp = tokens.nextToken();
        parSignificanceLevel = Double.parseDouble(tmp);
    }

    void doSeed(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Semilla no especificada");
        }
        String tmp = tokens.nextToken();
        parSeed = Long.parseLong(tmp);
    }

    void doNInput(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("nInput no especificado");
        }
        String tmp = tokens.nextToken();
    }

    void doNClusters(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Numero de clusters no especificado");
        }
        String tmp = tokens.nextToken();
        parNClusters = Integer.parseInt(tmp);
    }

    void doTableType1(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 1 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tableType1 = tmp = tokens.nextToken();
    }

    void doTableType2(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 2 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tableType2 = tmp = tokens.nextToken();
    }

    void doTableType3(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 3 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tableType3 = tmp = tokens.nextToken();
    }

    void doNumberLine(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n del n\u00famero de l\u00edneas no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tmp = tokens.nextToken();
        numberLine = Integer.parseInt(tmp);
    }

    void doNumberLine1(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n del n\u00famero de l\u00edneas no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tmp = tokens.nextToken();
        numberLine1 = Integer.parseInt(tmp);
    }

    void doNumberLine2(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n del n\u00famero de l\u00edneas no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tmp = tokens.nextToken();
        numberLine2 = Integer.parseInt(tmp);
    }

    void doNumberLine3(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n del n\u00famero de l\u00edneas no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        tmp = tokens.nextToken();
        numberLine3 = Integer.parseInt(tmp);
    }

    void doMatrixConfussion(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 2 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        matrixConfussion = tmp = tokens.nextToken();
    }

    void doDataTable1(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 3 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        dataTable1 = tmp = tokens.nextToken();
    }

    void doDataTable2(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 3 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        dataTable2 = tmp = tokens.nextToken();
    }

    void doDataTable3(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 3 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        dataTable3 = tmp = tokens.nextToken();
    }

    void doDataMatrix(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("Elecci\u00f3n de la tabla 3 no especificada");
        }
        String tmp = tokens.nextToken();
        while (!tmp.equals("=")) {
            tmp = tokens.nextToken();
        }
        dataMatrix = tmp = tokens.nextToken();
    }

    void doImanDavenport(StringTokenizer tokens) throws SyntaxError {
        parSignificanceLevel = 0.0;
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("No value selected for 'Apply Iman-Davenport Derivation'");
        }
        String tmp = tokens.nextToken();
        Iman = false;
        if (tmp.equalsIgnoreCase("YES")) {
            Iman = true;
            parSignificanceLevel = 1.0;
        }
    }

    void doNemenyi(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("No value selected for 'Apply Iman-Davenport Derivation'");
        }
        String tmp = tokens.nextToken();
        Nem = false;
        if (tmp.equalsIgnoreCase("YES")) {
            Nem = true;
            parSignificanceLevel += 2.0;
        }
    }

    void doBonferroni(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("No value selected for 'Apply Iman-Davenport Derivation'");
        }
        String tmp = tokens.nextToken();
        Bon = false;
        if (tmp.equalsIgnoreCase("YES")) {
            Bon = true;
            parSignificanceLevel += 4.0;
        }
    }

    void doHolm(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("No value selected for 'Apply Iman-Davenport Derivation'");
        }
        String tmp = tokens.nextToken();
        Holm = false;
        if (tmp.equalsIgnoreCase("YES")) {
            Holm = true;
            parSignificanceLevel += 8.0;
        }
    }

    void doHoch(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("No value selected for 'Apply Iman-Davenport Derivation'");
        }
        String tmp = tokens.nextToken();
        Hoch = false;
        if (tmp.equalsIgnoreCase("YES")) {
            Hoch = true;
            parSignificanceLevel += 16.0;
        }
    }

    void doHommel(StringTokenizer tokens) throws SyntaxError {
        if (!tokens.hasMoreTokens()) {
            throw new SyntaxError("No value selected for 'Apply Iman-Davenport Derivation'");
        }
        String tmp = tokens.nextToken();
        Hommel = false;
        if (tmp.equalsIgnoreCase("YES")) {
            Hommel = true;
            parSignificanceLevel += 32.0;
        }
    }

    private void createResults(double[] expected, double[] obtained) {
        try {
            FileOutputStream out = new FileOutputStream(parResultName);
            PrintStream p = new PrintStream(out);
            this.copyTestHeader(p);
            for (int i = 0; i < expected.length; ++i) {
                p.print(expected[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error creando fichero de resultados " + parResultName);
        }
    }

    private void createResults(int[] expected, int[] obtained) {
        Attribute at = Attributes.getOutputAttribute(0);
        boolean isNominal = at.getType() == 0;
        try {
            FileOutputStream out = new FileOutputStream(parResultName);
            PrintStream p = new PrintStream(out);
            this.copyTestHeader(p);
            for (int i = 0; i < expected.length; ++i) {
                if (isNominal) {
                    String expectedLabel = expected[i] == -1 ? new String("unclassified") : at.getNominalValue(expected[i]);
                    String obtainedLabel = obtained[i] == -1 ? new String("unclassified") : at.getNominalValue(obtained[i]);
                    p.print(expectedLabel + " " + obtainedLabel + "\n");
                    continue;
                }
                p.print(expected[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error creando fichero de resultados " + parResultName);
        }
    }

    private void createResults(double[][] pattern, int[] pclass) {
        try {
            FileOutputStream out = new FileOutputStream(parResultName);
            PrintStream p = new PrintStream(out);
            this.copyClusterHeader(p);
            p.println("@attribute cluster integer");
            p.println("@data");
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length; ++j) {
                    p.print(pattern[i][j] + ",");
                }
                p.print(pclass[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error creando fichero de resultados " + parResultName);
        }
    }

    private void createTrainingResults(double[] expected, double[] obtained) {
        try {
            FileOutputStream out = new FileOutputStream(parResultTrainName);
            PrintStream p = new PrintStream(out);
            this.copyTestHeader(p);
            for (int i = 0; i < expected.length; ++i) {
                p.print(expected[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error creando fichero de resultados " + parResultTrainName);
        }
    }

    private void createTrainingResults(int[] expected, int[] obtained) {
        Attribute at = Attributes.getOutputAttribute(0);
        boolean isNominal = at.getType() == 0;
        try {
            FileOutputStream out = new FileOutputStream(parResultTrainName);
            PrintStream p = new PrintStream(out);
            this.copyTestHeader(p);
            for (int i = 0; i < expected.length; ++i) {
                if (isNominal) {
                    String labelDeseado = expected[i] == -1 ? new String("unclassified") : at.getNominalValue(expected[i]);
                    String labelObtenido = obtained[i] == -1 ? new String("unclassified") : at.getNominalValue(obtained[i]);
                    p.print(labelDeseado + " " + labelObtenido + "\n");
                    continue;
                }
                p.print(expected[i] + " " + obtained[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error creando fichero de resultados " + parResultTrainName);
        }
    }

    private void createTrainingResults(double[][] pattern, int[] pclass) {
        try {
            FileOutputStream out = new FileOutputStream(parResultTrainName);
            PrintStream p = new PrintStream(out);
            this.copyClusterHeader(p);
            p.println("@attribute cluster integer");
            p.println("@data");
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length; ++j) {
                    p.print(pattern[i][j] + ",");
                }
                p.print(pclass[i] + "\n");
            }
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error creando fichero de resultados " + parResultTrainName);
        }
    }

    private void appendResults(double test) {
        try {
            FileOutputStream out = new FileOutputStream(parResultName, true);
            PrintStream p = new PrintStream(out);
            p.print(test + " ");
            p.close();
        }
        catch (Exception e) {
            System.err.println("Error anhadiendo un dato al fichero de resultados");
        }
    }

    private void copyTestHeader(PrintStream p) {
        p.println("@relation " + Attributes.getRelationName());
        p.print(Attributes.getInputAttributesHeader());
        p.print(Attributes.getOutputAttributesHeader());
        p.println(Attributes.getInputHeader());
        p.println(Attributes.getOutputHeader());
        p.println("@data");
    }

    private void copyClusterHeader(PrintStream p) {
        p.println("@relation " + Attributes.getRelationName());
        p.print(Attributes.getInputAttributesHeader());
        p.println(Attributes.getInputHeader());
    }

    public String[] skipHeader(BufferedReader in) {
        String[] result = null;
        String line = new String();
        String lastAttribute = new String();
        try {
            do {
                String ff1;
                String[] ff;
                in.mark(1024);
                line = in.readLine();
                line.trim();
                if (line.length() == 0) continue;
                if ((line = line.toLowerCase()).startsWith("@attribute")) {
                    lastAttribute = line;
                }
                if (!line.startsWith("@relation") || (ff = line.split(" ")).length <= 1 || (ff1 = ff[1]).equals(this.lastRel)) continue;
                this.lastRel = ff1;
            } while (line.indexOf(64) != -1);
            in.reset();
            System.out.println("El ultimo atributo es " + lastAttribute);
            int pos1 = lastAttribute.indexOf(123);
            int pos2 = lastAttribute.indexOf(125);
            if (pos1 >= 0 && pos2 >= 0) {
                lastAttribute = lastAttribute.substring(pos1 + 1, pos2);
                result = lastAttribute.split(",");
                for (int i = 0; i < result.length; ++i) {
                    result[i] = result[i].trim();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error saltando la cabecera del fichero de resultados");
        }
        return result;
    }

    public String getRelation() {
        return this.lastRel;
    }

    public void results(double[] expected, double[] obtained) {
        this.createResults(expected, obtained);
    }

    public void results(int[] expected, int[] obtained) {
        this.createResults(expected, obtained);
    }

    public void results(double[][] pattern, int[] obtained) {
        this.createResults(pattern, obtained);
    }

    public void trainingResults(double[] expected, double[] obtained) {
        this.createTrainingResults(expected, obtained);
    }

    public void trainingResults(int[] expected, int[] obtained) {
        this.createTrainingResults(expected, obtained);
    }

    public void trainingResults(double[][] pattern, int[] obtained) {
        this.createTrainingResults(pattern, obtained);
    }

    static {
        parResultTrainName = "resultTrain.log";
        parResultName = "resultTest.log";
        parPopSize = 30;
        parIslandNumber = 5;
        parIterNumber = 100;
        parTourSize = 4;
        parMutProb = 0.01;
        parMutAmpl = 0.1;
        parMigProb = 0.001;
        parLoProb = 0.0;
        parLoIterNumber = 2;
        parLoId = 2001;
        parMaxHeigth = 10;
        parNiche = false;
        parMaxNiche = 10;
        parIntraNicheProb = 0.5;
        parDeltaFit = 1.0;
        parP0 = 0.25;
        parP1 = 0.01;
        parNSUB = 25;
        parCrGAProb = 0.5;
        parMuGAProb = 0.5;
        parRuleNumber = 5;
        parCrossId1 = 1;
        parMutaId1 = 2;
        parCrossId2 = 1001;
        parMutaId2 = 1003;
        parCrossId3 = 1002;
        parMutaId3 = 1004;
        parFitnessType = 0;
        parKernel = 1.0;
        parNMeans = 1;
        parGALen = 10;
        parSigma = 1.0E-4;
        parSignificanceLevel = 0.95;
        parSeed = 1L;
        parNClusters = 1;
        fuzzyTolerance = 0.1;
        tableType1 = "YES";
        tableType2 = "YES";
        tableType3 = "YES";
        numberLine = 2;
        numberLine1 = 1;
        numberLine2 = 1;
        numberLine3 = 1;
        dataTable1 = "TEST-TRAIN";
        dataTable2 = "TEST-TRAIN";
        dataTable3 = "TEST-TRAIN";
        dataMatrix = "TEST-TRAIN";
        matrixConfussion = "YES";
        curDataset = 0;
    }

    class SyntaxError
    extends Exception {
        SyntaxError() {
        }

        SyntaxError(String s) {
            super(s);
        }
    }
}

