/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    protected boolean unwrapRightObject;
    protected Accumulate accumulate;
    protected AlphaNodeFieldConstraint[] resultConstraints;
    protected BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder, context);
        this.resultBinder = resultBinder;
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.unwrapRightObject = unwrapRightObject;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.hashcode = this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ Arrays.hashCode(this.resultConstraints);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.unwrapRightObject = in.readBoolean();
        this.accumulate = (Accumulate)in.readObject();
        this.resultConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.resultBinder = (BetaConstraints)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.unwrapRightObject);
        out.writeObject(this.accumulate);
        out.writeObject(this.resultConstraints);
        out.writeObject(this.resultBinder);
    }

    @Override
    public short getType() {
        return 211;
    }

    public Accumulate getAccumulate() {
        return this.accumulate;
    }

    public AlphaNodeFieldConstraint[] getResultConstraints() {
        return this.resultConstraints;
    }

    public BetaConstraints getResultBinder() {
        return this.resultBinder;
    }

    public boolean isUnwrapRightObject() {
        return this.unwrapRightObject;
    }

    public InternalFactHandle createResultFactHandle(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, Object result) {
        Map map;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = (ProtobufMessages.FactHandle)map.get(PersisterHelper.createTupleKey(leftTuple));
        }
        InternalFactHandle handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), result, _handle.getRecency(), workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory, null) : workingMemory.getFactHandleFactory().newFactHandle(result, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory, null);
        return handle;
    }

    @Override
    public void attach(BuildContext context) {
        this.resultBinder.init(context, this.getType());
        super.attach(context);
    }

    @Override
    protected int calculateHashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        return this == object || this.internalEquals(object) && this.leftInput.thisNodeEquals(((AccumulateNode)object).leftInput) && this.rightInput.thisNodeEquals(((AccumulateNode)object).rightInput);
    }

    @Override
    protected boolean internalEquals(Object object) {
        if (object == null || !(object instanceof AccumulateNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        return this.constraints.equals(other.constraints) && this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        BetaMemory betaMemory = this.constraints.createBetaMemory(config, (short)211);
        AccumulateMemory memory = this.accumulate.isMultiFunction() ? new MultiAccumulateMemory(betaMemory, this.accumulate.getAccumulators()) : new SingleAccumulateMemory(betaMemory, this.accumulate.getAccumulators()[0]);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        return memory;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        BetaMemory bm = memory.getBetaMemory();
        rightTuple.setPropagationContext(pctx);
        this.doDeleteRightTuple(rightTuple, workingMemory, bm);
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            this.getRightInput().removeObjectSink(this);
            return true;
        }
        return false;
    }

    public static enum ActivitySource {
        LEFT,
        RIGHT;

    }

    public static class AccumulateContext
    implements Externalizable {
        public Object context;
        public RightTuple result;
        public InternalFactHandle resultFactHandle;
        public LeftTuple resultLeftTuple;
        public boolean propagated;
        private WorkingMemoryAction action;
        private PropagationContext propagationContext;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = in.readObject();
            this.result = (RightTuple)in.readObject();
            this.propagated = in.readBoolean();
            this.propagationContext = (PropagationContext)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.result);
            out.writeBoolean(this.propagated);
            out.writeObject(this.propagationContext);
        }

        public WorkingMemoryAction getAction() {
            return this.action;
        }

        public void setAction(WorkingMemoryAction action) {
            this.action = action;
        }

        public InternalFactHandle getResultFactHandle() {
            return this.resultFactHandle;
        }

        public void setResultFactHandle(InternalFactHandle resultFactHandle) {
            this.resultFactHandle = resultFactHandle;
        }

        public LeftTuple getResultLeftTuple() {
            return this.resultLeftTuple;
        }

        public void setResultLeftTuple(LeftTuple resultLeftTuple) {
            this.resultLeftTuple = resultLeftTuple;
        }

        public PropagationContext getPropagationContext() {
            return this.propagationContext;
        }

        public void setPropagationContext(PropagationContext propagationContext) {
            this.propagationContext = propagationContext;
        }
    }

    public static class MultiAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator[] accumulators;

        public MultiAccumulateMemory(BetaMemory betaMemory, Accumulator[] accumulators) {
            super(betaMemory);
            this.accumulators = accumulators;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = new Object[this.accumulators.length];
            for (int i = 0; i < this.accumulators.length; ++i) {
                ((Object[])this.workingMemoryContext)[i] = this.accumulators[i].createWorkingMemoryContext();
            }
        }
    }

    public static class SingleAccumulateMemory
    extends AccumulateMemory {
        private final Accumulator accumulator;

        public SingleAccumulateMemory(BetaMemory betaMemory, Accumulator accumulator) {
            super(betaMemory);
            this.accumulator = accumulator;
        }

        @Override
        public void reset() {
            this.getBetaMemory().reset();
            this.workingMemoryContext = this.accumulator.createWorkingMemoryContext();
        }
    }

    public static abstract class AccumulateMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        public Object workingMemoryContext;
        private final BetaMemory betaMemory;
        public ContextEntry[] resultsContext;

        protected AccumulateMemory(BetaMemory betaMemory) {
            this.betaMemory = betaMemory;
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public short getNodeType() {
            return 211;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        @Override
        public abstract void reset();

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }
}

