/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

public enum CoreHunterMeasure {
    PRECOMPUTED_DISTANCE("Precomputed Distance", "PD"),
    GOWERS("Gowers distance", "GD"),
    MODIFIED_ROGERS("Modified Rogers distance", "MR"),
    CAVALLI_SFORZA_EDWARDS("Cavalli-Sforza and Edwards distance", "CE");

    private String name;
    private String abbreviation;

    private CoreHunterMeasure(String name, String abbreviation) {
        this.name = name;
        this.abbreviation = abbreviation;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAbbreviation() {
        return this.abbreviation;
    }

    public static CoreHunterMeasure createFromAbbreviation(String abbr) {
        CoreHunterMeasure[] measures;
        for (CoreHunterMeasure measure : measures = CoreHunterMeasure.values()) {
            if (!measure.getAbbreviation().equals(abbr)) continue;
            return measure;
        }
        return null;
    }
}

