/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

import org.corehunter.CoreHunterMeasure;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.Range;

public class CoreHunterObjective {
    private CoreHunterObjectiveType objectiveType;
    private CoreHunterMeasure measure;
    private double weight;
    private Range<Double> normalizationRange;

    public CoreHunterObjective(CoreHunterObjectiveType objectiveType) {
        this(objectiveType, null);
    }

    public CoreHunterObjective(CoreHunterObjectiveType objectiveType, CoreHunterMeasure measure) {
        this(objectiveType, measure, 1.0);
    }

    public CoreHunterObjective(CoreHunterObjectiveType objectiveType, double weight) {
        this(objectiveType, null, weight);
    }

    public CoreHunterObjective(CoreHunterObjectiveType objectiveType, CoreHunterMeasure measure, double weight) {
        this(objectiveType, measure, weight, null);
    }

    public CoreHunterObjective(CoreHunterObjectiveType objectiveType, double weight, Range<Double> normalizationRange) {
        this(objectiveType, null, weight, normalizationRange);
    }

    public CoreHunterObjective(CoreHunterObjectiveType objectiveType, CoreHunterMeasure measure, double weight, Range<Double> normalizationRange) {
        this.setObjectiveType(objectiveType);
        this.setMeasure(measure);
        this.setWeight(weight);
        this.setNormalizationRange(normalizationRange);
    }

    public CoreHunterObjective(CoreHunterObjective objective) {
        this.setObjectiveType(objective.getObjectiveType());
        this.setMeasure(objective.getMeasure());
        this.setWeight(objective.getWeight());
    }

    public final CoreHunterObjectiveType getObjectiveType() {
        return this.objectiveType;
    }

    public final void setObjectiveType(CoreHunterObjectiveType objectiveType) {
        this.objectiveType = objectiveType;
    }

    public final CoreHunterMeasure getMeasure() {
        return this.measure;
    }

    public final void setMeasure(CoreHunterMeasure measure) {
        this.measure = measure;
    }

    public double getWeight() {
        return this.weight;
    }

    public final void setWeight(double weight) {
        this.weight = weight;
    }

    public final Range<Double> getNormalizationRange() {
        return this.normalizationRange;
    }

    public final void setNormalizationRange(Range<Double> range) {
        this.normalizationRange = range;
    }

    public final boolean isSameObjective(CoreHunterObjective objective) {
        return objective != null && this.getObjectiveType().equals((Object)objective.getObjectiveType()) && this.getMeasure().equals((Object)objective.getMeasure());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.measure == null ? 0 : this.measure.hashCode());
        result = 31 * result + (this.normalizationRange == null ? 0 : this.normalizationRange.hashCode());
        result = 31 * result + (this.objectiveType == null ? 0 : this.objectiveType.hashCode());
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoreHunterObjective other = (CoreHunterObjective)obj;
        if (this.measure != other.measure) {
            return false;
        }
        if (this.normalizationRange == null ? other.normalizationRange != null : !this.normalizationRange.equals(other.normalizationRange)) {
            return false;
        }
        if (this.objectiveType != other.objectiveType) {
            return false;
        }
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }

    public String toString() {
        return "CoreHunterObjective [objectiveType=" + (Object)((Object)this.objectiveType) + ", measure=" + (Object)((Object)this.measure) + ", weight=" + this.weight + ", normalizationRange=" + this.normalizationRange + "]";
    }
}

