## ---- echo=FALSE, message=FALSE------------------------------------------
library(MASS)
library(discreteRV)

## ------------------------------------------------------------------------
(X <- RV(outcomes = 1:6, probs = 1/6))

## ------------------------------------------------------------------------
(X <- RV(1:6))

## ------------------------------------------------------------------------
pois.func <- function(y, lambda) { return(lambda^y * exp(-lambda) / factorial(y)) }

(Y <- RV(outcomes = c(0, Inf), probs = pois.func, lambda = 2))

## ------------------------------------------------------------------------
(Y <- RV("poisson", lambda = 2))

## ------------------------------------------------------------------------
(X.loaded <- RV(outcomes = 1:6, odds = c(4, 1, 1, 1, 1, 1)))

## ------------------------------------------------------------------------
P(X == 2)
P(X < 3)
P(X < 3 | X < 4)

## ------------------------------------------------------------------------
delta <- 3
lambda <- 2

P((Y >= lambda - delta) %AND% (Y <= lambda + delta))

## ------------------------------------------------------------------------
P((Y - lambda)^2 <= delta^2)

## ------------------------------------------------------------------------
E(X)
V(X)
E( (X-E(X))^2 )

## ----jointdefine---------------------------------------------------------
(AandB <- jointRV(outcomes = list(1:3, 0:2), probs = 1:9 / sum(1:9)))

## ----marginaltime--------------------------------------------------------
A <- marginal(AandB, 1)
B <- marginal(AandB, 2)

## ------------------------------------------------------------------------
P(A < B)
P(A == 2 | B > 0)
P(A == 2 | (B == 1) %OR% (B == 2))
independent(A, B)
A | (A > 1)
A | (B == 2)
E(A | (B == 2))

## ------------------------------------------------------------------------
(X2 <- iid(X, n = 2))
(X3 <- iid(X, n = 3))
(X2 <- SofIID(X, n = 2))
(X20 <- SofIID(X, n = 20, progress = FALSE))

## ------------------------------------------------------------------------
RV(1:6) + RV(1:6)

## ------------------------------------------------------------------------
plot(X)
plot(X2)
plot(X20)
qqnorm(X20)
abline()

## ------------------------------------------------------------------------
(X.sim <- rsim(X, 10))

props(X.sim)
Prop(X.sim == 3)
Prop(X.sim > 3)

## ----craps1--------------------------------------------------------------
(Roll <- RV(1:6) + RV(1:6))

## ----craps2--------------------------------------------------------------
P(Roll %in% c(7, 11, 2, 3, 12))

## ----craps3--------------------------------------------------------------
P(Roll %in% c(7, 11) | Roll %in% c(7, 11, 2, 3, 12))
P(Roll %in% c(2, 3, 12) | Roll %in% c(7, 11, 2, 3, 12))

## ----craps4--------------------------------------------------------------
TwoRolls <- iid(Roll, 2)

First <- marginal(TwoRolls, 1)
Second <- marginal(TwoRolls, 2)

P(First %in% c(7, 11) %OR% (First %in% 4:10 %AND% (First == Second)))

## ----craps5--------------------------------------------------------------
craps_game <- function(RV) {
    
    my.roll <- rsim(RV, 1)
    
    if (my.roll %in% c(7, 11)) { return(1) }
    else if (my.roll %in% c(2, 3, 12)) { return(0) }
    else {
        new.roll <- 0
        while (new.roll != my.roll & new.roll != 7) {
            new.roll <- rsim(RV, 1)
        }
        
        return(as.numeric(new.roll == my.roll))
    }
}

sim.results <- replicate(100000, craps_game(Roll))
mean(sim.results)

