/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.hups.PointSetRandomization;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class CachedPointSet
extends PointSet {
    protected PointSet P;
    protected double[][] x;

    protected CachedPointSet() {
    }

    public CachedPointSet(PointSet P, int n, int dim) {
        if (P.getNumPoints() < n) {
            throw new IllegalArgumentException("Cannot cache more points than in point set P.");
        }
        if (P.getDimension() < dim) {
            throw new IllegalArgumentException("Cannot cache points with more coordinates than the dimension.");
        }
        this.numPoints = n;
        this.dim = dim;
        this.P = P;
        this.init();
    }

    protected void init() {
        PointSetIterator itr = this.P.iterator();
        this.x = new double[this.numPoints][this.dim];
        for (int i = 0; i < this.numPoints; ++i) {
            itr.nextPoint(this.x[i], this.dim);
        }
    }

    public CachedPointSet(PointSet P) {
        this.numPoints = P.getNumPoints();
        this.dim = P.getDimension();
        if (this.numPoints == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot cache infinite number of points");
        }
        if (this.dim == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot cache infinite dimensional points");
        }
        this.P = P;
        this.init();
    }

    public void addRandomShift(int d1, int d2, RandomStream stream) {
        this.P.addRandomShift(d1, d2, stream);
        this.init();
    }

    public void randomize(PointSetRandomization rand) {
        this.P.randomize(rand);
        this.init();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Cached point set" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        sb.append(PrintfFormat.NEWLINE + "Cached point set information {" + PrintfFormat.NEWLINE);
        sb.append(this.P.toString());
        sb.append(PrintfFormat.NEWLINE + "}");
        return sb.toString();
    }

    public double getCoordinate(int i, int j) {
        return this.x[i][j];
    }
}

