/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.util.Formatter;

public class SVD {
    double[][] originalMatrix;
    int numRows;
    int numCols;
    double[][] U;
    double[][] V;
    double[] diagonal;
    double[] offDiagonal;
    double[] buffer;
    double normalizer;
    double scale;
    double sum;

    public SVD(double[][] m) {
        int otherCol;
        int row;
        int col;
        this.originalMatrix = m;
        this.numRows = this.originalMatrix.length;
        this.numCols = this.originalMatrix[0].length;
        if (this.numRows < this.numCols) {
            throw new RuntimeException("rows cannot be smaller than columns");
        }
        this.U = new double[this.numRows][this.numCols];
        this.V = new double[this.numCols][this.numCols];
        this.diagonal = new double[this.numCols];
        this.offDiagonal = new double[this.numCols];
        this.buffer = new double[this.numRows];
        int maxCol = this.numCols;
        if (this.numRows - 1 < maxCol) {
            maxCol = this.numRows - 1;
        }
        for (col = 0; col < maxCol; ++col) {
            if (col < this.numRows - 1) {
                this.diagonal[col] = 0.0;
                for (row = col; row < this.numRows; ++row) {
                    int n = col;
                    this.diagonal[n] = this.diagonal[n] + this.originalMatrix[row][col] * this.originalMatrix[row][col];
                }
                this.diagonal[col] = Math.sqrt(this.diagonal[col]);
                if (this.diagonal[col] != 0.0) {
                    if (this.originalMatrix[col][col] < 0.0) {
                        this.diagonal[col] = -this.diagonal[col];
                    }
                    this.normalizer = 1.0 / this.diagonal[col];
                    for (row = col; row < this.numRows; ++row) {
                        double[] dArray = this.originalMatrix[row];
                        int n = col;
                        dArray[n] = dArray[n] * this.normalizer;
                    }
                    double[] dArray = this.originalMatrix[col];
                    int n = col;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.diagonal[col] = -this.diagonal[col];
            }
            for (otherCol = col + 1; otherCol < this.numCols; ++otherCol) {
                if (col < this.numRows - 1 && this.diagonal[col] != 0.0) {
                    int row2;
                    this.sum = 0.0;
                    for (row2 = col; row2 < this.numRows; ++row2) {
                        this.sum += this.originalMatrix[row2][otherCol] * this.originalMatrix[row2][col];
                    }
                    this.scale = this.sum / this.originalMatrix[col][col];
                    for (row2 = col; row2 < this.numRows; ++row2) {
                        double[] dArray = this.originalMatrix[row2];
                        int n = otherCol;
                        dArray[n] = dArray[n] - this.scale * this.originalMatrix[row2][col];
                    }
                }
                this.offDiagonal[otherCol] = this.originalMatrix[col][otherCol];
            }
            for (row = col; row < this.numRows; ++row) {
                this.U[row][col] = this.originalMatrix[row][col];
            }
            if (col >= this.numCols - 2) continue;
            this.sum = 0.0;
            for (otherCol = col + 1; otherCol < this.numCols; ++otherCol) {
                this.sum += this.offDiagonal[otherCol] * this.offDiagonal[otherCol];
            }
            if (this.sum != 0.0) {
                this.offDiagonal[col] = Math.sqrt(this.sum);
                if (this.offDiagonal[col + 1] < 0.0) {
                    this.offDiagonal[col] = -this.offDiagonal[col];
                }
                this.normalizer = 1.0 / this.offDiagonal[col];
                otherCol = col + 1;
                while (otherCol < this.numCols) {
                    int n = otherCol++;
                    this.offDiagonal[n] = this.offDiagonal[n] * this.normalizer;
                }
                int n = col + 1;
                this.offDiagonal[n] = this.offDiagonal[n] + 1.0;
            }
            this.offDiagonal[col] = -this.offDiagonal[col];
            if (col < this.numRows - 1 && this.offDiagonal[col] != 0.0) {
                for (row = col + 1; row < this.numRows; ++row) {
                    int otherCol2;
                    this.sum = 0.0;
                    double[] currentRow = this.originalMatrix[row];
                    for (otherCol2 = col + 1; otherCol2 < this.numCols; ++otherCol2) {
                        this.sum += this.offDiagonal[otherCol2] * currentRow[otherCol2];
                    }
                    this.scale = this.sum / this.offDiagonal[col + 1];
                    for (otherCol2 = col + 1; otherCol2 < this.numCols; ++otherCol2) {
                        int n = otherCol2;
                        currentRow[n] = currentRow[n] - this.scale * this.offDiagonal[otherCol2];
                    }
                }
            }
            for (otherCol = col + 1; otherCol < this.numCols; ++otherCol) {
                this.V[otherCol][col] = this.offDiagonal[otherCol];
            }
        }
        if (maxCol < this.numCols) {
            this.diagonal[maxCol] = this.originalMatrix[maxCol][maxCol];
        }
        this.offDiagonal[this.numCols - 2] = this.originalMatrix[this.numCols - 2][this.numCols - 1];
        this.offDiagonal[this.numCols - 1] = 0.0;
        for (col = maxCol - 1; col >= 0; --col) {
            if (this.diagonal[col] != 0.0) {
                for (otherCol = col + 1; otherCol < this.numCols; ++otherCol) {
                    int row3;
                    this.sum = 0.0;
                    for (row3 = col; row3 < this.numRows; ++row3) {
                        this.sum += this.U[row3][col] * this.U[row3][otherCol];
                    }
                    this.scale = -this.sum / this.U[col][col];
                    for (row3 = col; row3 < this.numRows; ++row3) {
                        double[] dArray = this.U[row3];
                        int n = otherCol;
                        dArray[n] = dArray[n] + this.scale * this.U[row3][col];
                    }
                }
                for (row = 0; row < col - 1; ++row) {
                    this.U[row][col] = 0.0;
                }
                this.U[col][col] = 1.0 - this.U[col][col];
                for (row = col + 1; row < this.numRows; ++row) {
                    double[] dArray = this.U[row];
                    int n = col;
                    dArray[n] = dArray[n] * -1.0;
                }
                continue;
            }
            for (row = 0; row < col - 1; ++row) {
                this.U[col][row] = 0.0;
            }
            this.U[col][col] = 1.0;
        }
        for (col = this.numCols - 1; col >= 0; --col) {
            if (col < this.numCols - 2 && this.offDiagonal[col] != 0.0) {
                for (otherCol = col + 1; otherCol < this.numCols; ++otherCol) {
                    int row4;
                    this.sum = 0.0;
                    for (row4 = col; row4 < this.numCols; ++row4) {
                        this.sum += this.V[row4][col] * this.V[row4][otherCol];
                    }
                    this.scale = -this.sum / this.V[col + 1][col];
                    for (row4 = col; row4 < this.numCols; ++row4) {
                        double[] dArray = this.V[row4];
                        int n = otherCol;
                        dArray[n] = dArray[n] + this.scale * this.V[row4][col];
                    }
                }
            }
            for (row = 0; row < this.numCols; ++row) {
                this.V[row][col] = 0.0;
            }
            this.V[col][col] = 1.0;
        }
        int lastCol = this.numCols;
        double effectivelyZero = Math.pow(2.0, -966.0);
        double verySmallFraction = Math.pow(2.0, -52.0);
        System.out.println("starting bidiagonal QR");
        int iteration = 0;
        while (lastCol > 0) {
            int row5;
            double sine;
            double cosine;
            double distance;
            int situation;
            int startCol;
            ++iteration;
            for (startCol = lastCol - 2; startCol >= 0; --startCol) {
                if (!(Math.abs(this.offDiagonal[startCol]) <= effectivelyZero + verySmallFraction * (Math.abs(this.diagonal[startCol]) + Math.abs(this.diagonal[startCol + 1])))) continue;
                this.offDiagonal[startCol] = 0.0;
                break;
            }
            if (startCol == lastCol - 2) {
                --lastCol;
                situation = 4;
            } else {
                int middleCol;
                for (middleCol = lastCol - 1; middleCol >= startCol && middleCol != startCol; --middleCol) {
                    double value = Math.abs(this.offDiagonal[middleCol]);
                    if (middleCol > 0) {
                        value += Math.abs(this.offDiagonal[middleCol - 1]);
                        continue;
                    }
                    if (!(Math.abs(this.diagonal[middleCol]) <= effectivelyZero + verySmallFraction * value)) continue;
                    this.diagonal[middleCol] = 0.0;
                    break;
                }
                situation = middleCol == startCol ? 3 : (middleCol == lastCol - 1 ? 1 : 2);
            }
            ++startCol;
            if (situation == 1) {
                double offDiagonalElement = this.offDiagonal[lastCol - 2];
                this.offDiagonal[lastCol - 2] = 0.0;
                for (int col2 = lastCol - 2; col2 >= startCol; --col2) {
                    distance = SVD.safeDistance(this.diagonal[col2], offDiagonalElement);
                    cosine = this.diagonal[col2] / distance;
                    sine = offDiagonalElement / distance;
                    this.diagonal[col2] = distance;
                    if (col2 != startCol) {
                        offDiagonalElement = -sine * this.offDiagonal[col2 - 1];
                        this.offDiagonal[col2 - 1] = cosine * this.offDiagonal[col2 - 1];
                    }
                    for (row5 = 0; row5 < this.numCols; ++row5) {
                        distance = cosine * this.V[row5][col2] + sine * this.V[row5][startCol - 1];
                        this.V[row5][startCol - 1] = -sine * this.V[row5][startCol] + cosine * this.V[row5][startCol - 1];
                        this.V[row5][startCol] = distance;
                    }
                }
                continue;
            }
            if (situation == 2) {
                double offDiagonalElement = this.offDiagonal[startCol - 1];
                this.offDiagonal[startCol - 1] = 0.0;
                for (int col3 = startCol; col3 < lastCol; ++col3) {
                    distance = SVD.safeDistance(this.diagonal[col3], offDiagonalElement);
                    cosine = this.diagonal[col3] / distance;
                    sine = offDiagonalElement / distance;
                    this.diagonal[col3] = distance;
                    offDiagonalElement = -sine * this.offDiagonal[col3];
                    this.offDiagonal[col3] = cosine * this.offDiagonal[col3];
                    for (row5 = 0; row5 < this.numRows; ++row5) {
                        distance = cosine * this.U[row5][col3] + sine * this.U[row5][startCol - 1];
                        this.U[row5][startCol - 1] = -sine * this.U[row5][startCol] + cosine * this.U[row5][startCol - 1];
                        this.U[row5][startCol] = distance;
                    }
                }
                continue;
            }
            if (situation == 3) {
                double max = Math.abs(this.diagonal[lastCol - 2]);
                if (Math.abs(this.diagonal[lastCol - 1]) > max) {
                    max = Math.abs(this.diagonal[lastCol - 1]);
                }
                if (Math.abs(this.offDiagonal[lastCol - 2]) > max) {
                    max = Math.abs(this.offDiagonal[lastCol - 2]);
                }
                if (Math.abs(this.diagonal[startCol]) > max) {
                    max = Math.abs(this.diagonal[startCol]);
                }
                if (Math.abs(this.offDiagonal[startCol]) > max) {
                    max = Math.abs(this.offDiagonal[startCol]);
                }
                double alpha = this.diagonal[lastCol - 2] / max * (this.diagonal[lastCol - 2] / max);
                double beta = this.diagonal[lastCol - 1] / max * (this.diagonal[lastCol - 1] / max) + this.offDiagonal[lastCol - 2] / max * (this.offDiagonal[lastCol - 2] / max);
                double gamma = this.diagonal[lastCol - 2] / max * (this.offDiagonal[lastCol - 2] / max);
                double halfAminusB = (alpha - beta) / 2.0;
                double sqrtTerm = Math.sqrt(halfAminusB * halfAminusB + gamma * gamma);
                double shift = halfAminusB > 0.0 ? halfAminusB + beta - sqrtTerm : halfAminusB + beta + sqrtTerm;
                double diagonalElement = this.diagonal[startCol] / max * (this.diagonal[startCol] / max) - shift;
                double offDiagonalElement = this.diagonal[startCol] / max * (this.offDiagonal[startCol] / max);
                for (int col4 = startCol; col4 < lastCol - 1; ++col4) {
                    double distance2 = SVD.safeDistance(diagonalElement, offDiagonalElement);
                    double cosine2 = diagonalElement / distance2;
                    double sine2 = offDiagonalElement / distance2;
                    if (col4 != startCol) {
                        this.offDiagonal[col4 - 1] = distance2;
                    }
                    diagonalElement = cosine2 * this.diagonal[col4] + sine2 * this.offDiagonal[col4];
                    this.offDiagonal[col4] = cosine2 * this.offDiagonal[col4] - sine2 * this.diagonal[col4];
                    offDiagonalElement = sine2 * this.diagonal[col4 + 1];
                    this.diagonal[col4 + 1] = cosine2 * this.diagonal[col4 + 1];
                    distance2 = SVD.safeDistance(diagonalElement, offDiagonalElement);
                    cosine2 = diagonalElement / distance2;
                    sine2 = offDiagonalElement / distance2;
                    this.diagonal[col4] = distance2;
                    diagonalElement = cosine2 * this.offDiagonal[col4] + sine2 * this.diagonal[col4 + 1];
                    this.diagonal[col4 + 1] = -sine2 * this.offDiagonal[col4] + cosine2 * this.diagonal[col4 + 1];
                    offDiagonalElement = sine2 * this.offDiagonal[col4 + 1];
                    this.offDiagonal[col4 + 1] = cosine2 * this.offDiagonal[col4 + 1];
                    for (int row6 = 0; row6 < this.numRows; ++row6) {
                        double temp = cosine2 * this.U[row6][col4] + sine2 * this.U[row6][col4 + 1];
                        this.U[row6][col4 + 1] = -sine2 * this.U[row6][col4] + cosine2 * this.U[row6][col4 + 1];
                        this.U[row6][col4] = temp;
                    }
                }
                this.offDiagonal[lastCol - 2] = diagonalElement;
                continue;
            }
            if (situation != 4) continue;
            if (this.diagonal[startCol] < 0.0) {
                this.diagonal[startCol] = -this.diagonal[startCol];
                for (int row7 = 0; row7 < this.numCols; ++row7) {
                    this.V[row7][startCol] = -this.V[row7][startCol];
                }
            }
            for (int currentCol = startCol; currentCol < this.numCols - 1 && this.diagonal[currentCol] < this.diagonal[currentCol + 1]; ++currentCol) {
                int row8;
                double temp = this.diagonal[currentCol];
                this.diagonal[currentCol] = this.diagonal[currentCol + 1];
                this.diagonal[currentCol + 1] = temp;
                for (row8 = 0; row8 < this.numCols; ++row8) {
                    temp = this.V[row8][currentCol];
                    this.V[row8][currentCol] = this.V[row8][currentCol + 1];
                    this.V[row8][currentCol + 1] = temp;
                }
                for (row8 = 0; row8 < this.numRows; ++row8) {
                    temp = this.U[row8][currentCol];
                    this.U[row8][currentCol] = this.U[row8][currentCol + 1];
                    this.U[row8][currentCol + 1] = temp;
                }
            }
        }
        this.printBidiag();
        System.out.println();
        this.print(this.U);
        System.out.println();
        this.print(this.V);
    }

    public void print(double[][] matrix) {
        Formatter out = new Formatter();
        for (int row = 0; row < matrix.length; ++row) {
            for (int col = 0; col < matrix[row].length; ++col) {
                out.format("%.4f\t", matrix[row][col]);
            }
            out.format("\n", new Object[0]);
        }
        System.out.println(out);
    }

    public void printBidiag() {
        int col;
        Formatter out = new Formatter();
        for (col = 0; col < this.numCols; ++col) {
            out.format("%.4f\t", this.offDiagonal[col]);
        }
        out.format("\n", new Object[0]);
        for (col = 0; col < this.numCols; ++col) {
            out.format("%.4f\t", this.diagonal[col]);
        }
        System.out.println(out);
    }

    public void printFullBidiag() {
        for (int row = 0; row < this.numRows; ++row) {
            Formatter out = new Formatter();
            for (int col = 0; col < this.numCols; ++col) {
                if (col == row) {
                    out.format("%.4f\t", this.diagonal[row]);
                    continue;
                }
                if (col == row + 1) {
                    out.format("%.4f\t", this.offDiagonal[row]);
                    continue;
                }
                out.format("%.4f\t", 0.0);
            }
            System.out.println(out);
        }
    }

    public static double safeDistance(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }
}

