library("MASS")
n <- 200
mu <- c(0,0)
Sigma <- matrix(c(1,0.7,0.7,1), ncol=2)
set.seed(0)
x   <- mvrnorm(n, mu, Sigma)
xb  <- colMeans(x)
S   <- cov(x)
col <- gray(0.075*(13:1))
pdf("mahalanobis.pdf", width=10, height=5)
par(mfrow=c(1,2))
de <- 3*sqrt(apply(x-xb, 1, function(xi) { return(sum(xi^2)) } ))
plot(x, main="Euclidean distance", pch=19, cex=0.5, col=col[ceiling(de)])
abline(v=xb[1])
abline(h=xb[2])
dm <- 3*sqrt(mahalanobis(x, xb, S))
plot(x, main="Mahalanobis distance", pch=19, cex=0.5, col=col[ceiling(dm)])
abline(v=xb[1])
abline(h=xb[2])
dev.off()