/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import opennlp.tools.coref.CorefSample;
import opennlp.tools.coref.DefaultLinker;
import opennlp.tools.coref.LinkerMode;
import opennlp.tools.coref.TreebankLinker;
import opennlp.tools.coref.mention.DefaultParse;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.MentionFinder;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.GenderModel;
import opennlp.tools.coref.sim.NumberModel;
import opennlp.tools.coref.sim.SimilarityModel;
import opennlp.tools.coref.sim.TrainSimilarityModel;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorefTrainer {
    private static boolean containsToken(String token, opennlp.tools.parser.Parse p) {
        for (opennlp.tools.parser.Parse node : p.getTagNodes()) {
            if (!node.getCoveredText().equals(token)) continue;
            return true;
        }
        return false;
    }

    private static Mention[] getMentions(CorefSample sample, MentionFinder mentionFinder) {
        ArrayList<Mention> mentions = new ArrayList<Mention>();
        for (Parse corefParse : sample.getParses()) {
            opennlp.tools.parser.Parse p = ((DefaultParse)corefParse).getParse();
            Mention[] extents = mentionFinder.getMentions(corefParse);
            int en = extents.length;
            block1: for (int ei = 0; ei < en; ++ei) {
                if (extents[ei].getParse() != null) continue;
                Stack<opennlp.tools.parser.Parse> nodes = new Stack<opennlp.tools.parser.Parse>();
                nodes.add(p);
                while (!nodes.isEmpty()) {
                    opennlp.tools.parser.Parse node = (opennlp.tools.parser.Parse)nodes.pop();
                    if (node.getSpan().equals(extents[ei].getSpan()) && node.getType().startsWith("NML")) {
                        DefaultParse corefParseNode = new DefaultParse(node, corefParse.getSentenceNumber());
                        extents[ei].setParse(corefParseNode);
                        extents[ei].setId(corefParseNode.getEntityId());
                        continue block1;
                    }
                    nodes.addAll(Arrays.asList(node.getChildren()));
                }
            }
            mentions.addAll(Arrays.asList(extents));
        }
        return mentions.toArray(new Mention[mentions.size()]);
    }

    public static void train(String modelDirectory, ObjectStream<CorefSample> samples, boolean useTreebank, boolean useDiscourseModel) throws IOException {
        TrainSimilarityModel simTrain = SimilarityModel.trainModel(modelDirectory + "/coref/sim");
        TrainSimilarityModel genTrain = GenderModel.trainModel(modelDirectory + "/coref/gen");
        TrainSimilarityModel numTrain = NumberModel.trainModel(modelDirectory + "/coref/num");
        useTreebank = true;
        DefaultLinker simLinker = useTreebank ? new TreebankLinker(modelDirectory + "/coref/", LinkerMode.SIM) : new DefaultLinker(modelDirectory + "/coref/", LinkerMode.SIM);
        CorefSample sample = samples.read();
        while (sample != null) {
            Mention[] mentions = CorefTrainer.getMentions(sample, simLinker.getMentionFinder());
            Context[] extentContexts = simLinker.constructMentionContexts(mentions);
            simTrain.setExtents(extentContexts);
            genTrain.setExtents(extentContexts);
            numTrain.setExtents(extentContexts);
            sample = samples.read();
        }
        simTrain.trainModel();
        genTrain.trainModel();
        numTrain.trainModel();
        MaxentResolver.setSimilarityModel(SimilarityModel.testModel(modelDirectory + "/coref" + "/sim"));
        samples.reset();
        DefaultLinker trainLinker = useTreebank ? new TreebankLinker(modelDirectory + "/coref/", LinkerMode.TRAIN, useDiscourseModel) : new DefaultLinker(modelDirectory + "/coref/", LinkerMode.TRAIN, useDiscourseModel);
        CorefSample sample2 = samples.read();
        while (sample2 != null) {
            Mention[] mentions = CorefTrainer.getMentions(sample2, trainLinker.getMentionFinder());
            trainLinker.setEntities(mentions);
            sample2 = samples.read();
        }
        trainLinker.train();
    }
}

