/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADPOSSampleStreamFactory
extends LanguageSampleStreamFactory<POSSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, "ad", new ADPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ADPOSSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        this.language = params.getLang();
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(params.getData());
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), params.getEncoding());
        ADPOSSampleStream sentenceStream = new ADPOSSampleStream(lineStream, params.getExpandME(), params.getIncludeFeatures());
        return sentenceStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="expandME", description="expand multiword expressions.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getExpandME();

        @ArgumentParser.ParameterDescription(valueName="includeFeatures", description="combine POS Tags with word features, like number and gender.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getIncludeFeatures();
    }
}

