/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx.proxy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.sourceforge.jtds.jdbc.JtdsCallableStatement;
import net.sourceforge.jtds.jdbcx.proxy.ConnectionProxy;
import net.sourceforge.jtds.jdbcx.proxy.PreparedStatementProxy;

public class CallableStatementProxy
extends PreparedStatementProxy
implements CallableStatement {
    private JtdsCallableStatement _callableStatement;

    CallableStatementProxy(ConnectionProxy connection, JtdsCallableStatement callableStatement) {
        super(connection, callableStatement);
        this._callableStatement = callableStatement;
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public boolean wasNull() throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.wasNull();
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return false;
        }
    }

    public String getString(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getString(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBoolean(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return false;
        }
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getByte(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return -128;
        }
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getShort(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Short.MIN_VALUE;
        }
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getInt(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Integer.MIN_VALUE;
        }
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getLong(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Long.MIN_VALUE;
        }
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getFloat(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Float.MIN_VALUE;
        }
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getDouble(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Double.MIN_VALUE;
        }
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBigDecimal(parameterIndex, scale);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBytes(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getDate(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTime(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTimestamp(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getObject(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBigDecimal(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getObject(parameterIndex, map);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getRef(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBlob(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getClob(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Array getArray(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getArray(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getDate(parameterIndex, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTime(parameterIndex, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTimestamp(parameterIndex, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.registerOutParameter(parameterIndex, sqlType, typeName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public URL getURL(int parameterIndex) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getURL(parameterIndex);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setURL(parameterName, val);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setNull(parameterName, sqlType);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setBoolean(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setByte(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setShort(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setInt(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setLong(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setFloat(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setDouble(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setBigDecimal(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setString(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setBytes(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setDate(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setTime(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setTimestamp(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setAsciiStream(parameterName, x, length);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setBinaryStream(parameterName, x, length);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setObject(parameterName, x, targetSqlType, scale);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setObject(parameterName, x);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setCharacterStream(parameterName, x, length);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setDate(parameterName, x, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setTime(parameterName, x, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setTimestamp(parameterName, x, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.validateConnection();
        try {
            this._callableStatement.setNull(parameterName, sqlType, typeName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
        }
    }

    public String getString(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getString(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBoolean(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return false;
        }
    }

    public byte getByte(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getByte(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return -128;
        }
    }

    public short getShort(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getShort(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Short.MIN_VALUE;
        }
    }

    public int getInt(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getInt(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Integer.MIN_VALUE;
        }
    }

    public long getLong(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getLong(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Long.MIN_VALUE;
        }
    }

    public float getFloat(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getFloat(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Float.MIN_VALUE;
        }
    }

    public double getDouble(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getDouble(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return Double.MIN_VALUE;
        }
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBytes(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Date getDate(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getDate(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Time getTime(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTime(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTimestamp(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Object getObject(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getObject(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBigDecimal(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getObject(parameterName, map);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Ref getRef(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getRef(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Blob getBlob(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getBlob(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Clob getClob(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getClob(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Array getArray(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getArray(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getDate(parameterName, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTime(parameterName, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getTimestamp(parameterName, cal);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }

    public URL getURL(String parameterName) throws SQLException {
        this.validateConnection();
        try {
            return this._callableStatement.getURL(parameterName);
        }
        catch (SQLException sqlException) {
            this.processSQLException(sqlException);
            return null;
        }
    }
}

