/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.BaseConfig;
import eu.kliegr.ac1.DiscretizeConfig;
import eu.kliegr.ac1.EvaluateCrossvalidationConfig;
import eu.kliegr.ac1.ExtendConfig;
import eu.kliegr.ac1.GenerateCSVHeaderConfig;
import eu.kliegr.ac1.GenerateFoldsConfig;
import eu.kliegr.ac1.PipelineConfig;
import eu.kliegr.ac1.PruneConfig;
import eu.kliegr.ac1.Rinterface.arules.RuleLearning;
import eu.kliegr.ac1.Rinterface.discretization.AttributeDiscretization;
import eu.kliegr.ac1.Rinterface.discretization.DiscretizeWithR;
import eu.kliegr.ac1.RuleLearningConfig;
import eu.kliegr.ac1.TestConfig;
import eu.kliegr.ac1.Usage;
import eu.kliegr.ac1.data.parsers.CSVparser;
import eu.kliegr.ac1.performance.StopWatches;
import eu.kliegr.ac1.pipeline.Experimentator;
import eu.kliegr.ac1.preprocess.generatefolds.GenerateFolds;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.PruneRules;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.TestRules;
import eu.kliegr.ac1.rule.extend.ExtendRules;
import eu.kliegr.ac1.rule.parsers.ArulesParser;
import eu.kliegr.ac1.rule.parsers.GUHASimplifiedParser;
import eu.kliegr.ac1.rule.parsers.GenericRuleParser;
import eu.kliegr.ac1.utils.EvaluateCrossvalidation;
import eu.kliegr.ac1.utils.GenerateCSVHeader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class AC1 {
    private static final Logger LOGGER = Logger.getLogger(AC1.class.getName());
    private static final String usage = "*** Instructions *** \n 1] Run with one argument - path to config";
    public static double JAVA_VERSION = AC1.getVersion();

    static double getVersion() {
        int pos;
        String version = System.getProperty("java.version");
        int count = 0;
        for (pos = 0; pos < version.length() && count < 2; ++pos) {
            if (version.charAt(pos) != '.') continue;
            ++count;
        }
        LOGGER.log(Level.INFO, "Running Java {0}", version);
        return Double.parseDouble(version.substring(0, pos - 1));
    }

    public static void cleanup() throws Exception {
        Rule.resetERIDcounter();
    }

    public static void main(String[] args) throws IOException, Exception {
        Usage mode;
        String path;
        if (JAVA_VERSION < 1.8) {
            LOGGER.info("Only Java 1.8+ supported");
            return;
        }
        Level level = Level.INFO;
        System.out.println("Setting log level to " + level);
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setLevel(level);
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(level);
        }
        if (args.length == 1) {
            try {
                path = args[0];
                mode = AC1.detectUsageType(path);
                LOGGER.log(Level.INFO, "Running in {0} mode", (Object)mode);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            return;
        }
        StopWatches performance = new StopWatches();
        performance.startStopWatch("Total");
        if (null != mode) {
            switch (mode) {
                case prune: {
                    performance.startStopWatch("Config load");
                    Object conf = new PruneConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Load data");
                    Data data = CSVparser.parseFromCSVwithHeader(((BaseConfig)conf).getDataPath(), ((BaseConfig)conf).getTargetAttribute(), ((BaseConfig)conf).getAttributeType(), ((BaseConfig)conf).getIDcolumnName(), ((BaseConfig)conf).getCSVSeparator());
                    performance.stopStopWatch("Load data");
                    performance.startStopWatch("Load rules");
                    PruneRules pruneRulesObj = new PruneRules(GenericRuleParser.parseFileForRules(((PruneConfig)conf).getRulesPath(), data), ((PruneConfig)conf).getRuleComparator(), ((PruneConfig)conf).getPruningType());
                    performance.stopStopWatch("Load rules");
                    performance.startStopWatch("Sort rules");
                    pruneRulesObj.sortRules();
                    performance.stopStopWatch("Sort rules");
                    performance.startStopWatch("Count rules");
                    int origRuleCount = pruneRulesObj.getRules().size();
                    performance.stopStopWatch("Count rules");
                    performance.startStopWatch("Prune rules");
                    pruneRulesObj.pruneRules();
                    performance.stopStopWatch("Prune rules");
                    performance.startStopWatch("Save rules");
                    GUHASimplifiedParser.saveRules(pruneRulesObj.getRules(), ((BaseConfig)conf).getOutputPath());
                    performance.stopStopWatch("Save rules");
                    performance.stopStopWatch("Total");
                    pruneRulesObj.saveSummary(origRuleCount, ((PruneConfig)conf).getOutputSummaryPath(), performance);
                    break;
                }
                case extend: {
                    performance.startStopWatch("Config load");
                    Object conf = new ExtendConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Load data");
                    Data data = CSVparser.parseFromCSVwithHeader(((BaseConfig)conf).getDataPath(), ((BaseConfig)conf).getTargetAttribute(), ((BaseConfig)conf).getAttributeType(), ((BaseConfig)conf).getIDcolumnName(), ((BaseConfig)conf).getCSVSeparator());
                    performance.stopStopWatch("Load data");
                    performance.startStopWatch("Load rules");
                    ExtendRules extendRulesObj = new ExtendRules(GenericRuleParser.parseFileForRules(((ExtendConfig)conf).getRulesPath(), data), ((ExtendConfig)conf).getRuleComparator(), ((ExtendConfig)conf).getExtendType(), ((ExtendConfig)conf).getExtendRuleConfig(), data);
                    performance.stopStopWatch("Load rules");
                    performance.startStopWatch("Sort rules");
                    extendRulesObj.sortRules();
                    performance.stopStopWatch("Sort rules");
                    performance.startStopWatch("Extend rules");
                    extendRulesObj.processRules(((ExtendConfig)conf).isAttributePruningEnabled(), ((ExtendConfig)conf).isTrimmingEnabled(), ((ExtendConfig)conf).isContinuousPruningEnabled(), ((ExtendConfig)conf).isFuzzificationEnabled(), ((ExtendConfig)conf).getPostPruningType(), ((ExtendConfig)conf).getDefaultRuleOverlapPruningType());
                    performance.stopStopWatch("Extend rules");
                    if (((ExtendConfig)conf).isAnnotationEnabled().booleanValue()) {
                        performance.startStopWatch("Annotate rules");
                        extendRulesObj.annotateRules();
                        performance.stopStopWatch("Annotate rules");
                    }
                    performance.startStopWatch("Save rules");
                    if (((BaseConfig)conf).getOutputPath().endsWith(".arules")) {
                        ArulesParser.saveRules(extendRulesObj, ((BaseConfig)conf).getOutputPath());
                    } else {
                        GUHASimplifiedParser.serializeRules(extendRulesObj.getSeedRules(), ((ExtendConfig)conf).getOutputSeedRulesPath());
                        GUHASimplifiedParser.serializeRules(extendRulesObj.getExtendedRules(), ((ExtendConfig)conf).getOutputExtendedRulesPath());
                        GUHASimplifiedParser.saveRules(extendRulesObj.getExtendedRules(), ((BaseConfig)conf).getOutputPath());
                    }
                    performance.stopStopWatch("Save rules");
                    performance.stopStopWatch("Total");
                    extendRulesObj.saveSummary(((ExtendConfig)conf).getOutputSummaryPath(), performance);
                    break;
                }
                case test: {
                    performance.startStopWatch("Config load");
                    Object conf = new TestConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Load data");
                    Data data = CSVparser.parseFromCSVwithHeader(((BaseConfig)conf).getDataPath(), ((BaseConfig)conf).getTargetAttribute(), ((BaseConfig)conf).getAttributeType(), ((BaseConfig)conf).getIDcolumnName(), ((BaseConfig)conf).getCSVSeparator());
                    performance.stopStopWatch("Load data");
                    performance.startStopWatch("Count rows");
                    int totalTransactions = data.getDataTable().getLoadedTransactionCount();
                    performance.stopStopWatch("Count rows");
                    performance.startStopWatch("Load rules");
                    TestRules testRulesObj = new TestRules(GenericRuleParser.parseFileForRules(((TestConfig)conf).getRulesPath(), data), ((TestConfig)conf).getRuleComparator(), data);
                    performance.stopStopWatch("Load rules");
                    performance.startStopWatch("Sort rules");
                    testRulesObj.sortRules();
                    performance.stopStopWatch("Sort rules");
                    performance.startStopWatch("Classify data");
                    testRulesObj.classifyData(((TestConfig)conf).getTestingType());
                    performance.stopStopWatch("Classify data");
                    performance.startStopWatch("Save result");
                    testRulesObj.saveDebugResult(((BaseConfig)conf).getOutputPath());
                    performance.stopStopWatch("Save result");
                    performance.stopStopWatch("Total");
                    testRulesObj.saveSummary(((TestConfig)conf).getOutputSummaryPath(), totalTransactions, performance);
                    break;
                }
                case discretize: {
                    performance.startStopWatch("Config load");
                    Object conf = new DiscretizeConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Run discretization in R");
                    AttributeDiscretization[] mapping = DiscretizeWithR.executeRdiscretization(((DiscretizeConfig)conf).getDataPath(), ((BaseConfig)conf).getAttributeType(), ((BaseConfig)conf).getIDcolumnName(), ((BaseConfig)conf).getTargetAttribute(), ((BaseConfig)conf).getCSVSeparator());
                    performance.stopStopWatch("Run discretization in R");
                    performance.startStopWatch("Convert data table");
                    DiscretizeWithR.convertCSVwithHeader(((DiscretizeConfig)conf).getDataPath(), ((DiscretizeConfig)conf).getOutputDataPath(), mapping, ((BaseConfig)conf).getCSVSeparator(), ((DiscretizeConfig)conf).getMissingValueTreatment());
                    if (((DiscretizeConfig)conf).getTestDataPath() != null) {
                        DiscretizeWithR.convertCSVwithHeader(((DiscretizeConfig)conf).getTestDataPath(), ((DiscretizeConfig)conf).getTestOutputDataPath(), mapping, ((BaseConfig)conf).getCSVSeparator(), ((DiscretizeConfig)conf).getMissingValueTreatment());
                    }
                    performance.stopStopWatch("Convert data table");
                    performance.stopStopWatch("Total");
                    break;
                }
                case generatefolds: {
                    performance.startStopWatch("Config load");
                    Object conf = new GenerateFoldsConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Run fold generation");
                    GenerateFolds.generateFolds((GenerateFoldsConfig)conf);
                    performance.stopStopWatch("Run fold generation");
                    performance.stopStopWatch("Total");
                    break;
                }
                case learnrules: {
                    performance.startStopWatch("Config load");
                    Object conf = new RuleLearningConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Run fold generation");
                    RuleLearning.learnRules((RuleLearningConfig)conf);
                    performance.stopStopWatch("Run fold generation");
                    performance.stopStopWatch("Total");
                    break;
                }
                case generateheader: {
                    performance.startStopWatch("Config load");
                    Object conf = new GenerateCSVHeaderConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Run generate header");
                    GenerateCSVHeader.generateCSVHeader((GenerateCSVHeaderConfig)conf);
                    performance.stopStopWatch("Run generate header");
                    performance.stopStopWatch("Total");
                    break;
                }
                case evaluatecrossvalidation: {
                    performance.startStopWatch("Config load");
                    Object conf = new EvaluateCrossvalidationConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Run generate header");
                    EvaluateCrossvalidation.evaluateCrossvalidation((EvaluateCrossvalidationConfig)conf);
                    performance.stopStopWatch("Run generate header");
                    performance.stopStopWatch("Total");
                    break;
                }
                case pipeline: {
                    performance.startStopWatch("Config load");
                    Object conf = new PipelineConfig(path);
                    performance.stopStopWatch("Config load");
                    performance.startStopWatch("Run pipeline");
                    Experimentator.runPipeline((PipelineConfig)conf);
                    performance.stopStopWatch("Run pipeline");
                    performance.stopStopWatch("Total");
                    break;
                }
            }
        }
    }

    private static Usage detectUsageType(String path) throws FileNotFoundException, IOException {
        LOGGER.log(Level.INFO, "Detecting usage type from {0}", path);
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        Usage mode = Usage.valueOf(prop.getProperty("Method"));
        ((InputStream)input).close();
        return mode;
    }
}

