/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.Rinterface.discretization;

import java.util.ArrayList;
import java.util.logging.Logger;

public class AttributeDiscretization {
    String attributeName;
    float[] cutOffpoints;
    boolean entireRange = false;
    private static final Logger LOG = Logger.getLogger(AttributeDiscretization.class.getName());

    public AttributeDiscretization() {
    }

    public AttributeDiscretization(ArrayList<String> cutpoints) {
        int i = 0;
        this.cutOffpoints = new float[cutpoints.size()];
        for (String cpoint : cutpoints) {
            if (cpoint.equals("\"All\"")) {
                this.entireRange = true;
                break;
            }
            this.cutOffpoints[i++] = Float.parseFloat(cpoint);
        }
    }

    public String convert(String originalValue) {
        if (this.entireRange) {
            return "\"[-3.4028235E38;3.4028235E38]\"";
        }
        if (originalValue.isEmpty()) {
            return originalValue;
        }
        if (this.cutOffpoints == null) {
            return originalValue;
        }
        float originalValueF = Float.parseFloat(originalValue);
        for (int i = 0; i < this.cutOffpoints.length; ++i) {
            if (!(originalValueF < this.cutOffpoints[i])) continue;
            float lowerBound = i == 0 ? -3.4028235E38f : this.cutOffpoints[i - 1];
            float upperBound = this.cutOffpoints[i];
            return "\"(" + lowerBound + ";" + upperBound + "]\"";
        }
        return "\"(" + this.cutOffpoints[this.cutOffpoints.length - 1] + ";" + Float.MAX_VALUE + "]\"";
    }
}

