/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropDiffN
extends Propagator<IntVar> {
    private final int n;
    private final UndirectedGraph overlappingBoxes;
    private final TIntArrayList boxesToCompute;
    private final TIntArrayList pruneList;

    public PropDiffN(IntVar[] x, IntVar[] y, IntVar[] dx, IntVar[] dy) {
        super((Variable[])ArrayUtils.append(x, y, dx, dy), (Priority)PropagatorPriority.LINEAR, true);
        this.n = x.length;
        if (this.n != y.length || this.n != dx.length || this.n != dy.length) {
            throw new SolverException("PropDiffN variable arrays do not have same size");
        }
        this.overlappingBoxes = new UndirectedGraph(this.model, this.n, SetType.LINKED_LIST, true);
        this.boxesToCompute = new TIntArrayList(this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                if (!this.mayOverlap(i, j)) continue;
                this.overlappingBoxes.addEdge(i, j);
            }
        }
        this.pruneList = new TIntArrayList(this.n);
    }

    @Override
    public int getPropagationConditions(int idx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.prop(varIdx);
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    private void prop(int varIdx) {
        int v = varIdx % this.n;
        ISetIterator iter = this.overlappingBoxes.getNeighborsOf(v).iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            if (this.mayOverlap(v, i)) continue;
            this.overlappingBoxes.removeEdge(v, i);
        }
        if (!this.boxesToCompute.contains(v)) {
            this.boxesToCompute.add(v);
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean hasFiltered = true;
        while (hasFiltered) {
            int k;
            hasFiltered = false;
            if (PropagatorEventType.isFullPropagation(evtmask)) {
                this.boxesToCompute.resetQuick();
                for (int i = 0; i < this.n; ++i) {
                    this.boxesToCompute.add(i);
                    for (int j = i + 1; j < this.n; ++j) {
                        if (this.mayOverlap(i, j)) {
                            this.overlappingBoxes.addEdge(i, j);
                            if (!this.boxInstantiated(i) || !this.boxInstantiated(j)) continue;
                            this.fails();
                            continue;
                        }
                        this.overlappingBoxes.removeEdge(i, j);
                    }
                }
            }
            this.pruneList.clear();
            for (k = 0; k < this.boxesToCompute.size(); ++k) {
                int i = this.boxesToCompute.getQuick(k);
                this.energyCheck(i);
                hasFiltered |= this.prune(i);
            }
            this.boxesToCompute.clear();
            for (k = 0; k < this.pruneList.size(); ++k) {
                this.prop(this.pruneList.getQuick(k));
            }
        }
    }

    private boolean prune(int j) throws ContradictionException {
        boolean hasFiltered = false;
        ISetIterator iter = this.overlappingBoxes.getNeighborsOf(j).iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            if (this.doOverlap(i, j, true)) {
                hasFiltered |= this.filter(i, j, false);
            }
            if (!this.doOverlap(i, j, false)) continue;
            hasFiltered |= this.filter(i, j, true);
        }
        return hasFiltered;
    }

    private void energyCheck(int i) throws ContradictionException {
        int maxNumberRectangles;
        int xm = ((IntVar[])this.vars)[i].getLB();
        int xM = ((IntVar[])this.vars)[i].getUB() + ((IntVar[])this.vars)[i + 2 * this.n].getUB();
        int ym = ((IntVar[])this.vars)[i + this.n].getLB();
        int yM = ((IntVar[])this.vars)[i + this.n].getUB() + ((IntVar[])this.vars)[i + 3 * this.n].getUB();
        int am = ((IntVar[])this.vars)[i + 2 * this.n].getLB() * ((IntVar[])this.vars)[i + 3 * this.n].getLB();
        int xLengthMin = ((IntVar[])this.vars)[i + 2 * this.n].getLB();
        int yLengthMin = ((IntVar[])this.vars)[i + 3 * this.n].getLB();
        ISetIterator iter = this.overlappingBoxes.getNeighborsOf(i).iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            xm = Math.min(xm, ((IntVar[])this.vars)[j].getLB());
            xM = Math.max(xM, ((IntVar[])this.vars)[j].getUB() + ((IntVar[])this.vars)[j + 2 * this.n].getUB());
            ym = Math.min(ym, ((IntVar[])this.vars)[j + this.n].getLB());
            yM = Math.max(yM, ((IntVar[])this.vars)[j + this.n].getUB() + ((IntVar[])this.vars)[j + 3 * this.n].getUB());
            if ((am += ((IntVar[])this.vars)[j + 2 * this.n].getLB() * ((IntVar[])this.vars)[j + 3 * this.n].getLB()) > (xM - xm) * (yM - ym)) {
                this.fails();
            }
            xLengthMin = Math.min(xLengthMin, ((IntVar[])this.vars)[j + 2 * this.n].getLB());
            yLengthMin = Math.min(yLengthMin, ((IntVar[])this.vars)[j + 3 * this.n].getLB());
        }
        if (xLengthMin > 0 && yLengthMin > 0 && (maxNumberRectangles = (xM - xm) / xLengthMin * ((yM - ym) / yLengthMin)) < this.overlappingBoxes.getNeighborsOf(i).size() + 1) {
            this.fails();
        }
    }

    private boolean mayOverlap(int i, int j) {
        return this.isNotDisjoint(i, j, true) && this.isNotDisjoint(i, j, false);
    }

    private boolean isNotDisjoint(int i, int j, boolean horizontal) {
        int off = horizontal ? 0 : this.n;
        return ((IntVar[])this.vars)[i + off].getLB() < ((IntVar[])this.vars)[j + off].getUB() + ((IntVar[])this.vars)[j + off + 2 * this.n].getUB() && ((IntVar[])this.vars)[j + off].getLB() < ((IntVar[])this.vars)[i + off].getUB() + ((IntVar[])this.vars)[i + off + 2 * this.n].getUB();
    }

    private boolean doOverlap(int i, int j, boolean hori) {
        int offSet = hori ? 0 : this.n;
        int s_i = ((IntVar[])this.vars)[i + offSet].getUB();
        int e_i = ((IntVar[])this.vars)[i + offSet].getLB() + ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB();
        int s_j = ((IntVar[])this.vars)[j + offSet].getUB();
        int e_j = ((IntVar[])this.vars)[j + offSet].getLB() + ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB();
        return s_i < e_i && e_j > s_i && s_j < e_i || s_j < e_j && e_i > s_j && s_i < e_j;
    }

    private boolean filter(int i, int j, boolean hori) throws ContradictionException {
        boolean hasFiltered = false;
        int offSet = hori ? 0 : this.n;
        int s_i = ((IntVar[])this.vars)[i + offSet].getUB();
        int e_i = ((IntVar[])this.vars)[i + offSet].getLB() + ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB();
        int s_j = ((IntVar[])this.vars)[j + offSet].getUB();
        int e_j = ((IntVar[])this.vars)[j + offSet].getLB() + ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB();
        if (s_i < e_i || s_j < e_j) {
            boolean filtPrun2;
            boolean filtPrun1;
            if (e_j > s_i) {
                if (((IntVar[])this.vars)[j + offSet].updateLowerBound(e_i, (ICause)this)) {
                    if (!this.pruneList.contains(j)) {
                        this.pruneList.add(j);
                    }
                    hasFiltered = true;
                }
                filtPrun1 = ((IntVar[])this.vars)[i + offSet].updateUpperBound(s_j - ((IntVar[])this.vars)[i + 2 * this.n + offSet].getLB(), (ICause)this);
                filtPrun2 = ((IntVar[])this.vars)[i + offSet + 2 * this.n].updateUpperBound(s_j - ((IntVar[])this.vars)[i + offSet].getLB(), (ICause)this);
                if (filtPrun1 || filtPrun2) {
                    if (!this.pruneList.contains(i)) {
                        this.pruneList.add(i);
                    }
                    hasFiltered = true;
                }
            }
            if (s_j < e_i) {
                if (((IntVar[])this.vars)[i + offSet].updateLowerBound(e_j, (ICause)this)) {
                    if (!this.pruneList.contains(i)) {
                        this.pruneList.add(i);
                    }
                    hasFiltered = true;
                }
                filtPrun1 = ((IntVar[])this.vars)[j + offSet].updateUpperBound(s_i - ((IntVar[])this.vars)[j + 2 * this.n + offSet].getLB(), (ICause)this);
                filtPrun2 = ((IntVar[])this.vars)[j + offSet + 2 * this.n].updateUpperBound(s_i - ((IntVar[])this.vars)[j + offSet].getLB(), (ICause)this);
                if (filtPrun1 || filtPrun2) {
                    if (!this.pruneList.contains(j)) {
                        this.pruneList.add(j);
                    }
                    hasFiltered = true;
                }
            }
        }
        return hasFiltered;
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (!this.boxInstantiated(i)) continue;
            for (int j = i + 1; j < this.n; ++j) {
                if (!this.boxInstantiated(j) || !this.mayOverlap(i, j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean boxInstantiated(int i) {
        return ((IntVar[])this.vars)[i].isInstantiated() && ((IntVar[])this.vars)[i + this.n].isInstantiated() && ((IntVar[])this.vars)[i + 2 * this.n].isInstantiated() && ((IntVar[])this.vars)[i + 3 * this.n].isInstantiated();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DIFFN(");
        for (int i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("[").append(((IntVar[])this.vars)[i].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 2 * this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 3 * this.n].toString()).append("]");
        }
        sb.append(")");
        return sb.toString();
    }
}

