/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.AdminUtils$$anonfun$kafka$admin$AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadata$;
import kafka.common.ErrorMapping$;
import kafka.common.Topic$;
import kafka.common.TopicExistsException;
import kafka.log.LogConfig$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class AdminUtils$
implements Logging,
ScalaObject {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String TopicConfigChangeZnodePrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ Properties createTopic$default$5() {
        return new Properties();
    }

    public /* synthetic */ boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    public /* synthetic */ Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public /* synthetic */ String addPartitions$default$4() {
        return "";
    }

    public /* synthetic */ int addPartitions$default$3() {
        return 1;
    }

    public /* synthetic */ int assignReplicasToBrokers$default$5() {
        return -1;
    }

    public /* synthetic */ int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public Random rand() {
        return this.rand;
    }

    public String TopicConfigChangeZnodePrefix() {
        return this.TopicConfigChangeZnodePrefix;
    }

    public Map<Integer, Seq<Integer>> assignReplicasToBrokers(Seq<Integer> brokerList$1, int nPartitions, int replicationFactor$1, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new AdminOperationException("number of partitions must be larger than 0");
        }
        if (replicationFactor$1 <= 0) {
            throw new AdminOperationException("replication factor must be larger than 0");
        }
        if (replicationFactor$1 > brokerList$1.size()) {
            throw new AdminOperationException(new StringBuilder().append((Object)"replication factor: ").append(BoxesRunTime.boxToInteger(replicationFactor$1)).append((Object)" larger than available brokers: ").append(BoxesRunTime.boxToInteger(brokerList$1.size())).toString());
        }
        HashMap ret$1 = new HashMap();
        int startIndex$1 = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerList$1.size());
        IntRef currentPartitionId$1 = new IntRef(startPartitionId >= 0 ? startPartitionId : 0);
        IntRef nextReplicaShift$1 = new IntRef(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerList$1.size()));
        Predef$.MODULE$.intWrapper(0).until(nPartitions).foreach$mVc$sp(new anonfun.assignReplicasToBrokers.1(brokerList$1, replicationFactor$1, ret$1, startIndex$1, currentPartitionId$1, nextReplicaShift$1));
        return ret$1.toMap(Predef$.MODULE$.conforms());
    }

    /*
     * Unable to fully structure code
     */
    public void addPartitions(ZkClient zkClient, String topic$1, int numPartitions, String replicaAssignmentStr) {
        existingPartitionsReplicaList = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})));
        if (existingPartitionsReplicaList.size() == 0) {
            throw new AdminOperationException(Predef$.MODULE$.augmentString("The topic %s does not exist").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic$1})));
        }
        existingReplicaList$1 = (Seq)((Tuple2)existingPartitionsReplicaList.head())._2();
        partitionsToAdd = numPartitions - existingPartitionsReplicaList.size();
        if (partitionsToAdd <= 0) {
            throw new AdminOperationException("The number of partitions for a topic can only be increased");
        }
        brokerList = ZkUtils$.MODULE$.getSortedBrokerList(zkClient);
        if (replicaAssignmentStr == null) ** GOTO lbl-1000
        v0 = replicaAssignmentStr;
        var10_9 = "";
        if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) lbl-1000:
        // 2 sources

        {
            v1 = this.assignReplicasToBrokers(brokerList, partitionsToAdd, existingReplicaList$1.size(), BoxesRunTime.unboxToInt(existingReplicaList$1.head()), existingPartitionsReplicaList.size());
        } else {
            v1 = this.getManualReplicaAssignment(replicaAssignmentStr, brokerList.toSet(), existingPartitionsReplicaList.size());
        }
        newPartitionReplicaList$1 = v1;
        unmatchedRepFactorList = (Iterable)newPartitionReplicaList$1.values().filter(new anonfun.1(existingReplicaList$1));
        if (unmatchedRepFactorList.size() != 0) {
            throw new AdminOperationException(new StringBuilder().append((Object)"The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic ").append(BoxesRunTime.boxToInteger(existingReplicaList$1.size())).toString());
        }
        this.info((Function0<String>)new anonfun.addPartitions.1(topic$1, newPartitionReplicaList$1));
        partitionReplicaList = existingPartitionsReplicaList.map(new anonfun.2(), Map$.MODULE$.canBuildFrom());
        partitionReplicaList.$plus$plus$eq(newPartitionReplicaList$1);
        x$9 = zkClient;
        x$10 = topic$1;
        x$11 = partitionReplicaList;
        x$12 = true;
        x$13 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        this.createOrUpdateTopicPartitionAssignmentPathInZK(x$9, x$10, x$11, x$13, true);
    }

    public Map<Integer, List<Integer>> getManualReplicaAssignment(String replicaAssignmentList, Set<Integer> availableBrokerList$1, int startPartitionId$1) {
        ObjectRef partitionList$1 = new ObjectRef(replicaAssignmentList.split(","));
        HashMap ret$2 = new HashMap();
        IntRef partitionId$1 = new IntRef(startPartitionId$1);
        partitionList$1.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)).takeRight(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)).size() - partitionId$1.elem);
        Predef$.MODULE$.intWrapper(0).until(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)).size()).foreach$mVc$sp(new anonfun.getManualReplicaAssignment.1(availableBrokerList$1, startPartitionId$1, partitionList$1, ret$2, partitionId$1));
        return ret$2.toMap(Predef$.MODULE$.conforms());
    }

    public void deleteTopic(ZkClient zkClient, String topic) {
        ZkUtils$.MODULE$.createPersistentPath(zkClient, ZkUtils$.MODULE$.getDeleteTopicPath(topic), ZkUtils$.MODULE$.createPersistentPath$default$3());
    }

    public boolean topicExists(ZkClient zkClient, String topic) {
        return zkClient.exists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public void createTopic(ZkClient zkClient, String topic, int partitions, int replicationFactor, Properties topicConfig) {
        Seq<Integer> brokerList = ZkUtils$.MODULE$.getSortedBrokerList(zkClient);
        Map<Integer, Seq<Integer>> replicaAssignment = this.assignReplicasToBrokers(brokerList, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkClient zkClient, String topic, Map<Integer, Seq<Integer>> partitionReplicaAssignment$1, Properties config, boolean update2) {
        Topic$.MODULE$.validate(topic);
        LogConfig$.MODULE$.validate(config);
        Predef$.MODULE$.require(((TraversableOnce)partitionReplicaAssignment$1.values().map(new anonfun.createOrUpdateTopicPartitionAssignmentPathInZK.2(), Iterable$.MODULE$.canBuildFrom())).toSet().size() == 1, new anonfun.createOrUpdateTopicPartitionAssignmentPathInZK.1());
        String topicPath = ZkUtils$.MODULE$.getTopicPath(topic);
        if (!update2 && zkClient.exists(topicPath)) {
            throw new TopicExistsException(Predef$.MODULE$.augmentString("Topic \"%s\" already exists.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
        partitionReplicaAssignment$1.values().foreach(new anonfun.createOrUpdateTopicPartitionAssignmentPathInZK.3(partitionReplicaAssignment$1));
        this.writeTopicConfig(zkClient, topic, config);
        this.writeTopicPartitionAssignment(zkClient, topic, partitionReplicaAssignment$1, update2);
    }

    private void writeTopicPartitionAssignment(ZkClient zkClient, String topic, Map<Integer, Seq<Integer>> replicaAssignment, boolean update2) {
        try {
            String zkPath$1 = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData$1 = ZkUtils$.MODULE$.replicaAssignmentZkData(replicaAssignment.map(new anonfun.4(), scala.collection.Map$.MODULE$.canBuildFrom()));
            if (update2) {
                this.info((Function0<String>)new anonfun.writeTopicPartitionAssignment.2(jsonPartitionData$1));
                ZkUtils$.MODULE$.updatePersistentPath(zkClient, zkPath$1, jsonPartitionData$1);
            } else {
                this.info((Function0<String>)new anonfun.writeTopicPartitionAssignment.1(jsonPartitionData$1));
                ZkUtils$.MODULE$.createPersistentPath(zkClient, zkPath$1, jsonPartitionData$1);
            }
            this.debug((Function0<String>)new anonfun.writeTopicPartitionAssignment.3(zkPath$1, jsonPartitionData$1));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(Predef$.MODULE$.augmentString("topic %s already exists").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public void changeTopicConfig(ZkClient zkClient, String topic, Properties configs) {
        if (this.topicExists(zkClient, topic)) {
            LogConfig$.MODULE$.validate(configs);
            this.writeTopicConfig(zkClient, topic, configs);
            zkClient.createPersistentSequential(new StringBuilder().append((Object)ZkUtils$.MODULE$.TopicConfigChangesPath()).append((Object)"/").append((Object)this.TopicConfigChangeZnodePrefix()).toString(), Json$.MODULE$.encode(topic));
            return;
        }
        throw new AdminOperationException(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    private void writeTopicConfig(ZkClient zkClient, String topic, Properties config) {
        scala.collection.mutable.Map<String, String> configMap = JavaConversions$.MODULE$.asMap(config);
        Object map2 = scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("config").$minus$greater(configMap)}));
        ZkUtils$.MODULE$.updatePersistentPath(zkClient, ZkUtils$.MODULE$.getTopicConfigPath(topic), Json$.MODULE$.encode(map2));
    }

    public Properties fetchTopicConfig(ZkClient zkClient, String topic) {
        String str;
        block3: {
            block4: {
                block5: {
                    block6: {
                        Properties props$1;
                        block2: {
                            str = (String)zkClient.readData(ZkUtils$.MODULE$.getTopicConfigPath(topic), true);
                            props$1 = new Properties();
                            if (str == null) break block2;
                            Option<Object> option = Json$.MODULE$.parseFull(str);
                            None$ none$ = None$.MODULE$;
                            Option<Object> option2 = option;
                            if (!(none$ == null ? option2 != null : !none$.equals(option2))) break block2;
                            if (!(option instanceof Some)) break block3;
                            Some some = (Some)option;
                            Object a = some.x();
                            if (!(a instanceof Map)) break block4;
                            Map map2 = (Map)a;
                            Map map3 = map2;
                            Predef$.MODULE$.require(BoxesRunTime.equals(map3.apply("version"), BoxesRunTime.boxToInteger(1)));
                            Option option3 = map3.get("config");
                            if (!(option3 instanceof Some)) break block5;
                            Some some2 = (Some)option3;
                            Object a2 = some2.x();
                            if (!(a2 instanceof Map)) break block6;
                            ((Map)a2).foreach(new anonfun.fetchTopicConfig.1(props$1));
                        }
                        return props$1;
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid topic config: ").append((Object)str).toString());
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid topic config: ").append((Object)str).toString());
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Unexpected value in config: ").append((Object)str).toString());
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unexpected value in config: ").append((Object)str).toString());
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkClient zkClient$1) {
        return ((TraversableOnce)ZkUtils$.MODULE$.getAllTopics(zkClient$1).map(new anonfun.fetchAllTopicConfigs.1(zkClient$1), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public TopicMetadata fetchTopicMetadataFromZk(String topic, ZkClient zkClient) {
        return this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, zkClient, new HashMap());
    }

    public Set<TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkClient zkClient$3) {
        HashMap cachedBrokerInfo$2 = new HashMap();
        return topics.map(new anonfun.fetchTopicMetadataFromZk.1(zkClient$3, cachedBrokerInfo$2), Set$.MODULE$.canBuildFrom());
    }

    public final TopicMetadata kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(String topic$2, ZkClient zkClient$2, HashMap cachedBrokerInfo$1) {
        TopicMetadata topicMetadata;
        if (ZkUtils$.MODULE$.pathExists(zkClient$2, ZkUtils$.MODULE$.getTopicPath(topic$2))) {
            Map topicPartitionAssignment = (Map)ZkUtils$.MODULE$.getPartitionAssignmentForTopics(zkClient$2, (Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$2}))).get(topic$2).get();
            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith(new anonfun.5());
            List<PartitionMetadata> partitionMetadata = sortedPartitions.map(new anonfun.6(topic$2, zkClient$2, cachedBrokerInfo$1), List$.MODULE$.canBuildFrom());
            topicMetadata = new TopicMetadata(topic$2, partitionMetadata, TopicMetadata$.MODULE$.init$default$3());
        } else {
            topicMetadata = new TopicMetadata(topic$2, (Seq)Seq$.MODULE$.empty(), ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode());
        }
        return topicMetadata;
    }

    public final Seq kafka$admin$AdminUtils$$getBrokerInfoFromCache(ZkClient zkClient$4, scala.collection.mutable.Map cachedBrokerInfo$3, Seq brokerIds) {
        ObjectRef failedBrokerIds$1 = new ObjectRef(new ListBuffer());
        Seq brokerMetadata = brokerIds.map(new anonfun.7(zkClient$4, cachedBrokerInfo$3, failedBrokerIds$1), Seq$.MODULE$.canBuildFrom());
        return ((TraversableLike)brokerMetadata.filter(new anonfun$kafka$admin$AdminUtils$$getBrokerInfoFromCache$1())).map(new anonfun$kafka$admin$AdminUtils$$getBrokerInfoFromCache$2(), Seq$.MODULE$.canBuildFrom());
    }

    public final int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.rand = new Random();
        this.TopicConfigChangeZnodePrefix = "config_change_";
    }
}

