/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class LogisticGrowth
extends ExponentialGrowth {
    double lowLimit = 0.0;
    private double c;

    public LogisticGrowth(Units.Type type) {
        super(type);
    }

    public void setShape(double d) {
        this.c = d;
    }

    public double getShape() {
        return this.c;
    }

    public void setTime50(double d) {
        this.c = 1.0 / (Math.exp(this.getGrowthRate() * d) - 2.0);
    }

    public void setShapeFromTimeAtAlpha(double d, double d2) {
        double d3 = Math.exp(-this.getGrowthRate() * d);
        this.c = (1.0 - d2) * d3 / (d3 - d2);
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getShape();
        double d5 = Math.exp(-d3 * d);
        return this.lowLimit + d2 * (1.0 + d4) * d5 / (d4 + d5);
    }

    @Override
    public double getLogDemographic(double d) {
        double d2 = this.getDemographic(d);
        if (d2 == 0.0 && this.lowLimit == 0.0) {
            double d3 = this.getN0();
            double d4 = this.getGrowthRate();
            double d5 = this.getShape();
            int n = d5 > 0.0 ? 1 : -1;
            double d6 = Math.log(d5 * (double)n) + d4 * d;
            double d7 = Math.log(d3);
            if (d6 < 600.0) {
                double d8 = (double)n * Math.exp(d6);
                d7 = d5 > -1.0 ? (d7 += Math.log1p(d5) - Math.log1p(d8)) : (d7 += Math.log((1.0 + d5) / (1.0 + d8)));
            } else {
                d7 += Math.log1p(d5) - (double)n * d6;
            }
            return d7;
        }
        return Math.log(d2);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getShape();
        double d5 = Math.exp(d3 * d);
        if (this.lowLimit == 0.0) {
            return (d4 * (d5 - 1.0) / d3 + d) / ((1.0 + d4) * d2);
        }
        double d6 = this.lowLimit;
        return (d3 * d * d6 + (1.0 + d4) * d2 * Math.log(d2 + d4 * d2 + d6 + d4 * d5 * d6)) / (d3 * d6 * (d2 + d4 * d2 + d6));
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3;
        double d4;
        if (this.lowLimit > 0.0) {
            double d5 = this.getNumericalIntegral(d, d2);
            double d6 = this.getIntensity(d2) - this.getIntensity(d);
            return d6;
        }
        double d7 = d2 - d;
        double d8 = this.getN0();
        double d9 = this.getGrowthRate();
        double d10 = this.getShape();
        double d11 = Math.exp(-d9 * d);
        double d12 = Math.exp(-d9 * d7);
        double d13 = d8 * (1.0 + d10);
        if (d13 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d14 = d10 * (1.0 - d12);
        double d15 = d13 * d11 * d9 * d12;
        if (d15 == 0.0) {
            d4 = d12 < 1.0E-8 ? -d9 * d7 : Math.log1p(d12);
            int n = d10 > 0.0 ? 1 : -1;
            d3 = (double)n / d13 * Math.exp(d4 + d9 * d + Math.log(d10 * (double)n) - Math.log(d9));
        } else {
            d3 = d14 / d15;
        }
        d4 = d7 / d13;
        return d4 + d3;
    }

    @Override
    public int getNumArguments() {
        return 3;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "c";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getShape();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setShape(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public DemographicFunction getCopy() {
        LogisticGrowth logisticGrowth = new LogisticGrowth(this.getUnits());
        logisticGrowth.setN0(this.getN0());
        logisticGrowth.setGrowthRate(this.getGrowthRate());
        logisticGrowth.c = this.c;
        return logisticGrowth;
    }
}

