/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.distance;

import dr.evolution.alignment.PatternList;
import dr.evolution.distance.DistanceMatrix;

public class F84DistanceMatrix
extends DistanceMatrix {
    private int stateCount;
    private double constA;
    private double constB;
    private double constC;

    public F84DistanceMatrix() {
    }

    public F84DistanceMatrix(PatternList patternList) {
        super(patternList);
    }

    @Override
    public void setPatterns(PatternList patternList) {
        super.setPatterns(patternList);
        double[] dArray = patternList.getStateFrequencies();
        this.stateCount = patternList.getStateCount();
        if (this.stateCount != 4) {
            throw new IllegalArgumentException("F84DistanceMatrix must have nucleotide patterns");
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = d + d3;
        double d6 = d2 + d4;
        this.constA = d * d3 / d5 + d2 * d4 / d6;
        this.constB = d * d3 + d2 * d4;
        this.constC = d5 * d6;
    }

    @Override
    protected double calculatePairwiseDistance(int n, int n2) {
        double d;
        int n3 = this.patterns.getPatternCount();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n3; ++i) {
            int[] nArray = this.patterns.getPattern(i);
            int n4 = nArray[n];
            int n5 = nArray[n2];
            double d5 = this.patterns.getPatternWeight(i);
            if (!this.dataType.isAmbiguousState(n4) && !this.dataType.isAmbiguousState(n5) && n4 != n5) {
                if (n4 == 0 && n5 == 2 || n4 == 2 && n5 == 0) {
                    d2 += d5;
                } else {
                    d3 += d5;
                }
            }
            d4 += d5;
        }
        double d6 = d2 / d4;
        double d7 = d3 / d4;
        double d8 = Math.log(1.0 - d6 / (2.0 * this.constA) - (this.constA - this.constB) * d7 / (2.0 * this.constA * this.constC));
        double d9 = -(2.0 * this.constA * d8) + 2.0 * (this.constA - this.constB - this.constC) * (d = Math.log(1.0 - d7 / (2.0 * this.constC)));
        if (d9 < 1000.0) {
            return d9;
        }
        return 1000.0;
    }
}

